/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.impl;

import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.SysUser;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.ISysPermissionService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.ISysRoleService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.SysMenuService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysPermissionService
implements ISysPermissionService<SysUser> {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private SysMenuService menuService;

    public Set<String> getRolePermission(SysUser user) {
        HashSet<String> roles = new HashSet<String>();
        if (user.isAdmin()) {
            roles.add("admin");
        } else {
            roles.addAll(this.roleService.selectRolePermissionByUserId(user.getId()));
        }
        return roles;
    }

    @Override
    public Set<String> getMenuPermission(SysUser user, String clientId) {
        SysUser.getMenuPermissions(user);
        HashSet<String> perms = new HashSet<String>();
        if (user.isAdmin()) {
            perms.add("*:*:*");
        } else {
            perms.addAll(this.menuService.selectMenuPermsByUserId(user.getId(), clientId));
        }
        return perms;
    }

    @Override
    public Set<String> getRolePermission(SysUser user, String clientId) {
        HashSet<String> roles = new HashSet<String>();
        if (user.isAdmin()) {
            roles.add("admin");
        } else {
            roles.addAll(this.roleService.selectRolePermissionByUserId(user.getId()));
        }
        return roles;
    }
}

