/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.impl;

import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.MetaVo;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.RouterVo;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.SysMenu;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.mapper.SysMenuMapper;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.SysMenuService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuServiceImpl
implements SysMenuService {
    @Autowired
    private SysMenuMapper sysMenuMapper;

    @Override
    public Set<String> selectMenuPermsByUserId(String userId, String clientId) {
        List<String> perms = null;
        try {
            perms = this.sysMenuMapper.selectMenuPermsByUserIdAndClientId(userId, clientId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty((CharSequence)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public List<SysMenu> selectMenuTreeByUserId(String clientId, String userId) {
        List<SysMenu> menus = null;
        menus = StringUtils.isNotEmpty((CharSequence)userId) && "1".equals(userId) ? this.sysMenuMapper.selectMenuByClientId(clientId) : this.sysMenuMapper.selectMenuTreeByUserIdAndClientId(userId, clientId);
        return this.getChildPerms(menus, "0");
    }

    @Override
    public List<RouterVo> buildMenus(List<SysMenu> menus) {
        LinkedList<RouterVo> routers = new LinkedList<RouterVo>();
        for (SysMenu menu : menus) {
            RouterVo router = new RouterVo();
            router.setHidden("1".equals(menu.getVisible()));
            router.setName(this.getRouteName(menu));
            router.setPath(this.getRouterPath(menu));
            router.setComponent(this.getComponent(menu));
            router.setIsFrame(menu.getIsFrame());
            router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtils.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getRemark()));
            List<SysMenu> cMenus = menu.getChildren();
            if (!cMenus.isEmpty() && cMenus.size() > 0 && "M".equals(menu.getMenuType())) {
                router.setAlwaysShow(true);
                router.setRedirect("noRedirect");
                router.setChildren(this.buildMenus(cMenus));
            } else if (this.isMeunFrame(menu)) {
                ArrayList<RouterVo> childrenList = new ArrayList<RouterVo>();
                RouterVo children = new RouterVo();
                children.setPath(menu.getPath());
                children.setComponent(menu.getComponent());
                children.setName(StringUtils.capitalize((String)menu.getPath()));
                children.setIsFrame(menu.getIsFrame());
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtils.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getRemark()));
                childrenList.add(children);
                router.setChildren(childrenList);
            }
            routers.add(router);
        }
        return routers;
    }

    public boolean isMeunFrame(SysMenu menu) {
        return "0".equals(menu.getParentId()) && "C".equals(menu.getMenuType()) && menu.getIsFrame().equals("1");
    }

    public String getRouterPath(SysMenu menu) {
        String routerPath = menu.getPath();
        if ("0".equals(menu.getParentId()) && "M".equals(menu.getMenuType()) && "1".equals(menu.getIsFrame())) {
            routerPath = "/" + menu.getPath();
        } else if (this.isMeunFrame(menu)) {
            routerPath = "/";
        }
        return routerPath;
    }

    public String getComponent(SysMenu menu) {
        String component = "Layout";
        if (StringUtils.isNotEmpty((CharSequence)menu.getComponent()) && !this.isMeunFrame(menu)) {
            component = menu.getComponent();
        } else if (StringUtils.isEmpty((CharSequence)menu.getComponent()) && this.isParentView(menu)) {
            component = "ParentView";
        }
        return component;
    }

    public boolean isParentView(SysMenu menu) {
        return !"0".equals(menu.getParentId()) && "M".equals(menu.getMenuType());
    }

    public String getRouteName(SysMenu menu) {
        String routerName = StringUtils.capitalize((String)menu.getPath());
        if (this.isMeunFrame(menu)) {
            routerName = "";
        }
        return routerName;
    }

    public List<SysMenu> getChildPerms(List<SysMenu> list, String parentId) {
        ArrayList<SysMenu> returnList = new ArrayList<SysMenu>();
        for (SysMenu t : list) {
            if (!parentId.equals(t.getParentId())) continue;
            this.recursionFn(list, t);
            returnList.add(t);
        }
        return returnList;
    }

    private void recursionFn(List<SysMenu> list, SysMenu t) {
        List<SysMenu> childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysMenu tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
        ArrayList<SysMenu> tlist = new ArrayList<SysMenu>();
        for (SysMenu n : list) {
            if (!t.getId().equals(n.getParentId())) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysMenu> list, SysMenu t) {
        return this.getChildList(list, t).size() > 0;
    }
}

