/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.config;

import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.IUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.IRouteService;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.ISysUserService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.SysUser;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.mapper.SysUserMapper;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.ISysPermissionService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.SysMenuService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.impl.IRouteServiceImpl;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.impl.SysUserServiceImpl;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.util.Threads;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class PasswordEncoderAutoConfiguration {
    private int corePoolSize = 50;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    ISysUserService<IUser> sysUserService(@Autowired SysUserMapper sysUserMapper, @Autowired ISysPermissionService<SysUser> service) {
        return new SysUserServiceImpl(sysUserMapper, service);
    }

    @Bean
    IRouteService routeService(SysMenuService menuService) {
        return new IRouteServiceImpl(menuService);
    }

    @Bean(name={"scheduledExecutorService"})
    protected ScheduledExecutorService scheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(this.corePoolSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("schedule-pool-%d").daemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                Threads.printException(r, t);
            }
        };
    }
}

