/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity;

import cn.hutool.core.collection.CollectionUtil;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2Dept;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class Oauth2User
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private String clientId;
    private String userId;
    private String deptId;
    private String token;
    private Long loginTime;
    private Long expireTime;
    private String ipaddr;
    private String loginLocation;
    private String browser;
    private String os;
    private Set<String> menuPermissions;
    private Set<String> rolePermissions;
    private String username;
    private String password;
    private String loginName;
    private String loginIp;
    private Oauth2Dept dept;
    private List<Oauth2Role> roles;
    private String salt;
    private String avatar;
    private String userJson;
    private String[] roleKeys;
    private String email;
    private String phonenumber;
    private String sex;
    private String status;
    private String delFlag;
    private Date loginDate;
    private Date pwdUpdateDate;

    public String getUserJson() {
        return this.userJson;
    }

    public void setUserJson(String userJson) {
        this.userJson = userJson;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities;
        block3: {
            block2: {
                grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
                if (!CollectionUtil.isNotEmpty(this.roles)) break block2;
                for (Oauth2Role role : this.roles) {
                    SimpleGrantedAuthority authority = new SimpleGrantedAuthority(role.getRoleKey());
                    grantedAuthorities.add(authority);
                }
                break block3;
            }
            if (this.roleKeys == null || this.roleKeys.length <= 0) break block3;
            for (String roleKey : this.roleKeys) {
                SimpleGrantedAuthority authority = new SimpleGrantedAuthority(roleKey);
                grantedAuthorities.add(authority);
            }
        }
        return grantedAuthorities;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Oauth2User setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getToken() {
        return this.token;
    }

    public Long getLoginTime() {
        return this.loginTime;
    }

    public Long getExpireTime() {
        return this.expireTime;
    }

    public String getIpaddr() {
        return this.ipaddr;
    }

    public String getLoginLocation() {
        return this.loginLocation;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getOs() {
        return this.os;
    }

    public Set<String> getMenuPermissions() {
        return this.menuPermissions;
    }

    public Set<String> getRolePermissions() {
        return this.rolePermissions;
    }

    public Oauth2User setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public Oauth2User setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public Oauth2User setToken(String token) {
        this.token = token;
        return this;
    }

    public Oauth2User setLoginTime(Long loginTime) {
        this.loginTime = loginTime;
        return this;
    }

    public Oauth2User setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public Oauth2User setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
        return this;
    }

    public Oauth2User setLoginLocation(String loginLocation) {
        this.loginLocation = loginLocation;
        return this;
    }

    public Oauth2User setBrowser(String browser) {
        this.browser = browser;
        return this;
    }

    public Oauth2User setOs(String os) {
        this.os = os;
        return this;
    }

    public Oauth2User setMenuPermissions(Set<String> menuPermissions) {
        this.menuPermissions = menuPermissions;
        return this;
    }

    public Oauth2User setRolePermissions(Set<String> rolePermissions) {
        this.rolePermissions = rolePermissions;
        return this;
    }

    public Oauth2User setUsername(String username) {
        this.username = username;
        return this;
    }

    public Oauth2User setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public Oauth2User setLoginName(String loginName) {
        this.loginName = loginName;
        return this;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public Oauth2User setLoginIp(String loginIp) {
        this.loginIp = loginIp;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public Oauth2Dept getDept() {
        return this.dept;
    }

    public Oauth2User setDept(Oauth2Dept dept) {
        this.dept = dept;
        return this;
    }

    public List<Oauth2Role> getRoles() {
        return this.roles;
    }

    public Oauth2User setRoles(List<Oauth2Role> roles) {
        this.roles = roles;
        return this;
    }

    public String getSalt() {
        return this.salt;
    }

    public Oauth2User setSalt(String salt) {
        this.salt = salt;
        return this;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public Oauth2User setAvatar(String avatar) {
        this.avatar = avatar;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Oauth2User setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhonenumber() {
        return this.phonenumber;
    }

    public Oauth2User setPhonenumber(String phonenumber) {
        this.phonenumber = phonenumber;
        return this;
    }

    public String getSex() {
        return this.sex;
    }

    public Oauth2User setSex(String sex) {
        this.sex = sex;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Oauth2User setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getDelFlag() {
        return this.delFlag;
    }

    public Oauth2User setDelFlag(String delFlag) {
        this.delFlag = delFlag;
        return this;
    }

    public Date getLoginDate() {
        return this.loginDate;
    }

    public Oauth2User setLoginDate(Date loginDate) {
        this.loginDate = loginDate;
        return this;
    }

    public Date getPwdUpdateDate() {
        return this.pwdUpdateDate;
    }

    public Oauth2User setPwdUpdateDate(Date pwdUpdateDate) {
        this.pwdUpdateDate = pwdUpdateDate;
        return this;
    }

    public String[] getRoleKeys() {
        return this.roleKeys;
    }

    public void setRoleKeys(String[] roleKeys) {
        this.roleKeys = roleKeys;
    }
}

