/*
 * Decompiled with CFR 0.152.
 */
package com.justtoplay.xxl.job.plus.thread;

import com.justtoplay.xxl.job.plus.discovery.DiscoveryProvider;
import com.justtoplay.xxl.job.plus.event.ServiceUpEvent;
import com.justtoplay.xxl.job.plus.util.SpringContextUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class GetDiscoveryStatusThread {
    private static final Logger logger = LoggerFactory.getLogger(GetDiscoveryStatusThread.class);
    private static GetDiscoveryStatusThread instance = new GetDiscoveryStatusThread();
    private Thread getResisterStatusThread;
    private volatile boolean toStop = false;
    private static final int INTERVAL = 3;

    public static GetDiscoveryStatusThread getInstance() {
        return instance;
    }

    public void start(String address, String serviceName, DiscoveryProvider discoveryProvider) {
        if (address == null || address.trim().length() == 0) {
            logger.warn(">>>>>>>>>>> xxl-job-plus, executor get discovery status fail, address is null.");
            return;
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            logger.warn(">>>>>>>>>>> xxl-job-plus, executor get discovery status fail, serviceName is null.");
            return;
        }
        if (discoveryProvider == null) {
            logger.warn(">>>>>>>>>>> xxl-job-plus, executor get discovery status fail, discoveryProvider is null.");
            return;
        }
        if (this.getResisterStatusThread == null) {
            this.getResisterStatusThread = new Thread(() -> {
                while (!this.toStop) {
                    block6: {
                        try {
                            List<String> addressList = discoveryProvider.getServiceAddressList(serviceName);
                            if (addressList.contains(address)) {
                                SpringContextUtil.getApplicationContext().publishEvent((ApplicationEvent)new ServiceUpEvent(this));
                                this.toStop = true;
                            }
                        }
                        catch (Exception e) {
                            if (this.toStop) break block6;
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        if (this.toStop) continue;
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (InterruptedException e) {
                        if (this.toStop) continue;
                        logger.warn(">>>>>>>>>>> xxl-job-plus, executor get discovery status thread interrupted, error msg:{}", (Object)e.getMessage());
                    }
                }
            });
            this.getResisterStatusThread.setDaemon(true);
            this.getResisterStatusThread.setName("xxl-job-plus, executor GetDiscoveryStatusThread");
        }
        this.getResisterStatusThread.start();
    }

    public void toStop() {
        this.toStop = true;
        if (this.getResisterStatusThread != null) {
            this.getResisterStatusThread.interrupt();
            try {
                this.getResisterStatusThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

