/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.mapper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.Utils;
import java.util.Set;

public interface Mapper {
    public Set<ConvertiblePair> getConvertibleTypes();

    public Object convert(Object var1, Class<?> var2, Class<?> var3, Configuration var4);

    public static final class ConvertiblePair {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        public ConvertiblePair(Class<?> sourceType, Class<?> targetType) {
            Utils.notNull(sourceType, "Source type must not be null", new Object[0]);
            Utils.notNull(targetType, "Target type must not be null", new Object[0]);
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConvertiblePair)) {
                return false;
            }
            ConvertiblePair that = (ConvertiblePair)o;
            if (!this.sourceType.equals(that.sourceType)) {
                return false;
            }
            return this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            int result = this.sourceType.hashCode();
            result = 31 * result + this.targetType.hashCode();
            return result;
        }

        public String toString() {
            return this.sourceType.getName() + " -> " + this.targetType.getName();
        }
    }
}

