/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.mapper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.spi.mapper.DateMapper;
import com.jayway.jsonpath.internal.spi.mapper.Mapper;
import com.jayway.jsonpath.internal.spi.mapper.NumberMapper;
import com.jayway.jsonpath.internal.spi.mapper.StringMapper;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMappingProvider
implements MappingProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMappingProvider.class);
    private HashMap<Class<?>, HashMap<Class<?>, Mapper>> converters = new HashMap();

    public DefaultMappingProvider() {
        this.addMapper(new NumberMapper());
        this.addMapper(new StringMapper());
        this.addMapper(new DateMapper());
    }

    protected void addMapper(Mapper converter) {
        for (Mapper.ConvertiblePair convertible : converter.getConvertibleTypes()) {
            if (!this.converters.containsKey(convertible.getTargetType())) {
                this.converters.put(convertible.getTargetType(), new HashMap());
            }
            this.converters.get(convertible.getTargetType()).put(convertible.getSourceType(), converter);
        }
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        HashMap<Class<?>, Mapper> targetConverters = this.converters.get(targetType);
        if (targetConverters != null) {
            Mapper mapper = targetConverters.get(source.getClass());
            if (mapper != null) {
                return (T)mapper.convert(source, source.getClass(), targetType, configuration);
            }
            mapper = targetConverters.get(Object.class);
            if (mapper != null) {
                return (T)mapper.convert(source, source.getClass(), targetType, configuration);
            }
        }
        return (T)source;
    }
}

