/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;

public class RoundDotsBorder
extends Border {
    private static final float GAP_MODIFIER = 2.5f;

    public RoundDotsBorder(float width) {
        super(width);
    }

    public RoundDotsBorder(Color color, float width) {
        super(color, width);
    }

    public RoundDotsBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = super.getDotsGap(borderLength, initialGap);
        float[] startingPoints = this.getStartingPointsForBorderSide(x1, y1, x2, y2, defaultSide);
        x1 = startingPoints[0];
        y1 = startingPoints[1];
        x2 = startingPoints[2];
        y2 = startingPoints[3];
        canvas.saveState().setStrokeColor(this.transparentColor.getColor()).setLineWidth(this.width).setLineCapStyle(1);
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = super.getDotsGap(borderLength, initialGap);
        boolean isHorizontal = false;
        if (Math.abs(y2 - y1) < 5.0E-4f) {
            isHorizontal = true;
        }
        if (isHorizontal) {
            x2 -= this.width;
        }
        canvas.saveState();
        canvas.setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width);
        canvas.setLineCapStyle(1);
        canvas.setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke();
        canvas.restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = super.getDotsGap(borderLength, initialGap);
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).setLineCapStyle(1).setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f);
        Rectangle boundingRectangle = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        float[] horizontalRadii = new float[]{horizontalRadius1, horizontalRadius2};
        float[] verticalRadii = new float[]{verticalRadius1, verticalRadius2};
        this.drawDiscontinuousBorders(canvas, boundingRectangle, horizontalRadii, verticalRadii, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    @Override
    @Deprecated
    protected float getDotsGap(double distance, float initialGap) {
        return super.getDotsGap(distance, initialGap);
    }
}

