/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageHelper;
import com.itextpdf.kernel.pdf.xobject.PdfTransparencyGroup;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;

public class PdfFormXObject
extends PdfXObject {
    private static final long serialVersionUID = 467500482711722178L;
    protected PdfResources resources = null;

    public PdfFormXObject(Rectangle bBox) {
        super(new PdfStream());
        ((PdfStream)this.getPdfObject()).put(PdfName.Type, PdfName.XObject);
        ((PdfStream)this.getPdfObject()).put(PdfName.Subtype, PdfName.Form);
        if (bBox != null) {
            ((PdfStream)this.getPdfObject()).put(PdfName.BBox, new PdfArray(bBox));
        }
    }

    public PdfFormXObject(PdfStream pdfStream) {
        super(pdfStream);
        if (!((PdfStream)this.getPdfObject()).containsKey(PdfName.Subtype)) {
            ((PdfStream)this.getPdfObject()).put(PdfName.Subtype, PdfName.Form);
        }
    }

    public PdfFormXObject(PdfPage page) {
        this(page.getCropBox());
        ((PdfStream)this.getPdfObject()).getOutputStream().writeBytes(page.getContentBytes());
        this.resources = new PdfResources((PdfDictionary)((PdfDictionary)page.getResources().getPdfObject()).clone());
        ((PdfStream)this.getPdfObject()).put(PdfName.Resources, (PdfObject)this.resources.getPdfObject());
    }

    public PdfFormXObject(WmfImageData image, PdfDocument pdfDocument) {
        this((PdfStream)new WmfImageHelper(image).createFormXObject(pdfDocument).getPdfObject());
    }

    public static Rectangle calculateBBoxMultipliedByMatrix(PdfFormXObject form) {
        PdfArray pdfArrayBBox = ((PdfStream)form.getPdfObject()).getAsArray(PdfName.BBox);
        if (pdfArrayBBox == null) {
            throw new PdfException("PdfFormXObject has invalid BBox.");
        }
        float[] bBoxArray = pdfArrayBBox.toFloatArray();
        PdfArray pdfArrayMatrix = ((PdfStream)form.getPdfObject()).getAsArray(PdfName.Matrix);
        float[] matrixArray = pdfArrayMatrix == null ? new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f} : pdfArrayMatrix.toFloatArray();
        Matrix matrix = new Matrix(matrixArray[0], matrixArray[1], matrixArray[2], matrixArray[3], matrixArray[4], matrixArray[5]);
        Vector bBoxMin = new Vector(bBoxArray[0], bBoxArray[1], 1.0f);
        Vector bBoxMax = new Vector(bBoxArray[2], bBoxArray[3], 1.0f);
        Vector bBoxMinByMatrix = bBoxMin.cross(matrix);
        Vector bBoxMaxByMatrix = bBoxMax.cross(matrix);
        float width = bBoxMaxByMatrix.get(0) - bBoxMinByMatrix.get(0);
        float height = bBoxMaxByMatrix.get(1) - bBoxMinByMatrix.get(1);
        return new Rectangle(bBoxMinByMatrix.get(0), bBoxMinByMatrix.get(1), width, height);
    }

    public PdfResources getResources() {
        if (this.resources == null) {
            PdfDictionary resourcesDict = ((PdfStream)this.getPdfObject()).getAsDictionary(PdfName.Resources);
            if (resourcesDict == null) {
                resourcesDict = new PdfDictionary();
                ((PdfStream)this.getPdfObject()).put(PdfName.Resources, resourcesDict);
            }
            this.resources = new PdfResources(resourcesDict);
        }
        return this.resources;
    }

    public PdfArray getBBox() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.BBox);
    }

    public PdfFormXObject setBBox(PdfArray bBox) {
        return this.put(PdfName.BBox, bBox);
    }

    public PdfFormXObject setGroup(PdfTransparencyGroup transparency) {
        return this.put(PdfName.Group, (PdfObject)transparency.getPdfObject());
    }

    @Override
    public float getWidth() {
        return this.getBBox() == null ? 0.0f : this.getBBox().getAsNumber(2).floatValue() - this.getBBox().getAsNumber(0).floatValue();
    }

    @Override
    public float getHeight() {
        return this.getBBox() == null ? 0.0f : this.getBBox().getAsNumber(3).floatValue() - this.getBBox().getAsNumber(1).floatValue();
    }

    @Override
    public void flush() {
        this.resources = null;
        if (((PdfStream)this.getPdfObject()).get(PdfName.BBox) == null) {
            throw new PdfException("Form XObject must have BBox.");
        }
        super.flush();
    }

    public PdfFormXObject setProcessColorModel(PdfName model) {
        return this.put(PdfName.PCM, model);
    }

    public PdfName getProcessColorModel() {
        return ((PdfStream)this.getPdfObject()).getAsName(PdfName.PCM);
    }

    public PdfFormXObject setSeparationColorNames(PdfArray colorNames) {
        return this.put(PdfName.SeparationColorNames, colorNames);
    }

    public PdfArray getSeparationColorNames() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.SeparationColorNames);
    }

    public PdfFormXObject setTrapRegions(PdfArray regions) {
        return this.put(PdfName.TrapRegions, regions);
    }

    public PdfArray getTrapRegions() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.TrapRegions);
    }

    public PdfFormXObject setTrapStyles(PdfString trapStyles) {
        return this.put(PdfName.TrapStyles, trapStyles);
    }

    public PdfString getTrapStyles() {
        return ((PdfStream)this.getPdfObject()).getAsString(PdfName.TrapStyles);
    }

    public PdfFormXObject setMarkStyle(PdfString markStyle) {
        return this.put(PdfName.MarkStyle, markStyle);
    }

    public PdfString getMarkStyle() {
        return ((PdfStream)this.getPdfObject()).getAsString(PdfName.MarkStyle);
    }

    public PdfFormXObject put(PdfName key, PdfObject value) {
        ((PdfStream)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }
}

