/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.wmf;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.util.UrlUtil;
import com.itextpdf.kernel.PdfException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class WmfImageData
extends ImageData {
    private static final byte[] wmf = new byte[]{-41, -51};

    public WmfImageData(String fileName) throws MalformedURLException {
        this(UrlUtil.toURL((String)fileName));
    }

    public WmfImageData(URL url) {
        super(url, ImageType.WMF);
        byte[] imageType = WmfImageData.readImageType(url);
        if (!WmfImageData.imageTypeIs(imageType, wmf)) {
            throw new PdfException("Not a WMF image.");
        }
    }

    public WmfImageData(byte[] bytes) {
        super(bytes, ImageType.WMF);
        byte[] imageType = WmfImageData.readImageType(this.url);
        if (!WmfImageData.imageTypeIs(imageType, wmf)) {
            throw new PdfException("Not a WMF image.");
        }
    }

    private static boolean imageTypeIs(byte[] imageType, byte[] compareWith) {
        for (int i = 0; i < compareWith.length; ++i) {
            if (imageType[i] == compareWith[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] readImageType(URL source) {
        InputStream is = null;
        try {
            is = source.openStream();
            byte[] bytes = new byte[8];
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new PdfException("I/O exception.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

