/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.CFFFontSubset;
import com.itextpdf.io.font.CMapEncoding;
import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.CidFontProperties;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.cmap.CMapContentParser;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.DocTrueTypeFont;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfType0Font
extends PdfFont {
    private static final long serialVersionUID = -8033620300884193397L;
    private static final byte[] rotbits = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    protected static final int CID_FONT_TYPE_0 = 0;
    protected static final int CID_FONT_TYPE_2 = 2;
    protected boolean vertical;
    protected CMapEncoding cmapEncoding;
    protected Set<Integer> longTag;
    protected int cidFontType;
    protected char[] specificUnicodeDifferences;

    PdfType0Font(TrueTypeFont ttf, String cmap) {
        if (!cmap.equals("Identity-H") && !cmap.equals("Identity-V")) {
            throw new PdfException("Only Identity CMaps supports with truetype");
        }
        if (!ttf.getFontNames().allowEmbedding()) {
            throw new PdfException("{0} cannot be embedded due to licensing restrictions.").setMessageParams(ttf.getFontNames().getFontName() + ttf.getFontNames().getStyle());
        }
        this.fontProgram = ttf;
        this.embedded = true;
        this.vertical = cmap.endsWith("V");
        this.cmapEncoding = new CMapEncoding(cmap);
        this.longTag = new HashSet<Integer>();
        this.cidFontType = 2;
        if (ttf.isFontSpecific()) {
            this.specificUnicodeDifferences = new char[256];
            byte[] bytes = new byte[1];
            for (int k = 0; k < 256; ++k) {
                int ch;
                bytes[0] = (byte)k;
                String s = PdfEncodings.convertToString((byte[])bytes, null);
                this.specificUnicodeDifferences[k] = ch = s.length() > 0 ? (int)s.charAt(0) : 63;
            }
        }
    }

    PdfType0Font(CidFont font, String cmap) {
        if (!CidFontProperties.isCidFont((String)font.getFontNames().getFontName(), (String)cmap)) {
            throw new PdfException("font.1.with.2.encoding.is.not.a.cjk.font").setMessageParams(font.getFontNames().getFontName(), cmap);
        }
        this.fontProgram = font;
        this.vertical = cmap.endsWith("V");
        String uniMap = this.getCompatibleUniMap(this.fontProgram.getRegistry());
        this.cmapEncoding = new CMapEncoding(cmap, uniMap);
        this.longTag = new HashSet<Integer>();
        this.cidFontType = 0;
    }

    PdfType0Font(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.newFont = false;
        PdfDictionary cidFont = fontDictionary.getAsArray(PdfName.DescendantFonts).getAsDictionary(0);
        String cmap = fontDictionary.getAsName(PdfName.Encoding).getValue();
        if ("Identity-H".equals(cmap) || "Identity-V".equals(cmap)) {
            String uniMap;
            PdfObject toUnicode = fontDictionary.get(PdfName.ToUnicode);
            CMapToUnicode toUnicodeCMap = FontUtil.processToUnicode(toUnicode);
            if (toUnicodeCMap == null && (toUnicodeCMap = FontUtil.getToUnicodeFromUniMap(uniMap = PdfType0Font.getUniMapFromOrdering(PdfType0Font.getOrdering(cidFont)))) == null) {
                toUnicodeCMap = FontUtil.getToUnicodeFromUniMap("Identity-H");
                Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                logger.error(MessageFormatUtil.format((String)"Unknown CMap {0}", (Object[])new Object[]{uniMap}));
            }
            this.fontProgram = DocTrueTypeFont.createFontProgram(cidFont, toUnicodeCMap);
            this.cmapEncoding = new CMapEncoding(cmap);
            assert (this.fontProgram instanceof IDocFontProgram);
            this.embedded = ((IDocFontProgram)this.fontProgram).getFontFile() != null;
            this.cidFontType = 2;
        } else {
            String cidFontName = cidFont.getAsName(PdfName.BaseFont).getValue();
            String uniMap = PdfType0Font.getUniMapFromOrdering(PdfType0Font.getOrdering(cidFont));
            if (uniMap != null && uniMap.startsWith("Uni") && CidFontProperties.isCidFont((String)cidFontName, (String)uniMap)) {
                try {
                    this.fontProgram = FontProgramFactory.createFont((String)cidFontName);
                    this.cmapEncoding = new CMapEncoding(cmap, uniMap);
                    this.embedded = false;
                }
                catch (java.io.IOException ignored) {
                    this.fontProgram = null;
                    this.cmapEncoding = null;
                }
            } else {
                CMapToUnicode toUnicodeCMap = FontUtil.getToUnicodeFromUniMap(uniMap);
                if (toUnicodeCMap != null) {
                    this.fontProgram = DocTrueTypeFont.createFontProgram(cidFont, toUnicodeCMap);
                    this.cmapEncoding = new CMapEncoding(cmap, uniMap);
                }
            }
            if (this.fontProgram == null) {
                throw new PdfException(MessageFormatUtil.format((String)"Cannot recognise document font {0} with {1} encoding", (Object[])new Object[]{cidFontName, cmap}));
            }
            this.cidFontType = 0;
        }
        this.longTag = new HashSet<Integer>();
        this.subset = false;
    }

    public static String getUniMapFromOrdering(String ordering) {
        switch (ordering) {
            case "CNS1": {
                return "UniCNS-UTF16-H";
            }
            case "Japan1": {
                return "UniJIS-UTF16-H";
            }
            case "Korea1": {
                return "UniKS-UTF16-H";
            }
            case "GB1": {
                return "UniGB-UTF16-H";
            }
            case "Identity": {
                return "Identity-H";
            }
        }
        return null;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        Glyph glyph = this.getFontProgram().getGlyph(unicode);
        if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null) {
            Glyph notdef = this.getFontProgram().getGlyphByCode(0);
            glyph = notdef != null ? new Glyph(notdef, unicode) : new Glyph(-1, 0, unicode);
            this.notdefGlyphs.put(unicode, glyph);
        }
        return glyph;
    }

    @Override
    public boolean containsGlyph(int unicode) {
        if (this.cidFontType == 0) {
            if (this.cmapEncoding.isDirect()) {
                return this.fontProgram.getGlyphByCode(unicode) != null;
            }
            return this.getFontProgram().getGlyph(unicode) != null;
        }
        if (this.cidFontType == 2) {
            if (this.fontProgram.isFontSpecific()) {
                byte[] b = PdfEncodings.convertToBytes((char)((char)unicode), (String)"symboltt");
                return b.length > 0 && this.fontProgram.getGlyph(b[0] & 0xFF) != null;
            }
            return this.getFontProgram().getGlyph(unicode) != null;
        }
        throw new PdfException("Invalid CID font type: " + this.cidFontType);
    }

    @Override
    public byte[] convertToBytes(String text) {
        int len = text.length();
        ByteBuffer buffer = new ByteBuffer();
        boolean i = false;
        if (this.fontProgram.isFontSpecific()) {
            byte[] b = PdfEncodings.convertToBytes((String)text, (String)"symboltt");
            len = b.length;
            for (int k = 0; k < len; ++k) {
                Glyph glyph = this.fontProgram.getGlyph(b[k] & 0xFF);
                if (glyph == null) continue;
                this.convertToBytes(glyph, buffer);
            }
        } else {
            for (int k = 0; k < len; ++k) {
                int val;
                if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                    val = TextUtil.convertToUtf32((String)text, (int)k);
                    ++k;
                } else {
                    val = text.charAt(k);
                }
                Glyph glyph = this.getGlyph(val);
                if (glyph.getCode() > 0) {
                    this.convertToBytes(glyph, buffer);
                    continue;
                }
                int nullCode = this.cmapEncoding.getCmapCode(0);
                buffer.append(nullCode >> 8);
                buffer.append(nullCode);
            }
        }
        return buffer.toByteArray();
    }

    @Override
    public byte[] convertToBytes(GlyphLine glyphLine) {
        if (glyphLine != null) {
            byte[] bytes = new byte[glyphLine.size() * 2];
            int offset = 0;
            for (int i = 0; i < glyphLine.size(); ++i) {
                offset = this.convertToBytes(glyphLine.get(i), bytes, offset);
            }
            return bytes;
        }
        return null;
    }

    @Override
    public byte[] convertToBytes(Glyph glyph) {
        byte[] bytes = new byte[2];
        this.convertToBytes(glyph, bytes, 0);
        return bytes;
    }

    @Override
    public void writeText(GlyphLine text, int from, int to, PdfOutputStream stream) {
        int len = to - from + 1;
        if (len > 0) {
            byte[] bytes = new byte[len * 2];
            int offset = 0;
            for (int i = from; i <= to; ++i) {
                offset = this.convertToBytes(text.get(i), bytes, offset);
            }
            StreamUtil.writeHexedString((OutputStream)((Object)stream), (byte[])bytes);
        }
    }

    @Override
    public void writeText(String text, PdfOutputStream stream) {
        StreamUtil.writeHexedString((OutputStream)((Object)stream), (byte[])this.convertToBytes(text));
    }

    @Override
    public GlyphLine createGlyphLine(String content) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        if (this.cidFontType == 0) {
            int len = content.length();
            if (this.cmapEncoding.isDirect()) {
                for (int k = 0; k < len; ++k) {
                    Glyph glyph = this.fontProgram.getGlyphByCode((int)content.charAt(k));
                    if (glyph == null) continue;
                    glyphs.add(glyph);
                }
            } else {
                for (int k = 0; k < len; ++k) {
                    int ch;
                    if (TextUtil.isSurrogatePair((String)content, (int)k)) {
                        ch = TextUtil.convertToUtf32((String)content, (int)k);
                        ++k;
                    } else {
                        ch = content.charAt(k);
                    }
                    glyphs.add(this.getGlyph(ch));
                }
            }
        } else if (this.cidFontType == 2) {
            int len = content.length();
            if (this.fontProgram.isFontSpecific()) {
                byte[] b = PdfEncodings.convertToBytes((String)content, (String)"symboltt");
                len = b.length;
                for (int k = 0; k < len; ++k) {
                    Glyph glyph = this.fontProgram.getGlyph(b[k] & 0xFF);
                    if (glyph == null) continue;
                    glyphs.add(glyph);
                }
            } else {
                for (int k = 0; k < len; ++k) {
                    int val;
                    if (TextUtil.isSurrogatePair((String)content, (int)k)) {
                        val = TextUtil.convertToUtf32((String)content, (int)k);
                        ++k;
                    } else {
                        val = content.charAt(k);
                    }
                    glyphs.add(this.getGlyph(val));
                }
            }
        } else {
            throw new PdfException("font.has.no.suitable.cmap");
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public int appendGlyphs(String text, int from, int to, List<Glyph> glyphs) {
        if (this.cidFontType == 0) {
            if (this.cmapEncoding.isDirect()) {
                Glyph glyph;
                int processed = 0;
                for (int k = from; k <= to && (glyph = this.fontProgram.getGlyphByCode((int)text.charAt(k))) != null && this.isAppendableGlyph(glyph); ++k) {
                    glyphs.add(glyph);
                    ++processed;
                }
                return processed;
            }
            return this.appendUniGlyphs(text, from, to, glyphs);
        }
        if (this.cidFontType == 2) {
            if (this.fontProgram.isFontSpecific()) {
                Glyph glyph;
                int processed = 0;
                for (int k = from; k <= to && (glyph = this.fontProgram.getGlyph(text.charAt(k) & 0xFF)) != null && this.isAppendableGlyph(glyph); ++k) {
                    glyphs.add(glyph);
                    ++processed;
                }
                return processed;
            }
            return this.appendUniGlyphs(text, from, to, glyphs);
        }
        throw new PdfException("font.has.no.suitable.cmap");
    }

    private int appendUniGlyphs(String text, int from, int to, List<Glyph> glyphs) {
        int processed = 0;
        for (int k = from; k <= to; ++k) {
            int val;
            int currentlyProcessed = processed++;
            if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                val = TextUtil.convertToUtf32((String)text, (int)k);
                processed += 2;
            } else {
                val = text.charAt(k);
            }
            Glyph glyph = this.getGlyph(val);
            if (!this.isAppendableGlyph(glyph)) {
                processed = currentlyProcessed;
                break;
            }
            glyphs.add(glyph);
        }
        return processed;
    }

    @Override
    public int appendAnyGlyph(String text, int from, List<Glyph> glyphs) {
        int process = 1;
        if (this.cidFontType == 0) {
            if (this.cmapEncoding.isDirect()) {
                Glyph glyph = this.fontProgram.getGlyphByCode((int)text.charAt(from));
                if (glyph != null) {
                    glyphs.add(glyph);
                }
            } else {
                int ch;
                if (TextUtil.isSurrogatePair((String)text, (int)from)) {
                    ch = TextUtil.convertToUtf32((String)text, (int)from);
                    process = 2;
                } else {
                    ch = text.charAt(from);
                }
                glyphs.add(this.getGlyph(ch));
            }
        } else if (this.cidFontType == 2) {
            TrueTypeFont ttf = (TrueTypeFont)this.fontProgram;
            if (ttf.isFontSpecific()) {
                Glyph glyph;
                byte[] b = PdfEncodings.convertToBytes((String)text, (String)"symboltt");
                if (b.length > 0 && (glyph = this.fontProgram.getGlyph(b[0] & 0xFF)) != null) {
                    glyphs.add(glyph);
                }
            } else {
                int ch;
                if (TextUtil.isSurrogatePair((String)text, (int)from)) {
                    ch = TextUtil.convertToUtf32((String)text, (int)from);
                    process = 2;
                } else {
                    ch = text.charAt(from);
                }
                glyphs.add(this.getGlyph(ch));
            }
        } else {
            throw new PdfException("font.has.no.suitable.cmap");
        }
        return process;
    }

    private boolean isAppendableGlyph(Glyph glyph) {
        return glyph.getCode() > 0 || TextUtil.isWhitespaceOrNonPrintable((int)glyph.getUnicode());
    }

    @Override
    public String decode(PdfString content) {
        String cids = content.getValue();
        if (cids.length() == 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(cids.length() / 2);
        for (int i = 0; i < cids.length() - 1; i += 2) {
            int code = (cids.charAt(i) << 8) + cids.charAt(i + 1);
            Glyph glyph = this.fontProgram.getGlyphByCode(this.cmapEncoding.getCidCode(code));
            if (glyph != null && glyph.getChars() != null) {
                builder.append(glyph.getChars());
                continue;
            }
            builder.append('\ufffd');
        }
        return builder.toString();
    }

    @Override
    public GlyphLine decodeIntoGlyphLine(PdfString content) {
        String cids = content.getValue();
        if (cids.length() == 1) {
            return new GlyphLine(Collections.emptyList());
        }
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        for (int i = 0; i < cids.length() - 1; i += 2) {
            int code = (cids.charAt(i) << 8) + cids.charAt(i + 1);
            Glyph glyph = this.fontProgram.getGlyphByCode(this.cmapEncoding.getCidCode(code));
            if (glyph != null && glyph.getChars() != null) {
                glyphs.add(glyph);
                continue;
            }
            glyphs.add(new Glyph(0, -1));
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public float getContentWidth(PdfString content) {
        String cids = content.getValue();
        Glyph notdef = this.fontProgram.getGlyphByCode(0);
        float width = 0.0f;
        for (int i = 0; i < cids.length(); ++i) {
            int glyphCode;
            Glyph glyph;
            int code = cids.charAt(i++);
            if (i < cids.length()) {
                code <<= 8;
                code |= cids.charAt(i);
            }
            if ((glyph = this.fontProgram.getGlyphByCode(glyphCode = this.cmapEncoding.getCidCode(code))) == null) {
                Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                logger.warn(MessageFormatUtil.format((String)"Could not find glyph with the following code: {0}", (Object[])new Object[]{glyphCode}));
            }
            width += glyph != null ? (float)glyph.getWidth() : (float)notdef.getWidth();
        }
        return width;
    }

    @Override
    public void flush() {
        this.ensureUnderlyingObjectHasIndirectReference();
        if (this.newFont) {
            this.flushFontData();
        }
        super.flush();
    }

    public CMapEncoding getCmap() {
        return this.cmapEncoding;
    }

    public PdfStream getToUnicode(Object[] metrics) {
        ArrayList<Integer> unicodeGlyphs = new ArrayList<Integer>(metrics.length);
        for (int i = 0; i < metrics.length; ++i) {
            int[] metric = (int[])metrics[i];
            if (this.fontProgram.getGlyphByCode(metric[0]).getChars() == null) continue;
            unicodeGlyphs.add(metric[0]);
        }
        if (unicodeGlyphs.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        int size = 0;
        for (int k = 0; k < unicodeGlyphs.size(); ++k) {
            if (size == 0) {
                if (k != 0) {
                    buf.append("endbfrange\n");
                }
                size = Math.min(100, unicodeGlyphs.size() - k);
                buf.append(size).append(" beginbfrange\n");
            }
            --size;
            String fromTo = CMapContentParser.toHex((int)((Integer)unicodeGlyphs.get(k)));
            Glyph glyph = this.fontProgram.getGlyphByCode(((Integer)unicodeGlyphs.get(k)).intValue());
            if (glyph.getChars() == null) continue;
            StringBuilder uni = new StringBuilder(glyph.getChars().length);
            for (char ch : glyph.getChars()) {
                uni.append(PdfType0Font.toHex4(ch));
            }
            buf.append(fromTo).append(fromTo).append('<').append(uni.toString()).append('>').append('\n');
        }
        buf.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        PdfStream toUnicode = new PdfStream(PdfEncodings.convertToBytes((String)buf.toString(), null));
        this.makeObjectIndirect(toUnicode);
        return toUnicode;
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        PdfDictionary fontDescriptor = new PdfDictionary();
        this.makeObjectIndirect(fontDescriptor);
        fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
        fontDescriptor.put(PdfName.FontName, new PdfName(fontName));
        fontDescriptor.put(PdfName.FontBBox, new PdfArray(this.getFontProgram().getFontMetrics().getBbox()));
        fontDescriptor.put(PdfName.Ascent, new PdfNumber(this.getFontProgram().getFontMetrics().getTypoAscender()));
        fontDescriptor.put(PdfName.Descent, new PdfNumber(this.getFontProgram().getFontMetrics().getTypoDescender()));
        fontDescriptor.put(PdfName.CapHeight, new PdfNumber(this.getFontProgram().getFontMetrics().getCapHeight()));
        fontDescriptor.put(PdfName.ItalicAngle, new PdfNumber(this.getFontProgram().getFontMetrics().getItalicAngle()));
        fontDescriptor.put(PdfName.StemV, new PdfNumber(this.getFontProgram().getFontMetrics().getStemV()));
        fontDescriptor.put(PdfName.Flags, new PdfNumber(this.getFontProgram().getPdfFontFlags()));
        if (this.fontProgram.getFontIdentification().getPanose() != null) {
            PdfDictionary styleDictionary = new PdfDictionary();
            styleDictionary.put(PdfName.Panose, new PdfString(this.fontProgram.getFontIdentification().getPanose()).setHexWriting(true));
            fontDescriptor.put(PdfName.Style, styleDictionary);
        }
        return fontDescriptor;
    }

    protected PdfDictionary getCidFontType2(TrueTypeFont ttf, PdfDictionary fontDescriptor, String fontName, int[][] metrics) {
        PdfDictionary cidFont = new PdfDictionary();
        this.makeObjectIndirect(cidFont);
        cidFont.put(PdfName.Type, PdfName.Font);
        cidFont.put(PdfName.FontDescriptor, fontDescriptor);
        if (ttf == null || ttf.isCff()) {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType0);
        } else {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType2);
            cidFont.put(PdfName.CIDToGIDMap, PdfName.Identity);
        }
        cidFont.put(PdfName.BaseFont, new PdfName(fontName));
        PdfDictionary cidInfo = new PdfDictionary();
        cidInfo.put(PdfName.Registry, new PdfString(this.cmapEncoding.getRegistry()));
        cidInfo.put(PdfName.Ordering, new PdfString(this.cmapEncoding.getOrdering()));
        cidInfo.put(PdfName.Supplement, new PdfNumber(this.cmapEncoding.getSupplement()));
        cidFont.put(PdfName.CIDSystemInfo, cidInfo);
        if (!this.vertical) {
            cidFont.put(PdfName.DW, new PdfNumber(1000));
            StringBuilder buf = new StringBuilder("[");
            int lastNumber = -10;
            boolean firstTime = true;
            for (int[] metric : metrics) {
                Glyph glyph = this.fontProgram.getGlyphByCode(metric[0]);
                if (glyph.getWidth() == 1000) continue;
                if (glyph.getCode() == lastNumber + 1) {
                    buf.append(' ').append(glyph.getWidth());
                } else {
                    if (!firstTime) {
                        buf.append(']');
                    }
                    firstTime = false;
                    buf.append(glyph.getCode()).append('[').append(glyph.getWidth());
                }
                lastNumber = glyph.getCode();
            }
            if (buf.length() > 1) {
                buf.append("]]");
                cidFont.put(PdfName.W, new PdfLiteral(buf.toString()));
            }
        } else {
            throw new UnsupportedOperationException("Vertical writing has not implemented yet.");
        }
        return cidFont;
    }

    protected void addRangeUni(TrueTypeFont ttf, Map<Integer, int[]> longTag, boolean includeMetrics) {
        if (!(this.subset || this.subsetRanges == null && ttf.getDirectoryOffset() <= 0)) {
            int[] nArray;
            if (this.subsetRanges == null && ttf.getDirectoryOffset() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 65535;
            } else {
                nArray = PdfType0Font.compactRanges(this.subsetRanges);
            }
            int[] rg = nArray;
            Map usemap = ttf.getActiveCmap();
            assert (usemap != null);
            for (Map.Entry e : usemap.entrySet()) {
                int[] nArray3;
                int[] v = (int[])e.getValue();
                int gi = v[0];
                if (longTag.containsKey(v[0])) continue;
                int c = (Integer)e.getKey();
                boolean skip = true;
                for (int k = 0; k < rg.length; k += 2) {
                    if (c < rg[k] || c > rg[k + 1]) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
                Integer n = gi;
                if (includeMetrics) {
                    int[] nArray4 = new int[3];
                    nArray4[0] = v[0];
                    nArray4[1] = v[1];
                    nArray3 = nArray4;
                    nArray4[2] = c;
                } else {
                    nArray3 = null;
                }
                longTag.put(n, nArray3);
            }
        }
    }

    private boolean containsUnicodeGlyph(String text, int from) {
        int ch = TextUtil.isSurrogatePair((String)text, (int)from) ? TextUtil.convertToUtf32((String)text, (int)from) : (int)text.charAt(from);
        return this.getFontProgram().getGlyph(ch) != null;
    }

    private int convertToBytes(Glyph glyph, byte[] result, int offset) {
        int code = glyph.getCode();
        int cmapCode = this.cmapEncoding.getCmapCode(code);
        this.longTag.add(code);
        result[offset] = (byte)(cmapCode >> 8);
        result[offset + 1] = (byte)cmapCode;
        return offset + 2;
    }

    private void convertToBytes(Glyph glyph, ByteBuffer result) {
        int code = glyph.getCode();
        int cmapCode = this.cmapEncoding.getCmapCode(code);
        this.longTag.add(code);
        result.append(cmapCode >> 8);
        result.append(cmapCode);
    }

    private static String getOrdering(PdfDictionary cidFont) {
        PdfDictionary cidinfo = cidFont.getAsDictionary(PdfName.CIDSystemInfo);
        if (cidinfo == null) {
            return null;
        }
        return cidinfo.containsKey(PdfName.Ordering) ? cidinfo.get(PdfName.Ordering).toString() : null;
    }

    private void flushFontData() {
        if (this.cidFontType == 0) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Type0);
            String name = this.fontProgram.getFontNames().getFontName();
            String style = this.fontProgram.getFontNames().getStyle();
            if (style.length() > 0) {
                name = name + "-" + style;
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(MessageFormatUtil.format((String)"{0}-{1}", (Object[])new Object[]{name, this.cmapEncoding.getCmapName()})));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, new PdfName(this.cmapEncoding.getCmapName()));
            PdfDictionary fontDescriptor = this.getFontDescriptor(name);
            int[] metrics = PdfType0Font.hashSetToArray(this.longTag);
            Arrays.sort(metrics);
            PdfDictionary cidFont = this.getCidFontType2(null, fontDescriptor, this.fontProgram.getFontNames().getFontName(), metrics);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.DescendantFonts, new PdfArray(cidFont));
            fontDescriptor.flush();
            cidFont.flush();
        } else if (this.cidFontType == 2) {
            PdfStream fontStream;
            TrueTypeFont ttf = (TrueTypeFont)this.getFontProgram();
            this.addRangeUni(ttf, this.longTag);
            int[] metrics = PdfType0Font.hashSetToArray(this.longTag);
            Arrays.sort(metrics);
            String fontName = PdfType0Font.updateSubsetPrefix(ttf.getFontNames().getFontName(), this.subset, this.embedded);
            PdfDictionary fontDescriptor = this.getFontDescriptor(fontName);
            if (ttf.isCff()) {
                byte[] cffBytes = ttf.getFontStreamBytes();
                if (this.subset || this.subsetRanges != null) {
                    CFFFontSubset cff = new CFFFontSubset(ttf.getFontStreamBytes(), this.longTag);
                    cffBytes = cff.Process(cff.getNames()[0]);
                }
                fontStream = this.getPdfFontStream(cffBytes, new int[]{cffBytes.length});
                fontStream.put(PdfName.Subtype, new PdfName("CIDFontType0C"));
                ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(MessageFormatUtil.format((String)"{0}-{1}", (Object[])new Object[]{fontName, this.cmapEncoding.getCmapName()})));
                fontDescriptor.put(PdfName.FontFile3, fontStream);
            } else {
                byte[] ttfBytes = null;
                if (this.subset || ttf.getDirectoryOffset() != 0) {
                    try {
                        ttfBytes = ttf.getSubset(new HashSet<Integer>(this.longTag), true);
                    }
                    catch (IOException e) {
                        Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                        logger.warn("Font subset issue. Full font will be embedded.");
                        ttfBytes = null;
                    }
                }
                if (ttfBytes == null) {
                    ttfBytes = ttf.getFontStreamBytes();
                }
                fontStream = this.getPdfFontStream(ttfBytes, new int[]{ttfBytes.length});
                ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(fontName));
                fontDescriptor.put(PdfName.FontFile2, fontStream);
            }
            int numOfGlyphs = ttf.getFontMetrics().getNumberOfGlyphs();
            byte[] cidSetBytes = new byte[ttf.getFontMetrics().getNumberOfGlyphs() / 8 + 1];
            int i = 0;
            while (i < numOfGlyphs / 8) {
                int n = i++;
                cidSetBytes[n] = (byte)(cidSetBytes[n] | 0xFF);
            }
            for (i = 0; i < numOfGlyphs % 8; ++i) {
                int n = cidSetBytes.length - 1;
                cidSetBytes[n] = (byte)(cidSetBytes[n] | rotbits[i]);
            }
            fontDescriptor.put(PdfName.CIDSet, new PdfStream(cidSetBytes));
            PdfDictionary cidFont = this.getCidFontType2(ttf, fontDescriptor, fontName, metrics);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Type0);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, new PdfName(this.cmapEncoding.getCmapName()));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.DescendantFonts, new PdfArray(cidFont));
            PdfStream toUnicode = this.getToUnicode(metrics);
            if (toUnicode != null) {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.ToUnicode, toUnicode);
                if (toUnicode.getIndirectReference() != null) {
                    toUnicode.flush();
                }
            }
            if (((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument().getPdfVersion().compareTo(PdfVersion.PDF_2_0) >= 0) {
                fontDescriptor.remove(PdfName.CIDSet);
            }
            fontDescriptor.flush();
            cidFont.flush();
            fontStream.flush();
        } else {
            throw new IllegalStateException("Unsupported CID Font");
        }
    }

    protected PdfDictionary getCidFontType2(TrueTypeFont ttf, PdfDictionary fontDescriptor, String fontName, int[] metrics) {
        PdfDictionary cidFont = new PdfDictionary();
        PdfType0Font.markObjectAsIndirect(cidFont);
        cidFont.put(PdfName.Type, PdfName.Font);
        cidFont.put(PdfName.FontDescriptor, fontDescriptor);
        if (ttf == null || ttf.isCff()) {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType0);
        } else {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType2);
            cidFont.put(PdfName.CIDToGIDMap, PdfName.Identity);
        }
        cidFont.put(PdfName.BaseFont, new PdfName(fontName));
        PdfDictionary cidInfo = new PdfDictionary();
        cidInfo.put(PdfName.Registry, new PdfString(this.cmapEncoding.getRegistry()));
        cidInfo.put(PdfName.Ordering, new PdfString(this.cmapEncoding.getOrdering()));
        cidInfo.put(PdfName.Supplement, new PdfNumber(this.cmapEncoding.getSupplement()));
        cidFont.put(PdfName.CIDSystemInfo, cidInfo);
        if (!this.vertical) {
            cidFont.put(PdfName.DW, new PdfNumber(1000));
            StringBuilder buf = new StringBuilder("[");
            int lastNumber = -10;
            boolean firstTime = true;
            for (int code : metrics) {
                Glyph glyph = this.fontProgram.getGlyphByCode(code);
                if (glyph.getWidth() == 1000) continue;
                if (glyph.getCode() == lastNumber + 1) {
                    buf.append(' ').append(glyph.getWidth());
                } else {
                    if (!firstTime) {
                        buf.append(']');
                    }
                    firstTime = false;
                    buf.append(glyph.getCode()).append('[').append(glyph.getWidth());
                }
                lastNumber = glyph.getCode();
            }
            if (buf.length() > 1) {
                buf.append("]]");
                cidFont.put(PdfName.W, new PdfLiteral(buf.toString()));
            }
        } else {
            throw new UnsupportedOperationException("Vertical writing has not implemented yet.");
        }
        return cidFont;
    }

    public PdfStream getToUnicode(int[] metrics) {
        ArrayList<Integer> unicodeGlyphs = new ArrayList<Integer>(metrics.length);
        for (int i = 0; i < metrics.length; ++i) {
            int code = metrics[i];
            if (this.fontProgram.getGlyphByCode(code).getChars() == null) continue;
            unicodeGlyphs.add(code);
        }
        if (unicodeGlyphs.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        int size = 0;
        for (int k = 0; k < unicodeGlyphs.size(); ++k) {
            if (size == 0) {
                if (k != 0) {
                    buf.append("endbfrange\n");
                }
                size = Math.min(100, unicodeGlyphs.size() - k);
                buf.append(size).append(" beginbfrange\n");
            }
            --size;
            String fromTo = CMapContentParser.toHex((int)((Integer)unicodeGlyphs.get(k)));
            Glyph glyph = this.fontProgram.getGlyphByCode(((Integer)unicodeGlyphs.get(k)).intValue());
            if (glyph.getChars() == null) continue;
            StringBuilder uni = new StringBuilder(glyph.getChars().length);
            for (char ch : glyph.getChars()) {
                uni.append(PdfType0Font.toHex4(ch));
            }
            buf.append(fromTo).append(fromTo).append('<').append(uni.toString()).append('>').append('\n');
        }
        buf.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        return new PdfStream(PdfEncodings.convertToBytes((String)buf.toString(), null));
    }

    private static String toHex4(char ch) {
        String s = "0000" + Integer.toHexString(ch);
        return s.substring(s.length() - 4);
    }

    protected void addRangeUni(TrueTypeFont ttf, Set<Integer> longTag) {
        if (!(this.subset || this.subsetRanges == null && ttf.getDirectoryOffset() <= 0)) {
            int[] nArray;
            if (this.subsetRanges == null && ttf.getDirectoryOffset() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 65535;
            } else {
                nArray = PdfType0Font.compactRanges(this.subsetRanges);
            }
            int[] rg = nArray;
            Map usemap = ttf.getActiveCmap();
            assert (usemap != null);
            for (Map.Entry e : usemap.entrySet()) {
                int[] v = (int[])e.getValue();
                int gi = v[0];
                if (longTag.contains(v[0])) continue;
                int c = (Integer)e.getKey();
                boolean skip = true;
                for (int k = 0; k < rg.length; k += 2) {
                    if (c < rg[k] || c > rg[k + 1]) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
                longTag.add(gi);
            }
        }
    }

    private String getCompatibleUniMap(String registry) {
        String uniMap = "";
        Iterator iterator = ((Set)CidFontProperties.getRegistryNames().get(registry + "_Uni")).iterator();
        while (iterator.hasNext()) {
            String name;
            uniMap = name = (String)iterator.next();
            if ((!name.endsWith("V") || !this.vertical) && (name.endsWith("V") || this.vertical)) continue;
            break;
        }
        return uniMap;
    }

    private static int[] hashSetToArray(Set<Integer> set) {
        int[] res = new int[set.size()];
        int i = 0;
        for (int n : set) {
            res[i++] = n;
        }
        return res;
    }
}

