/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SystemUtil {
    @Deprecated
    public static long getSystemTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getTimeBasedSeed() {
        return System.currentTimeMillis();
    }

    public static int getTimeBasedIntSeed() {
        return (int)System.currentTimeMillis();
    }

    public static long getRelativeTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static String getPropertyOrEnvironmentVariable(String name) {
        String s = System.getProperty(name);
        if (s == null) {
            s = System.getenv(name);
        }
        return s;
    }

    public static boolean runProcessAndWait(String execPath, String params) throws IOException, InterruptedException {
        ArrayList<String> cmdArray = new ArrayList<String>();
        cmdArray.add(execPath);
        Matcher m = Pattern.compile("((?:[^'\\s]|'.+?')+)\\s*").matcher(params);
        while (m.find()) {
            cmdArray.add(m.group(1).replace("'", ""));
        }
        Process p = Runtime.getRuntime().exec(cmdArray.toArray(new String[cmdArray.size()]));
        SystemUtil.printProcessOutput(p);
        return p.waitFor() == 0;
    }

    private static void printProcessOutput(Process p) throws IOException {
        String line;
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
    }

    public static StringBuilder runProcessAndCollectErrors(String execPath, String params) throws IOException {
        ArrayList<String> cmdArray = new ArrayList<String>();
        cmdArray.add(execPath);
        Matcher m = Pattern.compile("((?:[^'\\s]|'.+?')+)\\s*").matcher(params);
        while (m.find()) {
            cmdArray.add(m.group(1).replace("'", ""));
        }
        Process p = Runtime.getRuntime().exec(cmdArray.toArray(new String[cmdArray.size()]));
        StringBuilder errorsBuilder = SystemUtil.printProcessErrorsOutput(p);
        return errorsBuilder;
    }

    private static StringBuilder printProcessErrorsOutput(Process p) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
            builder.append(line);
        }
        bre.close();
        return builder;
    }
}

