/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public final class TextDecorationApplierUtil {
    private static final String IGNORED = "__ignored__";
    private static final SupportedTextDecoration[] SUPPORTED_TEXT_DECORATION_PROPERTIES = new SupportedTextDecoration[]{new SupportedTextDecoration("text-decoration-line", "__ignored__"), new SupportedTextDecoration("text-decoration-style", "solid"), new SupportedTextDecoration("text-decoration-color", "currentcolor")};
    private static final int AMOUNT = SUPPORTED_TEXT_DECORATION_PROPERTIES.length;

    private TextDecorationApplierUtil() {
    }

    public static void propagateTextDecorationProperties(IElementNode currentNode) {
        TextDecorationApplierUtil.expandTextDecorationProperties(currentNode);
        if (!TextDecorationApplierUtil.shouldPropagateTextDecorationProperties(currentNode)) {
            return;
        }
        TextDecorationApplierUtil.mergeProperties(currentNode);
    }

    private static boolean shouldOnlyKeepParentProperties(IElementNode currentNode) {
        return currentNode.getStyles().get("text-decoration-line") != null && ((String)currentNode.getStyles().get("text-decoration-line")).contains("none");
    }

    private static boolean shouldPropagateTextDecorationProperties(IElementNode currentNode) {
        IElementNode parent = (IElementNode)currentNode.parentNode();
        if (parent == null || parent.getStyles() == null) {
            return false;
        }
        if (TextDecorationApplierUtil.doesNotHaveTextDecorationKey(currentNode) && TextDecorationApplierUtil.doesNotHaveTextDecorationKey(parent)) {
            return false;
        }
        return !"inline-block".equals(currentNode.getStyles().get("display"));
    }

    private static List<String> parseTokenIntoList(IElementNode node, String propertyName) {
        String currentValue = (String)node.getStyles().get(propertyName);
        return currentValue == null ? new ArrayList() : Arrays.asList(currentValue.split("\\s+"));
    }

    private static void mergeProperties(IElementNode node) {
        int i;
        boolean onlyKeepParentProperties = TextDecorationApplierUtil.shouldOnlyKeepParentProperties(node);
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (SupportedTextDecoration supportedTextDecoration : SUPPORTED_TEXT_DECORATION_PROPERTIES) {
            List<String> currentValues = TextDecorationApplierUtil.parseTokenIntoList(node, supportedTextDecoration.getPropertyName());
            List<String> parentValues = TextDecorationApplierUtil.parseTokenIntoList((IElementNode)node.parentNode(), supportedTextDecoration.getPropertyName());
            ArrayList<String> properties = new ArrayList<String>(parentValues);
            data.add(properties);
            if (currentValues.isEmpty() || onlyKeepParentProperties) continue;
            properties.addAll(currentValues);
        }
        int amount = ((List)data.get(0)).size();
        LinkedHashSet<String> uniqueMaker = new LinkedHashSet<String>();
        ArrayList<Integer> indexListToKeep = new ArrayList<Integer>();
        for (i = 0; i < amount; ++i) {
            StringBuilder hashBuilder = new StringBuilder();
            for (int j = 0; j < AMOUNT; ++j) {
                hashBuilder.append((String)((List)data.get(j)).get(i));
            }
            String hash = hashBuilder.toString();
            if (hash.contains(IGNORED) || uniqueMaker.contains(hash)) continue;
            indexListToKeep.add(i);
            uniqueMaker.add(hashBuilder.toString());
        }
        for (i = 0; i < AMOUNT; ++i) {
            StringBuilder result = new StringBuilder();
            for (Integer integer : indexListToKeep) {
                int index = integer;
                result.append((String)((List)data.get(i)).get(index)).append(' ');
            }
            node.getStyles().put(SUPPORTED_TEXT_DECORATION_PROPERTIES[i].getPropertyName(), result.toString().trim());
        }
    }

    private static boolean doesNotHaveTextDecorationKey(IElementNode node) {
        for (int i = 0; i < AMOUNT; ++i) {
            if (!node.getStyles().containsKey(SUPPORTED_TEXT_DECORATION_PROPERTIES[i].getPropertyName())) continue;
            return false;
        }
        return true;
    }

    private static void expandTextDecorationProperties(IElementNode node) {
        int i;
        if (TextDecorationApplierUtil.doesNotHaveTextDecorationKey(node)) {
            return;
        }
        ArrayList<String[]> currentValuesParsed = new ArrayList<String[]>(AMOUNT);
        for (SupportedTextDecoration supportedTextDecorationProperty : SUPPORTED_TEXT_DECORATION_PROPERTIES) {
            String unParsedValue = (String)node.getStyles().get(supportedTextDecorationProperty.getPropertyName());
            String[] value = supportedTextDecorationProperty.getDefaultValue();
            if (unParsedValue != null) {
                value = unParsedValue.split("\\s+");
            }
            assert (value != null);
            assert (value.length > 0);
            currentValuesParsed.add(value);
        }
        int maxValue = ((String[])currentValuesParsed.get(0)).length;
        for (String[] strings : currentValuesParsed) {
            if (strings.length <= maxValue) continue;
            maxValue = strings.length;
        }
        ArrayList<StringBuilder> correctValues = new ArrayList<StringBuilder>(AMOUNT);
        for (i = 0; i < AMOUNT; ++i) {
            correctValues.add(new StringBuilder());
        }
        for (i = 0; i < maxValue; ++i) {
            for (int indexProperty = 0; indexProperty < AMOUNT; ++indexProperty) {
                ((StringBuilder)correctValues.get(indexProperty)).append(TextDecorationApplierUtil.getValueAtIndexOrLast(currentValuesParsed, i, indexProperty)).append(' ');
            }
        }
        for (i = 0; i < AMOUNT; ++i) {
            node.getStyles().put(SUPPORTED_TEXT_DECORATION_PROPERTIES[i].getPropertyName(), ((StringBuilder)correctValues.get(i)).toString().trim());
        }
    }

    private static String getValueAtIndexOrLast(List<String[]> currentValuesParsed, int i, int indexProperty) {
        return currentValuesParsed.get(indexProperty).length - 1 > i ? currentValuesParsed.get(indexProperty)[i] : currentValuesParsed.get(indexProperty)[currentValuesParsed.get(indexProperty).length - 1];
    }

    private static final class SupportedTextDecoration {
        private final String propertyName;
        private final String[] defaultValue;

        public SupportedTextDecoration(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = new String[]{defaultValue};
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String[] getDefaultValue() {
            return (String[])this.defaultValue.clone();
        }
    }
}

