/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.sequence.AbstractIdentifiableElement;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.actions.sequence.SequenceIdManager;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.form.element.IPlaceholderable;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.ProcessorContextCreator;
import com.itextpdf.html2pdf.actions.events.PdfHtmlProductEvent;
import com.itextpdf.html2pdf.attach.IHtmlProcessor;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocument;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElementContainer;
import com.itextpdf.html2pdf.attach.impl.tags.HtmlTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.RunningElementTagWorker;
import com.itextpdf.html2pdf.attach.util.LinkHelper;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.util.CounterProcessorUtil;
import com.itextpdf.html2pdf.css.apply.util.PageBreakApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.TextDecorationApplierUtil;
import com.itextpdf.html2pdf.css.resolve.DefaultCssResolver;
import com.itextpdf.html2pdf.exceptions.Html2PdfException;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IAbstractElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.font.CssFontFace;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementNode;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementUtil;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.ITextNode;
import com.itextpdf.styledxmlparser.util.FontFamilySplitterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHtmlProcessor
implements IHtmlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHtmlProcessor.class);
    private static final Set<String> ignoredTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("head", "style", "tbody")));
    private static final Set<String> ignoredCssTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("br", "link", "meta", "title", "tr")));
    private static final Set<String> ignoredChildTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("body", "link", "meta", "script", "title")));
    private ProcessorContext context;
    private List<IPropertyContainer> roots;
    private ICssResolver cssResolver;

    public DefaultHtmlProcessor(ConverterProperties converterProperties) {
        this.context = ProcessorContextCreator.createProcessorContext(converterProperties);
    }

    public static void setConvertedRootElementProperties(Map<String, String> cssProperties, ProcessorContext context, IPropertyContainer propertyContainer) {
        List fontFamilies;
        propertyContainer.setProperty(89, (Object)true);
        propertyContainer.setProperty(123, (Object)RenderingMode.HTML_MODE);
        propertyContainer.setProperty(91, (Object)context.getFontProvider());
        if (context.getTempFonts() != null) {
            propertyContainer.setProperty(98, (Object)context.getTempFonts());
        }
        if ((fontFamilies = FontFamilySplitterUtil.splitFontFamily((String)cssProperties.get("font-family"))) != null && !propertyContainer.hasOwnProperty(20)) {
            propertyContainer.setProperty(20, (Object)fontFamilies.toArray(new String[0]));
        }
    }

    @Override
    public List<IElement> processElements(INode root) {
        SequenceId sequenceId = new SequenceId();
        EventManager.getInstance().onEvent((IEvent)PdfHtmlProductEvent.createConvertHtmlEvent(sequenceId, this.context.getMetaInfoContainer().getMetaInfo()));
        this.context.reset();
        this.roots = new ArrayList<IPropertyContainer>();
        this.cssResolver = new DefaultCssResolver(root, this.context);
        this.context.getLinkContext().scanForIds(root);
        this.addFontFaceFonts();
        IElementNode html = this.findHtmlNode(root);
        IElementNode body = this.findBodyNode(root);
        html.setStyles(this.cssResolver.resolveStyles((INode)html, (AbstractCssContext)this.context.getCssContext()));
        this.visit((INode)body);
        Div bodyDiv = (Div)this.roots.get(0);
        ArrayList<IElement> elements = new ArrayList<IElement>();
        body.setStyles(this.cssResolver.resolveStyles((INode)body, (AbstractCssContext)this.context.getCssContext()));
        for (IPropertyContainer propertyContainer : bodyDiv.getChildren()) {
            if (!(propertyContainer instanceof IElement)) continue;
            DefaultHtmlProcessor.setConvertedRootElementProperties(body.getStyles(), this.context, propertyContainer);
            elements.add((IElement)propertyContainer);
        }
        this.cssResolver = null;
        this.roots = null;
        for (IElement element : elements) {
            DefaultHtmlProcessor.updateSequenceId(element, sequenceId);
        }
        return elements;
    }

    @Override
    public Document processDocument(INode root, PdfDocument pdfDocument) {
        EventManager.getInstance().onEvent((IEvent)PdfHtmlProductEvent.createConvertHtmlEvent(pdfDocument.getDocumentIdWrapper(), this.context.getMetaInfoContainer().getMetaInfo()));
        this.context.reset(pdfDocument);
        if (!this.context.hasFonts()) {
            throw new Html2PdfException("Font Provider contains zero fonts. At least one font shall be present");
        }
        this.roots = new ArrayList<IPropertyContainer>();
        this.cssResolver = new DefaultCssResolver(root, this.context);
        this.context.getLinkContext().scanForIds(root);
        this.addFontFaceFonts();
        root = this.findHtmlNode(root);
        if (this.context.getCssContext().isNonPagesTargetCounterPresent()) {
            this.visitToProcessCounters(root);
            this.context.getCssContext().getCounterManager().clearManager();
        }
        this.visit(root);
        HtmlDocument doc = (HtmlDocument)this.roots.get(0);
        if (this.context.getCssContext().isPagesCounterPresent()) {
            if (doc.getRenderer() instanceof HtmlDocumentRenderer) {
                ((HtmlDocumentRenderer)doc.getRenderer()).processWaitingElement();
                int counter = 0;
                do {
                    doc.relayout();
                    if (++counter < this.context.getLimitOfLayouts()) continue;
                    logger.warn(MessageFormatUtil.format((String)"Exceeded the maximum number of relayouts. The resultant document may look not as expected. Because of the content being dynamic iText performs several relayouts to produce correct document.", (Object[])new Object[0]));
                    break;
                } while (((DocumentRenderer)doc.getRenderer()).isRelayoutRequired());
            } else {
                logger.warn("A custom renderer which doesn't extend HtmlDocumentRenderer is set for HtmlDocument. Counters and target-counters may be displayed incorrectly.");
            }
        }
        this.cssResolver = null;
        this.roots = null;
        return doc;
    }

    private void visitToProcessCounters(INode node) {
        if (node instanceof IElementNode) {
            IElementNode element = (IElementNode)node;
            if (this.cssResolver instanceof DefaultCssResolver) {
                ((DefaultCssResolver)this.cssResolver).resolveContentAndCountersStyles(node, this.context.getCssContext());
            }
            CounterProcessorUtil.startProcessingCounters(this.context.getCssContext(), element);
            this.visitToProcessCounters((INode)DefaultHtmlProcessor.createPseudoElement(element, null, "before"));
            for (INode childNode : element.childNodes()) {
                if (this.context.isProcessingInlineSvg()) continue;
                this.visitToProcessCounters(childNode);
            }
            this.visitToProcessCounters((INode)DefaultHtmlProcessor.createPseudoElement(element, null, "after"));
            CounterProcessorUtil.endProcessingCounters(this.context.getCssContext(), element);
        }
    }

    private void visit(INode node) {
        String content;
        if (node instanceof IElementNode) {
            IElementNode element = (IElementNode)node;
            element.setStyles(this.cssResolver.resolveStyles((INode)element, (AbstractCssContext)this.context.getCssContext()));
            if (!this.isDisplayable(element)) {
                return;
            }
            ITagWorker tagWorker = this.context.getTagWorkerFactory().getTagWorker(element, this.context);
            if (tagWorker == null) {
                if (!ignoredTags.contains(element.name())) {
                    logger.error(MessageFormatUtil.format((String)"No worker found for tag {0}", (Object[])new Object[]{element.name()}));
                }
            } else {
                this.context.getState().push(tagWorker);
            }
            if (this.context.getState().getStack().size() == 1 && tagWorker != null && tagWorker.getElementResult() != null) {
                tagWorker.getElementResult().setProperty(135, (Object)new MetaInfoContainer(this.context.getMetaInfoContainer().getMetaInfo()));
            }
            if (tagWorker instanceof HtmlTagWorker) {
                ((HtmlTagWorker)tagWorker).processPageRules(node, this.cssResolver, this.context);
            }
            if ("body".equals(element.name()) || "html".equals(element.name())) {
                this.runApplier(element, tagWorker);
            }
            this.context.getOutlineHandler().addOutlineAndDestToDocument(tagWorker, element, this.context);
            TextDecorationApplierUtil.propagateTextDecorationProperties(element);
            CounterProcessorUtil.startProcessingCounters(this.context.getCssContext(), element);
            this.visit((INode)DefaultHtmlProcessor.createPseudoElement(element, tagWorker, "before"));
            this.visit((INode)DefaultHtmlProcessor.createPseudoElement(element, tagWorker, "placeholder"));
            for (INode childNode : element.childNodes()) {
                if (this.context.isProcessingInlineSvg()) continue;
                this.visit(childNode);
            }
            this.visit((INode)DefaultHtmlProcessor.createPseudoElement(element, tagWorker, "after"));
            CounterProcessorUtil.endProcessingCounters(this.context.getCssContext(), element);
            if (tagWorker != null) {
                tagWorker.processEnd(element, this.context);
                LinkHelper.createDestination(tagWorker, element, this.context);
                this.context.getOutlineHandler().setDestinationToElement(tagWorker, element);
                this.context.getState().pop();
                if (!"body".equals(element.name()) && !"html".equals(element.name())) {
                    this.runApplier(element, tagWorker);
                }
                if (!this.context.getState().empty()) {
                    PageBreakApplierUtil.addPageBreakElementBefore(this.context, this.context.getState().top(), element, tagWorker);
                    tagWorker = this.processRunningElement(tagWorker, element, this.context);
                    boolean childProcessed = this.context.getState().top().processTagChild(tagWorker, this.context);
                    PageBreakApplierUtil.addPageBreakElementAfter(this.context, this.context.getState().top(), element, tagWorker);
                    if (!childProcessed && !ignoredChildTags.contains(element.name())) {
                        logger.error(MessageFormatUtil.format((String)"Worker of type {0} unable to process {1}", (Object[])new Object[]{this.context.getState().top().getClass().getName(), tagWorker.getClass().getName()}));
                    }
                } else if (tagWorker.getElementResult() != null) {
                    this.roots.add(tagWorker.getElementResult());
                }
                if (tagWorker.getElementResult() != null && this.context.isContinuousContainerEnabled()) {
                    tagWorker.getElementResult().setProperty(89, (Object)Boolean.FALSE);
                    tagWorker.getElementResult().setProperty(140, (Object)true);
                }
            }
            element.setStyles(null);
        } else if (node instanceof ITextNode && (content = ((ITextNode)node).wholeText()) != null) {
            if (!this.context.getState().empty()) {
                boolean contentProcessed = this.context.getState().top().processContent(content, this.context);
                if (!contentProcessed) {
                    logger.error(MessageFormatUtil.format((String)"Worker of type {0} unable to process it`s text content", (Object[])new Object[]{this.context.getState().top().getClass().getName()}));
                }
            } else {
                logger.error("No consumer found for content");
            }
        }
    }

    private void runApplier(IElementNode element, ITagWorker tagWorker) {
        ICssApplier cssApplier = this.context.getCssApplierFactory().getCssApplier(element);
        if (cssApplier == null) {
            if (!ignoredCssTags.contains(element.name())) {
                logger.error(MessageFormatUtil.format((String)"No css applier found for tag {0}", (Object[])new Object[]{element.name()}));
            }
        } else {
            cssApplier.apply(this.context, (IStylesContainer)element, tagWorker);
        }
    }

    private ITagWorker processRunningElement(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        int endBracketInd;
        String positionVal;
        String runningPrefix = "running(";
        if (element.getStyles() == null || (positionVal = (String)element.getStyles().get("position")) == null || !positionVal.startsWith(runningPrefix) || (endBracketInd = positionVal.indexOf(")")) <= runningPrefix.length()) {
            return tagWorker;
        }
        String runningElemName = positionVal.substring(runningPrefix.length(), endBracketInd).trim();
        if (runningElemName.isEmpty()) {
            return tagWorker;
        }
        RunningElementContainer runningElementContainer = new RunningElementContainer(element, tagWorker);
        context.getCssContext().getRunningManager().addRunningElement(runningElemName, runningElementContainer);
        return new RunningElementTagWorker(runningElementContainer);
    }

    private void addFontFaceFonts() {
        if (this.cssResolver instanceof DefaultCssResolver) {
            for (CssFontFaceRule fontFace : ((DefaultCssResolver)this.cssResolver).getFonts()) {
                boolean findSupportedSrc = false;
                List declarations = fontFace.getProperties();
                CssFontFace ff = CssFontFace.create((List)declarations);
                if (ff != null) {
                    for (CssFontFace.CssFontFaceSrc src : ff.getSources()) {
                        if (!this.createFont(ff.getFontFamily(), src, fontFace.resolveUnicodeRange())) continue;
                        findSupportedSrc = true;
                        break;
                    }
                }
                if (findSupportedSrc) continue;
                logger.error(MessageFormatUtil.format((String)"Unable to retrieve font:\n {0}", (Object[])new Object[]{fontFace}));
            }
        }
    }

    private boolean createFont(String fontFamily, CssFontFace.CssFontFaceSrc src, Range unicodeRange) {
        if (!CssFontFace.isSupportedFontFormat((CssFontFace.FontFormat)src.getFormat())) {
            return false;
        }
        if (src.isLocal()) {
            Collection fonts = this.context.getFontProvider().getFontSet().get(src.getSrc());
            if (fonts.size() > 0) {
                for (FontInfo fi : fonts) {
                    this.context.addTemporaryFont(fi, fontFamily);
                }
                return true;
            }
            return false;
        }
        try {
            byte[] bytes = this.context.getResourceResolver().retrieveBytesFromResource(src.getSrc());
            if (bytes != null) {
                FontProgram fp = FontProgramFactory.createFont((byte[])bytes, (boolean)false);
                this.context.addTemporaryFont(fp, "Identity-H", fontFamily, unicodeRange);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static CssPseudoElementNode createPseudoElement(IElementNode node, ITagWorker tagWorker, String pseudoElementName) {
        switch (pseudoElementName) {
            case "before": 
            case "after": {
                if (CssPseudoElementUtil.hasBeforeAfterElements((IElementNode)node)) break;
                return null;
            }
            case "placeholder": {
                if (("input".equals(node.name()) || "textarea".equals(node.name())) && null != tagWorker && tagWorker.getElementResult() instanceof IPlaceholderable && null != ((IPlaceholderable)tagWorker.getElementResult()).getPlaceholder()) break;
                return null;
            }
            default: {
                return null;
            }
        }
        return new CssPseudoElementNode((INode)node, pseudoElementName);
    }

    private IElementNode findElement(INode node, String tagName) {
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(node);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode instanceof IElementNode && ((IElementNode)currentNode).name().equals(tagName)) {
                return (IElementNode)currentNode;
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        return null;
    }

    private IElementNode findHtmlNode(INode node) {
        return this.findElement(node, "html");
    }

    private IElementNode findBodyNode(INode node) {
        return this.findElement(node, "body");
    }

    private boolean isDisplayable(IElementNode element) {
        if (element != null && element.getStyles() != null && "none".equals(element.getStyles().get("display"))) {
            return false;
        }
        if (this.isPlaceholder(element)) {
            return true;
        }
        if (element instanceof CssPseudoElementNode) {
            if (element.childNodes().isEmpty()) {
                return false;
            }
            boolean hasStyles = element.getStyles() != null;
            String positionVal = hasStyles ? (String)element.getStyles().get("position") : null;
            String displayVal = hasStyles ? (String)element.getStyles().get("display") : null;
            boolean containsNonEmptyChildNode = false;
            boolean containsElementNode = false;
            for (int i = 0; i < element.childNodes().size(); ++i) {
                if (element.childNodes().get(i) instanceof ITextNode) {
                    containsNonEmptyChildNode = true;
                    break;
                }
                if (!(element.childNodes().get(i) instanceof IElementNode)) continue;
                containsElementNode = true;
            }
            return containsElementNode || containsNonEmptyChildNode || "absolute".equals(positionVal) || "fixed".equals(positionVal) || displayVal != null && !"inline".equals(displayVal);
        }
        return element != null;
    }

    private boolean isPlaceholder(IElementNode element) {
        return element instanceof CssPseudoElementNode && "placeholder".equals(((CssPseudoElementNode)element).getPseudoElementName());
    }

    private static void updateSequenceId(IElement element, SequenceId sequenceId) {
        if (element instanceof AbstractIdentifiableElement) {
            AbstractIdentifiableElement identifiableElement = (AbstractIdentifiableElement)element;
            if (SequenceIdManager.getSequenceId((AbstractIdentifiableElement)identifiableElement) == sequenceId) {
                return;
            }
            SequenceIdManager.setSequenceId((AbstractIdentifiableElement)identifiableElement, (SequenceId)sequenceId);
            if (identifiableElement instanceof IAbstractElement) {
                IAbstractElement abstractElement = (IAbstractElement)identifiableElement;
                DefaultHtmlProcessor.updateChildren(abstractElement.getChildren(), sequenceId);
            }
        }
    }

    private static void updateChildren(List<IElement> children, SequenceId sequenceId) {
        if (children == null) {
            return;
        }
        for (IElement child : children) {
            DefaultHtmlProcessor.updateSequenceId(child, sequenceId);
        }
    }
}

