/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.impl;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssConstants;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.util.BackgroundApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.FontStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.MarginApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.OutlineApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.PaddingApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.VerticalAlignmentApplierUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.page.PageMarginBoxContextNode;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMarginBoxCssApplier
implements ICssApplier {
    public static float[] parseBoxProps(Map<String, String> styles, float em, float rem, float[] defaultValues, Rectangle containingBlock, String topPropName, String rightPropName, String bottomPropName, String leftPropName) {
        String topStr = styles.get(topPropName);
        String rightStr = styles.get(rightPropName);
        String bottomStr = styles.get(bottomPropName);
        String leftStr = styles.get(leftPropName);
        Float top = PageMarginBoxCssApplier.parseBoxValue(topStr, em, rem, containingBlock.getHeight());
        Float right = PageMarginBoxCssApplier.parseBoxValue(rightStr, em, rem, containingBlock.getWidth());
        Float bottom = PageMarginBoxCssApplier.parseBoxValue(bottomStr, em, rem, containingBlock.getHeight());
        Float left = PageMarginBoxCssApplier.parseBoxValue(leftStr, em, rem, containingBlock.getWidth());
        return new float[]{top != null ? top.floatValue() : defaultValues[0], right != null ? right.floatValue() : defaultValues[1], bottom != null ? bottom.floatValue() : defaultValues[2], left != null ? left.floatValue() : defaultValues[3]};
    }

    @Override
    public void apply(ProcessorContext context, IStylesContainer stylesContainer, ITagWorker tagWorker) {
        String overflowY;
        String overflowX;
        Map boxStyles = stylesContainer.getStyles();
        IPropertyContainer marginBox = tagWorker.getElementResult();
        BackgroundApplierUtil.applyBackground(boxStyles, context, marginBox);
        FontStyleApplierUtil.applyFontStyles(boxStyles, context, stylesContainer, marginBox);
        BorderStyleApplierUtil.applyBorders(boxStyles, context, marginBox);
        VerticalAlignmentApplierUtil.applyVerticalAlignmentForCells(boxStyles, context, marginBox);
        String overflow = CssConstants.OVERFLOW_VALUES.contains(boxStyles.get("overflow")) ? (String)boxStyles.get("overflow") : null;
        String string = overflowX = CssConstants.OVERFLOW_VALUES.contains(boxStyles.get("overflow-x")) ? (String)boxStyles.get("overflow-x") : overflow;
        if (overflowX == null || "hidden".equals(overflowX)) {
            marginBox.setProperty(103, (Object)OverflowPropertyValue.HIDDEN);
        } else {
            marginBox.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        }
        String string2 = overflowY = CssConstants.OVERFLOW_VALUES.contains(boxStyles.get("overflow-y")) ? (String)boxStyles.get("overflow-y") : overflow;
        if (overflowY == null || "hidden".equals(overflowY)) {
            marginBox.setProperty(104, (Object)OverflowPropertyValue.HIDDEN);
        } else {
            marginBox.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        }
        OutlineApplierUtil.applyOutlines(boxStyles, context, marginBox);
        marginBox.setProperty(91, (Object)context.getFontProvider());
        marginBox.setProperty(98, (Object)context.getTempFonts());
        if (!(stylesContainer instanceof PageMarginBoxContextNode)) {
            Logger logger = LoggerFactory.getLogger(PageMarginBoxCssApplier.class);
            logger.warn("Page margin box margin, padding, height and width properties are not processed. Passed styles container shall be of PageMarginBoxContextNode type.");
            return;
        }
        float availableWidth = ((PageMarginBoxContextNode)stylesContainer).getContainingBlockForMarginBox().getWidth();
        float availableHeight = ((PageMarginBoxContextNode)stylesContainer).getContainingBlockForMarginBox().getHeight();
        MarginApplierUtil.applyMargins(boxStyles, context, marginBox, availableHeight, availableWidth);
        PaddingApplierUtil.applyPaddings(boxStyles, context, marginBox, availableHeight, availableWidth);
    }

    private static Float parseBoxValue(String valString, float em, float rem, float dimensionSize) {
        UnitValue marginUnitVal = CssDimensionParsingUtils.parseLengthValueToPt((String)valString, (float)em, (float)rem);
        if (marginUnitVal != null) {
            if (marginUnitVal.isPointValue()) {
                return Float.valueOf(marginUnitVal.getValue());
            }
            if (marginUnitVal.isPercentValue()) {
                return Float.valueOf(marginUnitVal.getValue() * dimensionSize / 100.0f);
            }
        }
        return null;
    }
}

