/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.DimensionContainer;
import com.itextpdf.html2pdf.attach.impl.layout.HeightDimensionContainer;
import com.itextpdf.html2pdf.attach.impl.layout.PageMarginBoxDummyElement;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElementContainer;
import com.itextpdf.html2pdf.attach.impl.layout.WidthDimensionContainer;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.page.PageMarginRunningElementNode;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.styledxmlparser.css.CssContextNode;
import com.itextpdf.styledxmlparser.css.page.PageMarginBoxContextNode;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.ITextNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.LoggerFactory;

class PageMarginBoxBuilder {
    IRenderer[] renderers;
    PageMarginBoxContextNode[] nodes;
    float[] margins;
    PageSize pageSize;
    List<PageMarginBoxContextNode> resolvedPageMarginBoxes;
    private static final float EPSILON = 1.0E-5f;

    public PageMarginBoxBuilder(List<PageMarginBoxContextNode> resolvedPageMarginBoxes, float[] margins, PageSize pageSize) {
        this.resolvedPageMarginBoxes = resolvedPageMarginBoxes;
        this.margins = margins;
        this.pageSize = pageSize;
        Rectangle[] marginBoxRectangles = this.calculateMarginBoxRectanglesCornersOnly();
        for (PageMarginBoxContextNode marginBoxContentNode : this.resolvedPageMarginBoxes) {
            if (marginBoxContentNode.childNodes().isEmpty()) {
                throw new IllegalStateException();
            }
            int marginBoxInd = this.mapMarginBoxNameToIndex(marginBoxContentNode.getMarginBoxName());
            if (marginBoxRectangles[marginBoxInd] != null) {
                marginBoxContentNode.setPageMarginBoxRectangle(new Rectangle(marginBoxRectangles[marginBoxInd]).increaseHeight(1.0E-5f));
            }
            marginBoxContentNode.setContainingBlockForMarginBox(this.calculateContainingBlockSizesForMarginBox(marginBoxInd, marginBoxRectangles[marginBoxInd]));
        }
    }

    public void buildForSinglePage(int pageNumber, PdfDocument pdfDocument, DocumentRenderer documentRenderer, ProcessorContext context) {
        if (this.resolvedPageMarginBoxes.isEmpty()) {
            return;
        }
        this.nodes = new PageMarginBoxContextNode[16];
        Iterator<PageMarginBoxContextNode> iterator = this.resolvedPageMarginBoxes.iterator();
        while (iterator.hasNext()) {
            PageMarginBoxContextNode marginBoxContentNode;
            this.nodes[this.mapMarginBoxNameToIndex((String)marginBoxContentNode.getMarginBoxName())] = marginBoxContentNode = iterator.next();
        }
        IElement[] elements = new IElement[16];
        for (int i = 0; i < 16; ++i) {
            if (this.nodes[i] == null) continue;
            elements[i] = this.processMarginBoxContent(this.nodes[i], pageNumber, context);
        }
        this.getPMBRenderers(elements, documentRenderer, pdfDocument);
    }

    public IRenderer[] getRenderers() {
        return this.renderers;
    }

    public PageMarginBoxContextNode[] getNodes() {
        return this.nodes;
    }

    private IElement processMarginBoxContent(PageMarginBoxContextNode marginBoxContentNode, int pageNumber, ProcessorContext context) {
        PageMarginBoxDummyElement dummyMarginBoxNode = new PageMarginBoxDummyElement();
        dummyMarginBoxNode.setStyles(marginBoxContentNode.getStyles());
        ITagWorker marginBoxWorker = context.getTagWorkerFactory().getTagWorker(dummyMarginBoxNode, context);
        for (int i = 0; i < marginBoxContentNode.childNodes().size(); ++i) {
            INode childNode = (INode)marginBoxContentNode.childNodes().get(i);
            if (childNode instanceof ITextNode) {
                String text = ((ITextNode)marginBoxContentNode.childNodes().get(i)).wholeText();
                marginBoxWorker.processContent(text, context);
                continue;
            }
            if (childNode instanceof IElementNode) {
                ITagWorker childTagWorker = context.getTagWorkerFactory().getTagWorker((IElementNode)childNode, context);
                if (childTagWorker == null) continue;
                childTagWorker.processEnd((IElementNode)childNode, context);
                marginBoxWorker.processTagChild(childTagWorker, context);
                continue;
            }
            if (childNode instanceof PageMarginRunningElementNode) {
                PageMarginRunningElementNode runningElementNode = (PageMarginRunningElementNode)childNode;
                RunningElementContainer runningElement = context.getCssContext().getRunningManager().getRunningElement(runningElementNode.getRunningElementName(), runningElementNode.getRunningElementOccurrence(), pageNumber);
                if (runningElement == null) continue;
                marginBoxWorker.processTagChild(runningElement.getProcessedElementWorker(), context);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).error("Unknown margin box child");
        }
        marginBoxWorker.processEnd(dummyMarginBoxNode, context);
        if (!(marginBoxWorker.getElementResult() instanceof IElement)) {
            throw new IllegalStateException("Custom tag worker implementation for margin boxes shall return IElement for #getElementResult() call.");
        }
        ICssApplier cssApplier = context.getCssApplierFactory().getCssApplier(dummyMarginBoxNode);
        cssApplier.apply(context, (IStylesContainer)marginBoxContentNode, marginBoxWorker);
        return (IElement)marginBoxWorker.getElementResult();
    }

    private void getPMBRenderers(IElement[] elements, DocumentRenderer documentRenderer, PdfDocument pdfDocument) {
        this.renderers = new IRenderer[16];
        for (int i = 0; i < 4; ++i) {
            this.renderers[i * 4] = this.createCornerRenderer(elements[i * 4], documentRenderer, pdfDocument, i);
            for (int j = 1; j <= 3; ++j) {
                this.renderers[i * 4 + j] = this.createRendererFromElement(elements[i * 4 + j], documentRenderer, pdfDocument);
            }
            this.determineSizes(i);
        }
    }

    private IRenderer createCornerRenderer(IElement cornerBoxElement, DocumentRenderer documentRenderer, PdfDocument pdfDocument, int indexOfCorner) {
        IRenderer cornerRenderer = this.createRendererFromElement(cornerBoxElement, documentRenderer, pdfDocument);
        if (cornerRenderer != null) {
            float rendererWidth = this.margins[indexOfCorner % 3 == 0 ? 3 : 1] - this.getSizeOfOneSide(cornerRenderer, 44, 11, 48) - this.getSizeOfOneSide(cornerRenderer, 45, 12, 49);
            float rendererHeight = this.margins[indexOfCorner > 1 ? 2 : 0] - this.getSizeOfOneSide(cornerRenderer, 46, 13, 50) - this.getSizeOfOneSide(cornerRenderer, 43, 10, 47);
            cornerRenderer.setProperty(77, (Object)UnitValue.createPointValue((float)rendererWidth));
            cornerRenderer.setProperty(27, (Object)UnitValue.createPointValue((float)rendererHeight));
            return cornerRenderer;
        }
        return null;
    }

    private IRenderer createRendererFromElement(IElement element, DocumentRenderer documentRenderer, PdfDocument pdfDocument) {
        if (element != null) {
            IRenderer renderer = element.createRendererSubTree();
            PageMarginBoxBuilder.removeAreaBreaks(renderer);
            renderer.setParent((IRenderer)documentRenderer);
            if (pdfDocument.isTagged()) {
                LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)renderer.getProperty(108);
                LayoutTaggingHelper.addTreeHints((LayoutTaggingHelper)taggingHelper, (IRenderer)renderer);
            }
            return renderer;
        }
        return null;
    }

    private static void removeAreaBreaks(IRenderer renderer) {
        ArrayList<IRenderer> areaBreaks = null;
        for (IRenderer child : renderer.getChildRenderers()) {
            if (child instanceof AreaBreakRenderer) {
                if (areaBreaks == null) {
                    areaBreaks = new ArrayList<IRenderer>();
                }
                areaBreaks.add(child);
                continue;
            }
            PageMarginBoxBuilder.removeAreaBreaks(child);
        }
        if (areaBreaks != null) {
            renderer.getChildRenderers().removeAll(areaBreaks);
        }
    }

    private void determineSizes(int side) {
        float[][] marginsBordersPaddingsWidths = new float[3][4];
        for (int i = 0; i < 3; ++i) {
            if (this.renderers[side * 4 + i + 1] == null) continue;
            marginsBordersPaddingsWidths[i][0] = this.getSizeOfOneSide(this.renderers[side * 4 + i + 1], 46, 13, 50);
            marginsBordersPaddingsWidths[i][1] = this.getSizeOfOneSide(this.renderers[side * 4 + i + 1], 45, 12, 49);
            marginsBordersPaddingsWidths[i][2] = this.getSizeOfOneSide(this.renderers[side * 4 + i + 1], 43, 10, 47);
            marginsBordersPaddingsWidths[i][3] = this.getSizeOfOneSide(this.renderers[side * 4 + i + 1], 44, 11, 48);
        }
        Rectangle withoutMargins = this.pageSize.clone().applyMargins(this.margins[0], this.margins[1], this.margins[2], this.margins[3], false);
        HashMap<String, PageMarginBoxContextNode> resolvedPMBMap = new HashMap<String, PageMarginBoxContextNode>();
        for (int i = side * 4 + 1; i < side * 4 + 4; ++i) {
            if (this.nodes[i] == null) continue;
            resolvedPMBMap.put(this.nodes[i].getMarginBoxName(), this.nodes[i]);
        }
        DimensionContainer[] dims = new DimensionContainer[3];
        String[] cssRuleName = this.getRuleNames(side);
        float withoutMarginsWidthOrHeight = side % 2 == 0 ? withoutMargins.getWidth() : withoutMargins.getHeight();
        for (int i = 0; i < 3; ++i) {
            dims[i] = side % 2 == 0 ? this.retrievePageMarginBoxWidths((PageMarginBoxContextNode)resolvedPMBMap.get(cssRuleName[i]), this.renderers[side * 4 + i + 1], withoutMarginsWidthOrHeight, marginsBordersPaddingsWidths[i][1] + marginsBordersPaddingsWidths[i][3]) : this.retrievePageMarginBoxHeights((PageMarginBoxContextNode)resolvedPMBMap.get(cssRuleName[i]), this.renderers[side * 4 + i + 1], this.margins[side], withoutMarginsWidthOrHeight, marginsBordersPaddingsWidths[i][0] + marginsBordersPaddingsWidths[i][2]);
        }
        float[] widthOrHeightResults = this.calculatePageMarginBoxDimensions(dims[0], dims[1], dims[2], withoutMarginsWidthOrHeight);
        float centerOrMiddleCoord = side % 2 == 0 ? this.getStartCoordForCenterOrMiddleBox(withoutMarginsWidthOrHeight, widthOrHeightResults[1], withoutMargins.getLeft()) : this.getStartCoordForCenterOrMiddleBox(withoutMarginsWidthOrHeight, widthOrHeightResults[1], withoutMargins.getBottom());
        Rectangle[] result = this.getRectangles(side, withoutMargins, centerOrMiddleCoord, widthOrHeightResults);
        for (int i = 0; i < 3; ++i) {
            if (this.nodes[side * 4 + i + 1] == null) continue;
            this.nodes[side * 4 + i + 1].setPageMarginBoxRectangle(new Rectangle(result[i]).increaseHeight(1.0E-5f));
            UnitValue width = UnitValue.createPointValue((float)(result[i].getWidth() - marginsBordersPaddingsWidths[i][1] - marginsBordersPaddingsWidths[i][3]));
            UnitValue height = UnitValue.createPointValue((float)(result[i].getHeight() - marginsBordersPaddingsWidths[i][0] - marginsBordersPaddingsWidths[i][2]));
            if (Math.abs(width.getValue()) < 1.0E-5f || Math.abs(height.getValue()) < 1.0E-5f) {
                this.renderers[side * 4 + i + 1] = null;
                continue;
            }
            this.renderers[side * 4 + i + 1].setProperty(77, (Object)width);
            this.renderers[side * 4 + i + 1].setProperty(27, (Object)height);
        }
    }

    private String[] getRuleNames(int side) {
        switch (side) {
            case 0: {
                return new String[]{"top-left", "top-center", "top-right"};
            }
            case 1: {
                return new String[]{"right-top", "right-middle", "right-bottom"};
            }
            case 2: {
                return new String[]{"bottom-right", "bottom-center", "bottom-left"};
            }
            case 3: {
                return new String[]{"left-bottom", "left-middle", "left-top"};
            }
        }
        return new String[3];
    }

    private Rectangle[] getRectangles(int side, Rectangle withoutMargins, float centerOrMiddleCoord, float[] results) {
        switch (side) {
            case 0: {
                return new Rectangle[]{new Rectangle(withoutMargins.getLeft(), withoutMargins.getTop(), results[0], this.margins[0]), new Rectangle(centerOrMiddleCoord, withoutMargins.getTop(), results[1], this.margins[0]), new Rectangle(withoutMargins.getRight() - results[2], withoutMargins.getTop(), results[2], this.margins[0])};
            }
            case 1: {
                return new Rectangle[]{new Rectangle(withoutMargins.getRight(), withoutMargins.getTop() - results[0], this.margins[1], results[0]), new Rectangle(withoutMargins.getRight(), centerOrMiddleCoord, this.margins[1], results[1]), new Rectangle(withoutMargins.getRight(), withoutMargins.getBottom(), this.margins[1], results[2])};
            }
            case 2: {
                return new Rectangle[]{new Rectangle(withoutMargins.getRight() - results[0], 0.0f, results[0], this.margins[2]), new Rectangle(centerOrMiddleCoord, 0.0f, results[1], this.margins[2]), new Rectangle(withoutMargins.getLeft(), 0.0f, results[2], this.margins[2])};
            }
            case 3: {
                return new Rectangle[]{new Rectangle(0.0f, withoutMargins.getBottom(), this.margins[3], results[0]), new Rectangle(0.0f, centerOrMiddleCoord, this.margins[3], results[1]), new Rectangle(0.0f, withoutMargins.getTop() - results[2], this.margins[3], results[2])};
            }
        }
        return new Rectangle[3];
    }

    private float getSizeOfOneSide(IRenderer renderer, int marginProperty, int borderProperty, int paddingProperty) {
        Border border;
        float marginWidth = 0.0f;
        float paddingWidth = 0.0f;
        float borderWidth = 0.0f;
        UnitValue temp = (UnitValue)renderer.getProperty(marginProperty);
        if (null != temp) {
            marginWidth = temp.getValue();
        }
        if (null != (temp = (UnitValue)renderer.getProperty(paddingProperty))) {
            paddingWidth = temp.getValue();
        }
        if (null != (border = (Border)renderer.getProperty(borderProperty))) {
            borderWidth = border.getWidth();
        }
        return marginWidth + paddingWidth + borderWidth;
    }

    private DimensionContainer retrievePageMarginBoxWidths(PageMarginBoxContextNode pmbcNode, IRenderer renderer, float maxWidth, float additionalWidthFix) {
        if (pmbcNode == null) {
            return null;
        }
        return new WidthDimensionContainer((CssContextNode)pmbcNode, maxWidth, renderer, additionalWidthFix);
    }

    private DimensionContainer retrievePageMarginBoxHeights(PageMarginBoxContextNode pmbcNode, IRenderer renderer, float marginWidth, float maxHeight, float additionalHeightFix) {
        if (pmbcNode == null) {
            return null;
        }
        return new HeightDimensionContainer((CssContextNode)pmbcNode, marginWidth, maxHeight, renderer, additionalHeightFix);
    }

    private float[] calculatePageMarginBoxDimensions(DimensionContainer dimA, DimensionContainer dimB, DimensionContainer dimC, float availableDimension) {
        float maxContentDimensionA = 0.0f;
        float minContentDimensionA = 0.0f;
        float maxContentDimensionB = 0.0f;
        float minContentDimensionB = 0.0f;
        float maxContentDimensionC = 0.0f;
        float minContentDimensionC = 0.0f;
        float[] dimensions = new float[3];
        if (this.isContainerEmpty(dimA) && this.isContainerEmpty(dimB) && this.isContainerEmpty(dimC)) {
            return dimensions;
        }
        if (this.isContainerEmpty(dimB)) {
            if (this.isContainerEmpty(dimA)) {
                dimensions[2] = dimC.isAutoDimension() ? availableDimension : dimC.dimension;
            } else if (this.isContainerEmpty(dimC)) {
                dimensions[0] = dimA.isAutoDimension() ? availableDimension : dimA.dimension;
            } else if (dimA.isAutoDimension() && dimC.isAutoDimension()) {
                maxContentDimensionA = dimA.maxContentDimension;
                minContentDimensionA = dimA.minContentDimension;
                maxContentDimensionC = dimC.maxContentDimension;
                minContentDimensionC = dimC.minContentDimension;
                float[] distributedWidths = this.distributeDimensionBetweenTwoBoxes(maxContentDimensionA, minContentDimensionA, maxContentDimensionC, minContentDimensionC, availableDimension);
                dimensions = new float[]{distributedWidths[0], 0.0f, distributedWidths[1]};
            } else {
                dimensions[0] = !dimA.isAutoDimension() ? dimA.dimension : availableDimension - dimC.dimension;
                dimensions[2] = !dimC.isAutoDimension() ? dimC.dimension : availableDimension - dimA.dimension;
            }
        } else {
            if (!this.isContainerEmpty(dimA)) {
                if (dimA.isAutoDimension()) {
                    maxContentDimensionA = dimA.maxContentDimension;
                    minContentDimensionA = dimA.minContentDimension;
                } else {
                    maxContentDimensionA = dimA.dimension;
                    minContentDimensionA = dimA.dimension;
                }
            }
            if (!this.isContainerEmpty(dimC)) {
                if (dimC.isAutoDimension()) {
                    maxContentDimensionC = dimC.maxContentDimension;
                    minContentDimensionC = dimC.minContentDimension;
                } else {
                    maxContentDimensionC = dimC.dimension;
                    minContentDimensionC = dimC.dimension;
                }
            }
            if (dimB.isAutoDimension()) {
                float maxContentWidthAC = 2.0f * Math.max(maxContentDimensionA, maxContentDimensionC);
                float minContentWidthAC = 2.0f * Math.max(minContentDimensionA, minContentDimensionC);
                maxContentDimensionB = dimB.maxContentDimension;
                minContentDimensionB = dimB.minContentDimension;
                float[] distributedDimensions = this.distributeDimensionBetweenTwoBoxes(maxContentDimensionB, minContentDimensionB, maxContentWidthAC, minContentWidthAC, availableDimension);
                float newAvailableDimension = (availableDimension - distributedDimensions[0]) / 2.0f;
                dimensions = new float[]{newAvailableDimension, distributedDimensions[0], newAvailableDimension};
            } else {
                dimensions[1] = dimB.dimension;
                float newAvailableDimension = (availableDimension - dimensions[1]) / 2.0f;
                if (newAvailableDimension > Float.MAX_VALUE - MinMaxWidthUtils.getEps()) {
                    newAvailableDimension = Float.MAX_VALUE - MinMaxWidthUtils.getEps();
                }
                dimensions[0] = Math.min(maxContentDimensionA, newAvailableDimension) + MinMaxWidthUtils.getEps();
                dimensions[2] = Math.min(maxContentDimensionC, newAvailableDimension) + MinMaxWidthUtils.getEps();
            }
            this.setManualDimension(dimA, dimensions, 0);
            this.setManualDimension(dimC, dimensions, 2);
        }
        if (this.recalculateIfNecessary(dimA, dimensions, 0) || this.recalculateIfNecessary(dimB, dimensions, 1) || this.recalculateIfNecessary(dimC, dimensions, 2)) {
            return this.calculatePageMarginBoxDimensions(dimA, dimB, dimC, availableDimension);
        }
        this.removeNegativeValues(dimensions);
        return dimensions;
    }

    private boolean isContainerEmpty(DimensionContainer container) {
        return container == null || Math.abs(container.maxContentDimension) < 1.0E-5f;
    }

    private void removeNegativeValues(float[] dimensions) {
        for (int i = 0; i < dimensions.length; ++i) {
            if (!(dimensions[i] < 0.0f)) continue;
            dimensions[i] = 0.0f;
        }
    }

    private float getStartCoordForCenterOrMiddleBox(float availableDimension, float dimensionResult, float offset) {
        return offset + (availableDimension - dimensionResult) / 2.0f;
    }

    private void setManualDimension(DimensionContainer dim, float[] dimensions, int index) {
        if (dim != null && !dim.isAutoDimension()) {
            dimensions[index] = dim.dimension;
        }
    }

    private float[] distributeDimensionBetweenTwoBoxes(float maxContentDimensionA, float minContentDimensionA, float maxContentDimensionC, float minContentDimensionC, float availableDimension) {
        float maxSum = maxContentDimensionA + maxContentDimensionC;
        float minSum = minContentDimensionA + minContentDimensionC;
        if (maxSum < availableDimension) {
            return this.calculateDistribution(maxContentDimensionA, maxContentDimensionC, maxContentDimensionA, maxContentDimensionC, maxSum, availableDimension);
        }
        if (minSum < availableDimension) {
            return this.calculateDistribution(minContentDimensionA, minContentDimensionC, maxContentDimensionA - minContentDimensionA, maxContentDimensionC - minContentDimensionC, maxSum - minSum, availableDimension);
        }
        return this.calculateDistribution(minContentDimensionA, minContentDimensionC, minContentDimensionA, minContentDimensionC, minSum, availableDimension);
    }

    private float[] calculateDistribution(float argA, float argC, float flexA, float flexC, float sum, float availableDimension) {
        float flexRatioC;
        float flexRatioA;
        if (CssUtils.compareFloats((float)sum, (float)0.0f)) {
            flexRatioA = 1.0f;
            flexRatioC = 1.0f;
        } else {
            flexRatioA = flexA / sum;
            flexRatioC = flexC / sum;
        }
        float flexSpace = availableDimension - (argA + argC);
        return new float[]{argA + flexRatioA * flexSpace, argC + flexRatioC * flexSpace};
    }

    private boolean recalculateIfNecessary(DimensionContainer dim, float[] dimensions, int index) {
        if (dim != null) {
            if (dimensions[index] < dim.minDimension && dim.isAutoDimension()) {
                dim.dimension = dim.minDimension;
                return true;
            }
            if (dimensions[index] > dim.maxDimension && dim.isAutoDimension()) {
                dim.dimension = dim.maxDimension;
                return true;
            }
        }
        return false;
    }

    private Rectangle[] calculateMarginBoxRectanglesCornersOnly() {
        float topMargin = this.margins[0];
        float rightMargin = this.margins[1];
        float bottomMargin = this.margins[2];
        float leftMargin = this.margins[3];
        Rectangle withoutMargins = this.pageSize.clone().applyMargins(topMargin, rightMargin, bottomMargin, leftMargin, false);
        Rectangle tlc = new Rectangle(0.0f, withoutMargins.getTop(), leftMargin, topMargin);
        Rectangle trc = new Rectangle(withoutMargins.getRight(), withoutMargins.getTop(), rightMargin, topMargin);
        Rectangle blc = new Rectangle(0.0f, 0.0f, leftMargin, bottomMargin);
        Rectangle brc = new Rectangle(withoutMargins.getRight(), 0.0f, rightMargin, bottomMargin);
        Rectangle[] groupedRectangles = new Rectangle[]{tlc, null, null, null, trc, null, null, null, brc, null, null, null, blc, null, null, null};
        return groupedRectangles;
    }

    private Rectangle calculateContainingBlockSizesForMarginBox(int marginBoxInd, Rectangle pageMarginBoxRectangle) {
        if (marginBoxInd == 0 || marginBoxInd == 4 || marginBoxInd == 8 || marginBoxInd == 12) {
            return pageMarginBoxRectangle;
        }
        Rectangle withoutMargins = this.pageSize.clone().applyMargins(this.margins[0], this.margins[1], this.margins[2], this.margins[3], false);
        if (marginBoxInd < 4) {
            return new Rectangle(withoutMargins.getWidth(), this.margins[0]);
        }
        if (marginBoxInd < 8) {
            return new Rectangle(this.margins[1], withoutMargins.getHeight());
        }
        if (marginBoxInd < 12) {
            return new Rectangle(withoutMargins.getWidth(), this.margins[2]);
        }
        return new Rectangle(this.margins[3], withoutMargins.getHeight());
    }

    int mapMarginBoxNameToIndex(String marginBoxName) {
        switch (marginBoxName) {
            case "top-left-corner": {
                return 0;
            }
            case "top-left": {
                return 1;
            }
            case "top-center": {
                return 2;
            }
            case "top-right": {
                return 3;
            }
            case "top-right-corner": {
                return 4;
            }
            case "right-top": {
                return 5;
            }
            case "right-middle": {
                return 6;
            }
            case "right-bottom": {
                return 7;
            }
            case "bottom-right-corner": {
                return 8;
            }
            case "bottom-right": {
                return 9;
            }
            case "bottom-center": {
                return 10;
            }
            case "bottom-left": {
                return 11;
            }
            case "bottom-left-corner": {
                return 12;
            }
            case "left-bottom": {
                return 13;
            }
            case "left-middle": {
                return 14;
            }
            case "left-top": {
                return 15;
            }
        }
        return -1;
    }
}

