/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.xfdf.AnnotObject;
import com.itextpdf.forms.xfdf.AnnotsObject;
import com.itextpdf.forms.xfdf.FieldObject;
import com.itextpdf.forms.xfdf.FieldsObject;
import com.itextpdf.forms.xfdf.XfdfObject;
import com.itextpdf.forms.xfdf.XfdfObjectUtils;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfCircleAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFreeTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolyGeomAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSquareAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfStampAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextMarkupAnnotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XfdfReader {
    private static final Logger logger = LoggerFactory.getLogger(XfdfReader.class);
    private final Map<AnnotObject, PdfTextAnnotation> annotationsWithInReplyTo = new HashMap<AnnotObject, PdfTextAnnotation>();

    XfdfReader() {
    }

    void mergeXfdfIntoPdf(XfdfObject xfdfObject, PdfDocument pdfDocument, String pdfDocumentName) {
        if (xfdfObject.getF() != null && xfdfObject.getF().getHref() != null) {
            if (pdfDocumentName.equalsIgnoreCase(xfdfObject.getF().getHref())) {
                logger.info("Xfdf href and pdf name are equal. Continue merge");
            } else {
                logger.warn("Xfdf href attribute and pdf document name are different!");
            }
        } else {
            logger.warn("Xfdf no f object to compare.");
        }
        PdfAcroForm form = PdfFormCreator.getAcroForm(pdfDocument, false);
        if (form != null) {
            this.mergeFields(xfdfObject.getFields(), form);
            this.mergeAnnotations(xfdfObject.getAnnots(), pdfDocument);
        }
    }

    private void mergeFields(FieldsObject fieldsObject, PdfAcroForm form) {
        if (fieldsObject != null && fieldsObject.getFieldList() != null && !fieldsObject.getFieldList().isEmpty()) {
            Map<String, PdfFormField> formFields = form.getAllFormFields();
            for (FieldObject xfdfField : fieldsObject.getFieldList()) {
                String name = xfdfField.getName();
                if (formFields.get(name) != null && xfdfField.getValue() != null) {
                    formFields.get(name).setValue(xfdfField.getValue());
                    continue;
                }
                logger.error("Xfdf no such field in pdf document!");
            }
        }
    }

    private void mergeAnnotations(AnnotsObject annotsObject, PdfDocument pdfDocument) {
        List<AnnotObject> annotList = null;
        if (annotsObject != null) {
            annotList = annotsObject.getAnnotsList();
        }
        if (annotList != null && !annotList.isEmpty()) {
            for (AnnotObject annot : annotList) {
                this.addAnnotationToPdf(annot, pdfDocument);
            }
        }
        this.setInReplyTo(pdfDocument);
    }

    private void setInReplyTo(PdfDocument pdfDocument) {
        for (Map.Entry<AnnotObject, PdfTextAnnotation> annots : this.annotationsWithInReplyTo.entrySet()) {
            AnnotObject xfdfAnnot = annots.getKey();
            String inReplyTo = xfdfAnnot.getAttributeValue("inreplyto");
            String replyType = xfdfAnnot.getAttributeValue("replyType");
            for (PdfAnnotation pdfAnnotation : pdfDocument.getPage(Integer.parseInt(xfdfAnnot.getAttributeValue("page"))).getAnnotations()) {
                if (pdfAnnotation.getName() == null || !inReplyTo.equals(pdfAnnotation.getName().getValue())) continue;
                annots.getValue().setInReplyTo(pdfAnnotation);
                if (replyType == null) continue;
                annots.getValue().setReplyType(new PdfName(replyType));
            }
        }
    }

    private void addCommonAnnotationAttributes(PdfAnnotation annotation, AnnotObject annotObject) {
        String flags = annotObject.getAttributeValue("flags");
        String color = annotObject.getAttributeValue("color");
        String date = annotObject.getAttributeValue("date");
        String name = annotObject.getAttributeValue("name");
        String title = annotObject.getAttributeValue("title");
        if (flags != null) {
            annotation.setFlags(XfdfObjectUtils.convertFlagsFromString(flags));
        }
        if (color != null) {
            annotation.setColor(XfdfObjectUtils.convertColorFloatsFromString(annotObject.getAttributeValue("color")));
        }
        if (date != null) {
            annotation.setDate(new PdfString(annotObject.getAttributeValue("date")));
        }
        if (name != null) {
            annotation.setName(new PdfString(annotObject.getAttributeValue("name")));
        }
        if (title != null) {
            annotation.setTitle(new PdfString(annotObject.getAttributeValue("title")));
        }
    }

    private void addMarkupAnnotationAttributes(PdfMarkupAnnotation annotation, AnnotObject annotObject) {
        String creationDate = annotObject.getAttributeValue("creationdate");
        String opacity = annotObject.getAttributeValue("opacity");
        String subject = annotObject.getAttributeValue("subject");
        if (creationDate != null) {
            annotation.setCreationDate(new PdfString(creationDate));
        }
        if (opacity != null) {
            annotation.setOpacity(new PdfNumber(Double.parseDouble(opacity)));
        }
        if (subject != null) {
            annotation.setSubject(new PdfString(subject));
        }
    }

    private void addBorderStyleAttributes(PdfAnnotation annotation, AnnotObject annotObject) {
        PdfDictionary borderStyle = ((PdfDictionary)annotation.getPdfObject()).getAsDictionary(PdfName.BS);
        if (borderStyle == null) {
            borderStyle = new PdfDictionary();
        }
        String width = annotObject.getAttributeValue("width");
        String dashes = annotObject.getAttributeValue("dashes");
        String style = annotObject.getAttributeValue("style");
        if (width != null) {
            borderStyle.put(PdfName.W, (PdfObject)new PdfNumber(Double.parseDouble(width)));
        }
        if (dashes != null) {
            borderStyle.put(PdfName.D, (PdfObject)XfdfObjectUtils.convertDashesFromString(dashes));
        }
        if (style != null && !"cloudy".equals(style)) {
            borderStyle.put(PdfName.S, (PdfObject)new PdfName(StringNormalizer.toUpperCase((String)style.substring(0, 1))));
        }
        if (borderStyle.size() > 0) {
            annotation.put(PdfName.BS, (PdfObject)borderStyle);
        }
    }

    private void addBorderEffectAttributes(PdfAnnotation annotation, AnnotObject annotObject) {
        String intensity;
        boolean isCloudyEffectSet;
        PdfDictionary borderEffect = ((PdfDictionary)annotation.getPdfObject()).getAsDictionary(PdfName.BE);
        if (borderEffect == null) {
            borderEffect = new PdfDictionary();
        }
        boolean bl = isCloudyEffectSet = (intensity = annotObject.getAttributeValue("intensity")) != null;
        if (isCloudyEffectSet) {
            borderEffect.put(PdfName.S, (PdfObject)new PdfName("C"));
            borderEffect.put(PdfName.I, (PdfObject)new PdfNumber(Double.parseDouble(intensity)));
            annotation.put(PdfName.BE, (PdfObject)borderEffect);
        }
    }

    private void addAnnotationToPdf(AnnotObject annotObject, PdfDocument pdfDocument) {
        String annotName = annotObject.getName();
        if (annotName != null) {
            switch (annotName) {
                case "text": {
                    String inReplyTo;
                    PdfTextAnnotation pdfTextAnnotation = new PdfTextAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfTextAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfTextAnnotation, annotObject);
                    String icon = annotObject.getAttributeValue("icon");
                    String state = annotObject.getAttributeValue("state");
                    String stateModel = annotObject.getAttributeValue("statemodel");
                    if (icon != null) {
                        pdfTextAnnotation.setIconName(new PdfName(icon));
                    }
                    if (stateModel != null) {
                        pdfTextAnnotation.setStateModel(new PdfString(stateModel));
                        if (state == null) {
                            state = "Marked".equals(stateModel) ? "Unmarked" : "None";
                        }
                        pdfTextAnnotation.setState(new PdfString(state));
                    }
                    if ((inReplyTo = annotObject.getAttributeValue("inreplyto")) != null) {
                        this.annotationsWithInReplyTo.put(annotObject, pdfTextAnnotation);
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttributeValue("page"))).addAnnotation((PdfAnnotation)pdfTextAnnotation);
                    break;
                }
                case "highlight": {
                    PdfTextMarkupAnnotation pdfHighLightAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.Highlight, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfHighLightAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfHighLightAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfHighLightAnnotation);
                    break;
                }
                case "underline": {
                    PdfTextMarkupAnnotation pdfUnderlineAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.Underline, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfUnderlineAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfUnderlineAnnotation, annotObject);
                    String intent = annotObject.getAttributeValue("intent");
                    if (intent != null) {
                        pdfUnderlineAnnotation.setIntent(new PdfName(intent));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfUnderlineAnnotation);
                    break;
                }
                case "strikeout": {
                    PdfTextMarkupAnnotation pdfStrikeoutAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.StrikeOut, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfStrikeoutAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfStrikeoutAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfStrikeoutAnnotation);
                    break;
                }
                case "squiggly": {
                    PdfTextMarkupAnnotation pdfSquigglyAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.Squiggly, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfSquigglyAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfSquigglyAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfSquigglyAnnotation);
                    break;
                }
                case "circle": {
                    PdfCircleAnnotation pdfCircleAnnotation = new PdfCircleAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfCircleAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfCircleAnnotation, annotObject);
                    this.addBorderStyleAttributes((PdfAnnotation)pdfCircleAnnotation, annotObject);
                    this.addBorderEffectAttributes((PdfAnnotation)pdfCircleAnnotation, annotObject);
                    if (annotObject.getAttributeValue("interior-color") != null) {
                        pdfCircleAnnotation.setInteriorColor(XfdfObjectUtils.convertColorFloatsFromString(annotObject.getAttributeValue("interior-color")));
                    }
                    if (annotObject.getAttributeValue("fringe") != null) {
                        pdfCircleAnnotation.setRectangleDifferences(XfdfObjectUtils.convertFringeFromString(annotObject.getAttributeValue("fringe")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfCircleAnnotation);
                    break;
                }
                case "square": {
                    PdfSquareAnnotation pdfSquareAnnotation = new PdfSquareAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfSquareAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfSquareAnnotation, annotObject);
                    this.addBorderStyleAttributes((PdfAnnotation)pdfSquareAnnotation, annotObject);
                    this.addBorderEffectAttributes((PdfAnnotation)pdfSquareAnnotation, annotObject);
                    if (annotObject.getAttributeValue("interior-color") != null) {
                        pdfSquareAnnotation.setInteriorColor(XfdfObjectUtils.convertColorFloatsFromString(annotObject.getAttributeValue("interior-color")));
                    }
                    if (annotObject.getAttributeValue("fringe") != null) {
                        pdfSquareAnnotation.setRectangleDifferences(XfdfObjectUtils.convertFringeFromString(annotObject.getAttributeValue("fringe")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfSquareAnnotation);
                    break;
                }
                case "polygon": {
                    Rectangle rect = XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect"));
                    float[] vertices = XfdfObjectUtils.convertVerticesFromString(annotObject.getVertices());
                    PdfPolyGeomAnnotation polygonAnnotation = PdfPolyGeomAnnotation.createPolygon((Rectangle)rect, (float[])vertices);
                    this.addCommonAnnotationAttributes((PdfAnnotation)polygonAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)polygonAnnotation, annotObject);
                    this.addBorderStyleAttributes((PdfAnnotation)polygonAnnotation, annotObject);
                    this.addBorderEffectAttributes((PdfAnnotation)polygonAnnotation, annotObject);
                    if (annotObject.getAttributeValue("interior-color") != null) {
                        polygonAnnotation.setInteriorColor(XfdfObjectUtils.convertColorFloatsFromString(annotObject.getAttributeValue("interior-color")));
                    }
                    if (annotObject.getAttributeValue("intent") != null) {
                        polygonAnnotation.setIntent(new PdfName(annotObject.getAttributeValue("intent")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)polygonAnnotation);
                    break;
                }
                case "polyline": {
                    Rectangle polylineRect = XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect"));
                    float[] polylineVertices = XfdfObjectUtils.convertVerticesFromString(annotObject.getVertices());
                    PdfPolyGeomAnnotation polylineAnnotation = PdfPolyGeomAnnotation.createPolyLine((Rectangle)polylineRect, (float[])polylineVertices);
                    this.addCommonAnnotationAttributes((PdfAnnotation)polylineAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)polylineAnnotation, annotObject);
                    this.addBorderStyleAttributes((PdfAnnotation)polylineAnnotation, annotObject);
                    this.addBorderEffectAttributes((PdfAnnotation)polylineAnnotation, annotObject);
                    if (annotObject.getAttributeValue("interior-color") != null) {
                        polylineAnnotation.setInteriorColor(XfdfObjectUtils.convertColorFloatsFromString(annotObject.getAttributeValue("interior-color")));
                    }
                    if (annotObject.getAttributeValue("intent") != null) {
                        polylineAnnotation.setIntent(new PdfName(annotObject.getAttributeValue("intent")));
                    }
                    String head = annotObject.getAttributeValue("head");
                    String tail = annotObject.getAttributeValue("tail");
                    if (head != null || tail != null) {
                        PdfArray lineEndingStyles = new PdfArray();
                        lineEndingStyles.add((PdfObject)new PdfName(head == null ? "None" : head));
                        lineEndingStyles.add((PdfObject)new PdfName(tail == null ? "None" : tail));
                        polylineAnnotation.setLineEndingStyles(lineEndingStyles);
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)polylineAnnotation);
                    break;
                }
                case "stamp": {
                    PdfStampAnnotation pdfStampAnnotation = new PdfStampAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfStampAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfStampAnnotation, annotObject);
                    if (annotObject.getAttributeValue("icon") != null) {
                        pdfStampAnnotation.setIconName(new PdfName(annotObject.getAttributeValue("icon")));
                    }
                    if (annotObject.getAttributeValue("rotation") != null) {
                        pdfStampAnnotation.setRotation(Integer.parseInt(annotObject.getAttributeValue("rotation")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfStampAnnotation);
                    break;
                }
                case "freetext": {
                    PdfFreeTextAnnotation pdfFreeTextAnnotation = new PdfFreeTextAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), annotObject.getContents());
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfFreeTextAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfFreeTextAnnotation, annotObject);
                    this.addBorderStyleAttributes((PdfAnnotation)pdfFreeTextAnnotation, annotObject);
                    if (annotObject.getAttributeValue("rotation") != null) {
                        pdfFreeTextAnnotation.setRotation(Integer.parseInt(annotObject.getAttributeValue("rotation")));
                    }
                    if (annotObject.getAttributeValue("justification") != null) {
                        pdfFreeTextAnnotation.setJustification(XfdfObjectUtils.convertJustificationFromStringToInteger(annotObject.getAttributeValue("justification")));
                    }
                    if (annotObject.getAttributeValue("intent") != null) {
                        pdfFreeTextAnnotation.setIntent(new PdfName(annotObject.getAttributeValue("intent")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfFreeTextAnnotation);
                    break;
                }
                default: {
                    logger.warn(MessageFormatUtil.format((String)"Xfdf annotation \"{0}\" is not supported", (Object[])new Object[]{annotName}));
                }
            }
        }
    }
}

