/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.call;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.call.CallArg;
import org.beetl.sql.core.call.CallReady;
import org.beetl.sql.core.call.InArg;
import org.beetl.sql.core.call.OutArg;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.call.InConfig;
import org.beetl.sql.mapper.call.OutBeanConfig;

public class CallMapperSelectInvoke
extends MapperInvoke {
    String sql;
    Class target;
    InConfig inConfig;
    OutBeanConfig outBeanConfig;
    boolean isUpdate = false;
    boolean isSingle = false;

    public CallMapperSelectInvoke(String sql, Class target, InConfig inConfig, OutBeanConfig outBeanConfig, boolean isUpdate, boolean isSingle) {
        this.sql = sql;
        this.target = target;
        this.inConfig = inConfig;
        this.outBeanConfig = outBeanConfig;
        this.isUpdate = isUpdate;
        this.isSingle = isSingle;
    }

    @Override
    public Object call(SQLManager sm, Class entityClass, Method m, Object[] args) {
        CallReady callReady = new CallReady(this.sql);
        Object outBean = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (this.inConfig.getArgPositionMap().containsKey(i)) {
                    int callPosition = this.inConfig.getArgPositionMap().get(i);
                    Integer jdbcType = this.inConfig.getArgJdbcTypeMap().get(i);
                    if (jdbcType != null) {
                        callReady.add(callPosition, (CallArg)new InArg(arg, jdbcType.intValue()));
                        continue;
                    }
                    callReady.add(callPosition, (CallArg)new InArg(arg));
                    continue;
                }
                if (this.outBeanConfig != null && this.outBeanConfig.getParamIndex() == i) {
                    outBean = arg;
                    for (Map.Entry<Integer, Class> entry : this.outBeanConfig.getIndexTypeMap().entrySet()) {
                        int callPosition = entry.getKey();
                        Class targetType = entry.getValue();
                        Integer jdbcType = this.outBeanConfig.getIndexJdbcMap().get(callPosition);
                        if (jdbcType != null) {
                            callReady.add(callPosition, (CallArg)new OutArg(targetType, jdbcType.intValue()));
                            continue;
                        }
                        callReady.add(callPosition, (CallArg)new OutArg(targetType));
                    }
                    continue;
                }
                throw new IllegalStateException(m.toString());
            }
        }
        Object ret = null;
        if (this.isUpdate) {
            ret = sm.executeCall(callReady);
        } else {
            List list = sm.executeCall(callReady, entityClass);
            ret = this.isSingle ? (list.size() == 0 ? null : list.get(0)) : list;
        }
        if (outBean != null) {
            for (CallArg callArg : callReady.getArgs()) {
                if (!(callArg instanceof OutArg)) continue;
                OutArg outArg = (OutArg)callArg;
                Object outValue = outArg.getOutValue();
                int index = outArg.getIndex();
                String attrName = this.outBeanConfig.indexMap.get(index);
                BeanKit.setBeanProperty((Object)outBean, (Object)outValue, (String)attrName);
            }
        }
        return ret;
    }
}

