/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.core.meta.SchemaMetadataManager;
import org.beetl.sql.core.range.RangeSql;
import org.beetl.sql.core.range.RowNumRange;

public class OracleStyle
extends AbstractDBStyle {
    RowNumRange rowNumRangeHelper = new RowNumRange(this);
    public static int FETCH_SIZE = 100;

    @Override
    public int getIdType(Class c, String idProperty) {
        List ans = BeanKit.getAllAnnotation((Class)c, (String)idProperty);
        int idType = 1;
        for (Annotation an : ans) {
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
        }
        return idType;
    }

    @Override
    public String getName() {
        return "oracle";
    }

    @Override
    public int getDBType() {
        return 2;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.rowNumRangeHelper;
    }

    @Override
    public String getSeqValue(String seqName) {
        return seqName + ".nextval";
    }

    @Override
    public MetadataManager initMetadataManager(ConnectionSource cs) {
        this.metadataManager = new SchemaMetadataManager(cs, this){

            @Override
            protected String[] getScope(String catalog, String schema) {
                return new String[]{"TABLE", "VIEW", "SYNONYM"};
            }
        };
        return this.metadataManager;
    }

    @Override
    public void applyResultSetSetting(ExecuteContext ctx, Connection conn, ResultSet resultSet) throws SQLException {
        resultSet.setFetchSize(FETCH_SIZE);
    }
}

