/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import org.beetl.sql.clazz.kit.AutoSQLEnum;
import org.beetl.sql.core.SqlId;

public class SqlIdFactory {
    public SqlId buildIdentity(Class entity, AutoSQLEnum autoSQLEnum) {
        SqlId sqlId = this.createId(entity, autoSQLEnum.getClassSQL());
        sqlId.managedType = SqlId.ManagedType.auto;
        return sqlId;
    }

    public SqlId createId(Class entity, String id) {
        String className = this.getNamespace(entity);
        SqlId sqlId = SqlId.of(className, id);
        sqlId.managedType = SqlId.ManagedType.resource;
        return sqlId;
    }

    protected String getNamespace(Class entity) {
        if (entity == Sql.class) {
            return "sql";
        }
        return entity.getName();
    }

    public SqlId buildTemplate(String template) {
        SqlId id = this.createId(Template.class, template);
        id.managedType = SqlId.ManagedType.template;
        return id;
    }

    public SqlId buildSql(String sql) {
        SqlId id = this.createId(Sql.class, sql);
        id.managedType = SqlId.ManagedType.sql;
        return id;
    }

    static class Sql {
        Sql() {
        }
    }

    static class Template {
        Template() {
        }
    }
}

