/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.ClassLoaderKit;
import org.beetl.sql.clazz.kit.PropertiesKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.MapperBuilder;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerExtend;
import org.beetl.sql.core.SqlIdFactory;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.engine.template.BeetlTemplateEngine;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.loader.MarkdownClasspathLoader;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.ext.SnowflakeIDAutoGen;
import org.beetl.sql.ext.UUIDAutoGen;
import org.beetl.sql.ext.UUIDAutoGen22;

public class SQLManagerBuilder {
    Properties beetlPs;
    Interceptor[] inters;
    private String defaultSchema;
    private String defaultCatalog;
    private boolean setSchema = false;
    private String name = null;
    private DBStyle dbStyle;
    private SQLLoader sqlLoader;
    private NameConversion nc;
    private ConnectionSource ds;
    private MetadataManager metadataManager;
    private SqlIdFactory sqlIdFactory;
    private final String charset = "UTF-8";
    private boolean isProduct = false;
    private boolean apiProductSetFlag = false;
    SQLTemplateEngine sqlTemplateEngine;
    BeanProcessor beanProcessor;
    MapperBuilder mapperBuilder = null;
    private final List<Interceptor> interceptorList = new LinkedList<Interceptor>();
    private ClassLoaderKit classLoaderKit = null;
    SQLManagerNameGenerator sqlManagerNameGenerator = new SQLManagerNameGenerator();
    public static Map<String, SQLManager> sqlManagerMap = new ConcurrentHashMap<String, SQLManager>();
    Map<String, IDAutoGen> idAutoGenMap = new HashMap<String, IDAutoGen>();
    boolean offsetStartZero = false;
    SQLManagerExtend sqlManagerExtend;
    boolean batchLogOneByOne = false;

    public SQLManagerBuilder(ConnectionSource ds) {
        this.ds = ds;
    }

    public SQLManager build() {
        boolean offsetStartZero;
        this.check();
        SQLManager mySqlManager = new SQLManager();
        DBStyle myDbStyle = this.getDbStyle();
        SQLLoader mySqlLoader = this.getSqlLoader();
        NameConversion myNc = this.getNc();
        Interceptor[] myInters = this.getInters();
        Properties myPs = this.getBeetlPs();
        mySqlManager.isProduct = this.getProduct();
        mySqlManager.charset = "UTF-8";
        SQLTemplateEngine mysSqlTemplateEngine = this.getSqlTemplateEngine();
        myDbStyle.setNameConversion(myNc);
        myDbStyle.init(mysSqlTemplateEngine, myPs);
        MetadataManager myMetadataManager = this.dbStyle.initMetadataManager(this.ds);
        ClassLoaderKit myClassLoaderKit = this.getClassLoaderKit();
        mySqlLoader.setDbStyle(myDbStyle);
        if (mySqlLoader instanceof MarkdownClasspathLoader) {
            ((MarkdownClasspathLoader)mySqlLoader).setClassLoaderKit(myClassLoaderKit);
        }
        mySqlLoader.setProduct(mySqlManager.isProduct);
        mySqlManager.setDs(this.ds);
        mySqlManager.setSQLTemplateEngine(mysSqlTemplateEngine);
        mySqlManager.setDbStyle(myDbStyle);
        mySqlManager.setSqlLoader(mySqlLoader);
        mySqlManager.setNc(myNc);
        mySqlManager.setInters(myInters);
        mySqlManager.setMetaDataManager(myMetadataManager);
        mySqlManager.setMapperBuilder(this.getMapperBuilder());
        mySqlManager.setName(this.getName());
        mySqlManager.setBatchLogOneByOne(this.batchLogOneByOne);
        mySqlManager.offsetStartZero = offsetStartZero = Boolean.parseBoolean(myPs.getProperty("OFFSET_START_ZERO", "false"));
        this.dbStyle.setOffsetStartZero(offsetStartZero);
        BeanProcessor myBeanProcessor = this.getBeanProcessor();
        mySqlManager.setDefaultBeanProcessors(myBeanProcessor);
        SqlIdFactory mySqlIdFactory = this.getSqlIdFactory();
        mySqlManager.setSqlIdFactory(mySqlIdFactory);
        mySqlManager.setClassLoaderKit(myClassLoaderKit);
        mySqlManager.setSqlManagerExtend(this.getSQLManagerExtend());
        this.addDefaultIdGen(mySqlManager);
        this.dbStyle.config(mySqlManager);
        sqlManagerMap.put(this.name, mySqlManager);
        return mySqlManager;
    }

    private void check() {
        if (this.ds == null) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efaSQLManager,\u81f3\u5c11\u9700\u8981\u63d0\u4f9b ConnectionSource");
        }
    }

    private void addDefaultIdGen(SQLManager mySqlManager) {
        if (!this.idAutoGenMap.containsKey("uuid")) {
            this.idAutoGenMap.put("uuid", new UUIDAutoGen());
        }
        if (!this.idAutoGenMap.containsKey("simple")) {
            this.idAutoGenMap.put("simple", new SnowflakeIDAutoGen());
        }
        if (!this.idAutoGenMap.containsKey("uuid22")) {
            this.idAutoGenMap.put("uuid22", new UUIDAutoGen22());
        }
        if (!this.idAutoGenMap.isEmpty()) {
            this.idAutoGenMap.forEach((id, gen) -> mySqlManager.addIdAutoGen((String)id, (IDAutoGen)gen));
        }
    }

    public SQLManagerBuilder addInterceptor(Interceptor interceptor) {
        this.interceptorList.add(interceptor);
        return this;
    }

    public SQLManagerBuilder addInterDebug() {
        this.interceptorList.add(new DebugInterceptor());
        return this;
    }

    private Properties getBeetlPs() {
        if (this.beetlPs == null) {
            Properties ps;
            this.beetlPs = ps = PropertiesKit.getInstance().getPs();
        }
        return this.beetlPs;
    }

    public SQLManagerBuilder setBeetlPs(Properties beetlPs) {
        if (this.beetlPs == null) {
            this.getBeetlPs();
            this.beetlPs.putAll((Map<?, ?>)beetlPs);
        }
        return this;
    }

    public SQLManagerBuilder setBeanProcessor(BeanProcessor beanProcessor) {
        this.beanProcessor = beanProcessor;
        return this;
    }

    private String getDefaultSchema() {
        return this.defaultSchema;
    }

    public SQLManagerBuilder setDefaultSchema(String defaultSchema, String defaultCatalog) {
        this.defaultSchema = defaultSchema;
        this.defaultCatalog = defaultCatalog;
        this.setSchema = true;
        return this;
    }

    public SQLManagerBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.sqlManagerNameGenerator.nextName();
        }
        return this.name;
    }

    private Interceptor[] getInters() {
        if (this.inters == null) {
            this.inters = new Interceptor[0];
        }
        if (this.interceptorList.size() > 0) {
            HashMap<String, Interceptor> map = new HashMap<String, Interceptor>();
            for (Interceptor inter : this.interceptorList) {
                String name = inter.getClass().getName();
                map.put(name, inter);
            }
            for (Interceptor inter : this.inters) {
                String name = inter.getClass().getName();
                map.put(name, inter);
            }
            this.inters = new Interceptor[map.size()];
            int i = 0;
            for (Interceptor inter : map.values()) {
                this.inters[i++] = inter;
            }
        }
        return this.inters;
    }

    public SQLManagerBuilder setInters(Interceptor[] inters) {
        this.inters = inters;
        return this;
    }

    private DBStyle getDbStyle() {
        if (this.dbStyle == null) {
            this.dbStyle = new MySqlStyle();
        }
        return this.dbStyle;
    }

    public SQLManagerBuilder setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
        return this;
    }

    private SQLLoader getSqlLoader() {
        if (this.sqlLoader == null) {
            String charset = this.getBeetlPs().getProperty("CHARSET");
            if (charset == null) {
                charset = "utf-8";
            }
            this.sqlLoader = new MarkdownClasspathLoader("sql", charset);
        }
        return this.sqlLoader;
    }

    public SQLManagerBuilder setSqlLoader(String root, String charset) {
        this.sqlLoader = new MarkdownClasspathLoader(root, charset);
        return this;
    }

    public SQLManagerBuilder setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
        return this;
    }

    private NameConversion getNc() {
        if (this.nc == null) {
            this.nc = new DefaultNameConversion();
        }
        return this.nc;
    }

    private BeanProcessor getBeanProcessor() {
        if (this.beanProcessor == null) {
            this.beanProcessor = new BeanProcessor();
        }
        return this.beanProcessor;
    }

    public SqlIdFactory getSqlIdFactory() {
        if (this.sqlIdFactory == null) {
            this.sqlIdFactory = new SqlIdFactory();
        }
        return this.sqlIdFactory;
    }

    public void setSqlIdFactory(SqlIdFactory sqlIdFactory) {
        this.sqlIdFactory = sqlIdFactory;
    }

    private SQLTemplateEngine getSqlTemplateEngine() {
        if (this.sqlTemplateEngine != null) {
            return this.sqlTemplateEngine;
        }
        this.sqlTemplateEngine = new BeetlTemplateEngine();
        this.sqlTemplateEngine.init(this.getSqlLoader(), this.beetlPs);
        return this.sqlTemplateEngine;
    }

    public SQLManagerBuilder setNc(NameConversion nc) {
        this.nc = nc;
        return this;
    }

    public ClassLoaderKit getClassLoaderKit() {
        if (this.classLoaderKit == null) {
            this.classLoaderKit = new ClassLoaderKit();
        }
        return this.classLoaderKit;
    }

    public MapperBuilder getMapperBuilder() {
        if (this.mapperBuilder == null) {
            Class<?> c = null;
            try {
                c = Class.forName("org.beetl.sql.mapper.DefaultMapperBuilder");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            this.mapperBuilder = (MapperBuilder)BeanKit.newInstance(c);
        }
        return this.mapperBuilder;
    }

    public SQLManagerBuilder setMapperBuilder(MapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
        return this;
    }

    public void setClassLoaderKit(ClassLoaderKit classLoaderKit) {
        this.classLoaderKit = classLoaderKit;
    }

    public SQLManagerBuilder addIdAutoGen(String name, IDAutoGen algorithm) {
        this.idAutoGenMap.put(name, algorithm);
        return this;
    }

    public SQLManagerBuilder setOffsetStartZero(boolean offsetStartZero) {
        this.offsetStartZero = offsetStartZero;
        return this;
    }

    public SQLManagerBuilder setBatchLogOneByOne(boolean oneByOne) {
        this.batchLogOneByOne = oneByOne;
        return this;
    }

    public SQLManagerBuilder setSQLManagerExtend(SQLManagerExtend sqlManagerExtend) {
        this.sqlManagerExtend = sqlManagerExtend;
        return this;
    }

    public SQLManagerExtend getSQLManagerExtend() {
        if (this.sqlManagerExtend == null) {
            this.sqlManagerExtend = new SQLManagerExtend();
        }
        return this.sqlManagerExtend;
    }

    public void setProduct(boolean product) {
        this.isProduct = product;
        this.apiProductSetFlag = true;
    }

    public boolean getProduct() {
        if (this.apiProductSetFlag) {
            return this.isProduct;
        }
        return Boolean.parseBoolean(this.beetlPs.getProperty("PRODUCT_MODE"));
    }

    public ConnectionSource getDs() {
        return this.ds;
    }

    public void setDs(ConnectionSource connectionSource) {
        this.ds = connectionSource;
    }

    static class SQLManagerNameGenerator {
        AtomicInteger count = null;

        SQLManagerNameGenerator() {
        }

        public String nextName() {
            if (this.count == null) {
                this.count = new AtomicInteger(1);
                return "default";
            }
            return "default" + this.count.addAndGet(1);
        }
    }
}

