/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.lang.ref.SoftReference;
import org.beetl.core.io.NoLockStringWriter;

public class SoftReferenceWriter
extends NoLockStringWriter {
    public static int INIT_SIZE = 256;
    public static int MAX_SIZE = 8192;
    boolean used = false;
    int max;
    static ThreadLocal<SoftReference<SoftReferenceWriter>> cache = new ThreadLocal<SoftReference<SoftReferenceWriter>>(){

        @Override
        protected SoftReference<SoftReferenceWriter> initialValue() {
            return null;
        }
    };

    public static SoftReferenceWriter local(int size) {
        SoftReference<SoftReferenceWriter> softReference = cache.get();
        if (softReference == null) {
            return SoftReferenceWriter.init(size);
        }
        SoftReferenceWriter writer = softReference.get();
        if (writer == null) {
            return SoftReferenceWriter.init(size);
        }
        if (writer.used) {
            return new SoftReferenceWriter(INIT_SIZE, size);
        }
        writer.used = true;
        if (writer.buf == null) {
            writer.buf = new char[INIT_SIZE];
        }
        return writer;
    }

    private static SoftReferenceWriter init(int max) {
        SoftReferenceWriter writer = new SoftReferenceWriter(INIT_SIZE, max);
        writer.used = true;
        cache.set(new SoftReference<SoftReferenceWriter>(writer));
        return writer;
    }

    public static SoftReferenceWriter local() {
        return SoftReferenceWriter.local(MAX_SIZE);
    }

    public SoftReferenceWriter(int size, int max) {
        super(size);
        this.max = max;
    }

    @Override
    public String toString() {
        String str = new String(this.buf, 0, this.pos);
        this.clearCache();
        return str;
    }

    @Override
    public void close() {
        this.clearCache();
    }

    protected void clearCache() {
        if (this.used) {
            this.pos = 0;
            this.used = false;
            if (this.buf.length > this.max) {
                this.buf = null;
            }
        }
    }
}

