/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.core;

import com.hfbcjt.open.sdk.core.Code;

public class Results<T> {
    private int code;
    private String msg;
    private T data;
    private Object error;

    private Results(Code c) {
        this.code = c.getBCode();
        this.msg = c.getMsg();
    }

    private Results(Code c, String msg, T data) {
        this.code = c.getBCode();
        this.msg = msg;
        this.data = data;
    }

    private Results(Code c, String msg, T data, Object error) {
        this.code = c.getBCode();
        this.msg = msg;
        this.data = data;
        this.error = error;
    }

    private Results(Code c, T data) {
        this(c);
        this.data = data;
    }

    public Results(int code, String msg, T data, Object error) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.error = error;
    }

    public static <T> Results<T> failure(T data, String msg) {
        return new Results<T>(Code.FAILURE, msg, data);
    }

    public static <T> Results<T> failure(T data) {
        return new Results<T>(Code.FAILURE, data);
    }

    public static <T> Results<T> failure() {
        return Results.failure(null);
    }

    public boolean ifSuccess() {
        return Code.SUCCESS.getBCode() == this.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Object getError() {
        return this.error;
    }

    public Results() {
    }
}

