/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.core;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.hfbcjt.open.sdk.core.Results;
import com.hfbcjt.open.sdk.core.config.OpConfig;
import com.hfbcjt.open.sdk.core.constant.TyhErrorCode;
import com.hfbcjt.open.sdk.core.constant.TyhException;
import com.hfbcjt.open.sdk.core.request.OpRequest;
import com.hfbcjt.open.sdk.core.util.SignStrategy;
import com.hfbcjt.open.sdk.core.util.SignStrategyFactory;
import com.hfbcjt.open.sdk.core.util.SignUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnection {
    private static final Logger logger = LoggerFactory.getLogger(RestConnection.class);
    private final OpConfig opConfig;

    public RestConnection(OpConfig opConfig) {
        this.opConfig = opConfig;
    }

    public <T> Results<T> executePostWithSignature(String path, OpRequest opRequest, Class<T> tClass) {
        String requestUrl = this.opConfig.getRestHost() + path;
        String token = null;
        try {
            token = SignUtil.getRequestToken(opRequest.getAccessId(), opRequest.getData(), opRequest.getSignType(), this.opConfig.getPrivateKey());
        }
        catch (Exception e) {
            return Results.failure(null, e.getMessage());
        }
        logger.info("[\u7b7e\u540d\u4fe1\u606f]\uff1a" + token);
        HttpResponse originalResponse = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)requestUrl).header("Accept", "application/json")).header("Content-Type", "application/json")).header("Authorization", token)).body(opRequest.getData()).timeout(20000).execute();
        this.verifyResponse(originalResponse);
        Results<T> results = this.checkAndGetResponse(originalResponse.body(), tClass);
        logger.info("[\u8bf7\u6c42\u5730\u5740]\uff1a" + requestUrl);
        logger.info("[\u54cd\u5e94\u53c2\u6570]" + JSON.toJSONString((Object)originalResponse.body()));
        return results;
    }

    private void verifyResponse(HttpResponse originalResponse) {
        if (RestConnection.isInvalidHttpCode(originalResponse.getStatus())) {
            throw new TyhException(TyhErrorCode.REQUEST_NETWORKS_ERROR.getCode(), String.format("Wrong HttpStatusCode[%d]%nhttpResponseBody[%.1024s]", originalResponse.getStatus(), originalResponse.body()));
        }
        if (originalResponse.body() != null && !ObjectUtil.isEmpty((Object)originalResponse.body()) && !originalResponse.header("Content-Type").contains("application/json")) {
            throw new TyhException(TyhErrorCode.INTERNAL_SERVER.getCode(), String.format("Unsupported content-type[%s]", originalResponse.header("Content-Type")));
        }
        String opResponseSign = MapUtil.getStr((Map)originalResponse.headers(), (Object)"OP-Signature");
        if (StrUtil.isNotEmpty((CharSequence)opResponseSign) && this.isInvalidResponseSign(opResponseSign, originalResponse.body())) {
            throw new TyhException(TyhErrorCode.INTERNAL_SERVER.getCode(), String.format("Validate response failed,the Open Platform signature is incorrect.%nresponseHeader[%s]\tresponseBody[%.1024s]", originalResponse.headers(), originalResponse.body()));
        }
    }

    private static boolean isInvalidHttpCode(int httpCode) {
        return httpCode < 200 || httpCode >= 300;
    }

    private boolean isInvalidResponseSign(String opResponseSign, String body) {
        try {
            SignStrategy strategy = SignStrategyFactory.getStrategy(this.opConfig.getSignType());
            return strategy.verify(this.opConfig.getOPPublicKey(), Base64.decode((CharSequence)opResponseSign), body.getBytes(StandardCharsets.UTF_8)) == false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private <T> Results<T> checkAndGetResponse(String resp, Class<T> tClass) {
        JSONObject json = JSON.parseObject((String)resp);
        if (!json.containsKey("code") || !json.containsKey("data")) {
            return Results.failure();
        }
        return new Results<Object>(json.getInteger("code"), json.getString("msg"), json.getObject("data", tClass, new JSONReader.Feature[0]), json.get("error"));
    }
}

