/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.apis.invoice.v1.model;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class InvoiceBlueBatchRequest {
    @NotNull(message="baseInfo must not be null")
    @Valid
    public @NotNull(message="baseInfo must not be null") @Valid BaseInfo baseInfo;
    @NotNull(message="details must not be null")
    @Valid
    private @NotNull(message="details must not be null") @Valid List<DetailInfo> details;

    public BaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public List<DetailInfo> getDetails() {
        return this.details;
    }

    public InvoiceBlueBatchRequest setBaseInfo(BaseInfo baseInfo) {
        this.baseInfo = baseInfo;
        return this;
    }

    public InvoiceBlueBatchRequest setDetails(List<DetailInfo> details) {
        this.details = details;
        return this;
    }

    public InvoiceBlueBatchRequest(BaseInfo baseInfo, List<DetailInfo> details) {
        this.baseInfo = baseInfo;
        this.details = details;
    }

    public InvoiceBlueBatchRequest() {
    }

    public static class BaseInfo {
        private String mail;
        private Integer ifSendMail;
        private String phoneNum;
        private Integer ifSendMessage;
        private String buyerId;
        @NotEmpty
        @Size(max=200, message="\u8d2d\u4e70\u65b9\u540d\u79f0\u8fc7\u957f")
        @Pattern(regexp="^((?!\\s).)*$", message="\u8d2d\u4e70\u65b9 \u5305\u542b\u7279\u6b8a\u7b26\u53f7")
        private @NotEmpty @Size(max=200, message="\u8d2d\u4e70\u65b9\u540d\u79f0\u8fc7\u957f") @Pattern(regexp="^((?!\\s).)*$", message="\u8d2d\u4e70\u65b9 \u5305\u542b\u7279\u6b8a\u7b26\u53f7") String buyerName;
        @NotEmpty
        private String buyerType;
        @Size(max=200, message="\u8d2d\u4e70\u65b9\u5730\u5740\u7535\u8bdd\u8fc7\u957f")
        private @Size(max=200, message="\u8d2d\u4e70\u65b9\u5730\u5740\u7535\u8bdd\u8fc7\u957f") String buyerAddrAndPhoneNum;
        @Size(max=200, message="\u8d2d\u4e70\u65b9\u94f6\u884c\u8d26\u53f7\u8fc7\u957f")
        private @Size(max=200, message="\u8d2d\u4e70\u65b9\u94f6\u884c\u8d26\u53f7\u8fc7\u957f") String buyerBankAccount;
        private String remarks;

        public BaseInfo setMail(String mail) {
            this.mail = mail;
            return this;
        }

        public BaseInfo setIfSendMail(Integer ifSendMail) {
            this.ifSendMail = ifSendMail;
            return this;
        }

        public BaseInfo setPhoneNum(String phoneNum) {
            this.phoneNum = phoneNum;
            return this;
        }

        public BaseInfo setIfSendMessage(Integer ifSendMessage) {
            this.ifSendMessage = ifSendMessage;
            return this;
        }

        public BaseInfo setBuyerId(String buyerId) {
            this.buyerId = buyerId;
            return this;
        }

        public BaseInfo setBuyerName(String buyerName) {
            this.buyerName = buyerName;
            return this;
        }

        public BaseInfo setBuyerType(String buyerType) {
            this.buyerType = buyerType;
            return this;
        }

        public BaseInfo setBuyerAddrAndPhoneNum(String buyerAddrAndPhoneNum) {
            this.buyerAddrAndPhoneNum = buyerAddrAndPhoneNum;
            return this;
        }

        public BaseInfo setBuyerBankAccount(String buyerBankAccount) {
            this.buyerBankAccount = buyerBankAccount;
            return this;
        }

        public BaseInfo setRemarks(String remarks) {
            this.remarks = remarks;
            return this;
        }

        public String getMail() {
            return this.mail;
        }

        public Integer getIfSendMail() {
            return this.ifSendMail;
        }

        public String getPhoneNum() {
            return this.phoneNum;
        }

        public Integer getIfSendMessage() {
            return this.ifSendMessage;
        }

        public String getBuyerId() {
            return this.buyerId;
        }

        public String getBuyerName() {
            return this.buyerName;
        }

        public String getBuyerType() {
            return this.buyerType;
        }

        public String getBuyerAddrAndPhoneNum() {
            return this.buyerAddrAndPhoneNum;
        }

        public String getBuyerBankAccount() {
            return this.buyerBankAccount;
        }

        public String getRemarks() {
            return this.remarks;
        }
    }

    public static class GoodInfoVo {
        private String goodsName;
        private String goodsSpecification;
        private String goodsUnit;
        private Double goodsQuantity;
        private Integer goodsPrice;
        private Integer goodsTotalPrice;
        private Double goodsTaxRate;
        private Integer goodsTotalTax;
        private Integer goodsTotalPriceTax;
        private String goodsCode;
        private Integer goodsLineNo;

        public String getGoodsName() {
            return this.goodsName;
        }

        public String getGoodsSpecification() {
            return this.goodsSpecification;
        }

        public String getGoodsUnit() {
            return this.goodsUnit;
        }

        public Double getGoodsQuantity() {
            return this.goodsQuantity;
        }

        public Integer getGoodsPrice() {
            return this.goodsPrice;
        }

        public Integer getGoodsTotalPrice() {
            return this.goodsTotalPrice;
        }

        public Double getGoodsTaxRate() {
            return this.goodsTaxRate;
        }

        public Integer getGoodsTotalTax() {
            return this.goodsTotalTax;
        }

        public Integer getGoodsTotalPriceTax() {
            return this.goodsTotalPriceTax;
        }

        public String getGoodsCode() {
            return this.goodsCode;
        }

        public Integer getGoodsLineNo() {
            return this.goodsLineNo;
        }

        public GoodInfoVo setGoodsName(String goodsName) {
            this.goodsName = goodsName;
            return this;
        }

        public GoodInfoVo setGoodsSpecification(String goodsSpecification) {
            this.goodsSpecification = goodsSpecification;
            return this;
        }

        public GoodInfoVo setGoodsUnit(String goodsUnit) {
            this.goodsUnit = goodsUnit;
            return this;
        }

        public GoodInfoVo setGoodsQuantity(Double goodsQuantity) {
            this.goodsQuantity = goodsQuantity;
            return this;
        }

        public GoodInfoVo setGoodsPrice(Integer goodsPrice) {
            this.goodsPrice = goodsPrice;
            return this;
        }

        public GoodInfoVo setGoodsTotalPrice(Integer goodsTotalPrice) {
            this.goodsTotalPrice = goodsTotalPrice;
            return this;
        }

        public GoodInfoVo setGoodsTaxRate(Double goodsTaxRate) {
            this.goodsTaxRate = goodsTaxRate;
            return this;
        }

        public GoodInfoVo setGoodsTotalTax(Integer goodsTotalTax) {
            this.goodsTotalTax = goodsTotalTax;
            return this;
        }

        public GoodInfoVo setGoodsTotalPriceTax(Integer goodsTotalPriceTax) {
            this.goodsTotalPriceTax = goodsTotalPriceTax;
            return this;
        }

        public GoodInfoVo setGoodsCode(String goodsCode) {
            this.goodsCode = goodsCode;
            return this;
        }

        public GoodInfoVo setGoodsLineNo(Integer goodsLineNo) {
            this.goodsLineNo = goodsLineNo;
            return this;
        }
    }

    public static class DetailInfo {
        private String callBackUrl;
        private String serialNumber;
        private Integer invoiceTotalTax;
        private Integer invoiceTotalPriceTax;
        private Integer invoiceTotalPrice;
        private List<GoodInfoVo> goodInfos;
        private String invoiceSettingCode;
        private String extInfo1;
        private String extInfo2;
        private String extInfo3;

        public DetailInfo setCallBackUrl(String callBackUrl) {
            this.callBackUrl = callBackUrl;
            return this;
        }

        public DetailInfo setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public DetailInfo setInvoiceTotalTax(Integer invoiceTotalTax) {
            this.invoiceTotalTax = invoiceTotalTax;
            return this;
        }

        public DetailInfo setInvoiceTotalPriceTax(Integer invoiceTotalPriceTax) {
            this.invoiceTotalPriceTax = invoiceTotalPriceTax;
            return this;
        }

        public DetailInfo setInvoiceTotalPrice(Integer invoiceTotalPrice) {
            this.invoiceTotalPrice = invoiceTotalPrice;
            return this;
        }

        public DetailInfo setGoodInfos(List<GoodInfoVo> goodInfos) {
            this.goodInfos = goodInfos;
            return this;
        }

        public DetailInfo setInvoiceSettingCode(String invoiceSettingCode) {
            this.invoiceSettingCode = invoiceSettingCode;
            return this;
        }

        public DetailInfo setExtInfo1(String extInfo1) {
            this.extInfo1 = extInfo1;
            return this;
        }

        public DetailInfo setExtInfo2(String extInfo2) {
            this.extInfo2 = extInfo2;
            return this;
        }

        public DetailInfo setExtInfo3(String extInfo3) {
            this.extInfo3 = extInfo3;
            return this;
        }

        public String getCallBackUrl() {
            return this.callBackUrl;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public Integer getInvoiceTotalTax() {
            return this.invoiceTotalTax;
        }

        public Integer getInvoiceTotalPriceTax() {
            return this.invoiceTotalPriceTax;
        }

        public Integer getInvoiceTotalPrice() {
            return this.invoiceTotalPrice;
        }

        public List<GoodInfoVo> getGoodInfos() {
            return this.goodInfos;
        }

        public String getInvoiceSettingCode() {
            return this.invoiceSettingCode;
        }

        public String getExtInfo1() {
            return this.extInfo1;
        }

        public String getExtInfo2() {
            return this.extInfo2;
        }

        public String getExtInfo3() {
            return this.extInfo3;
        }
    }
}

