/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.core.request;

import java.util.Map;
import java.util.Objects;
import okhttp3.Request;

public class OriginalResponse {
    private final Map headers;
    private final Request request;
    private final String contentType;
    private final int statusCode;
    private final String body;

    private OriginalResponse(Request request, int statusCode, Map headers, String contentType, String body) {
        this.request = request;
        this.contentType = contentType;
        this.headers = headers;
        this.statusCode = statusCode;
        this.body = body;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static class Builder {
        private Request request;
        private int statusCode;
        private Map headers;
        private String contentType;
        private String jsonBody;

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder body(String jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public OriginalResponse build() {
            Objects.requireNonNull(this.request);
            return new OriginalResponse(this.request, this.statusCode, this.headers, this.contentType, this.jsonBody);
        }
    }
}

