/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.core.config;

import cn.hutool.core.util.ObjectUtil;
import com.hfbcjt.open.sdk.core.config.OpConfig;

public class OpRSAConfig
implements OpConfig {
    public static final String DEFAULT_REST_HOST = "https://os.hfcsbc.com";
    private String restHost;
    private String appKey;
    private String privateKey;
    private String opPublicKey;
    private Boolean allowUpload;

    @Override
    public String getAppKey() {
        return this.appKey;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getOPPublicKey() {
        return this.opPublicKey;
    }

    @Override
    public String getRestHost() {
        return ObjectUtil.isEmpty((Object)this.restHost) ? DEFAULT_REST_HOST : this.restHost;
    }

    public static OpRSAConfigBuilder builder() {
        return new OpRSAConfigBuilder();
    }

    public OpRSAConfig(String restHost, String appKey, String privateKey, String opPublicKey, Boolean allowUpload) {
        this.restHost = restHost;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.opPublicKey = opPublicKey;
        this.allowUpload = allowUpload;
    }

    public OpRSAConfig() {
    }

    public String toString() {
        return "OpRSAConfig(restHost=" + this.getRestHost() + ", appKey=" + this.getAppKey() + ", privateKey=" + this.getPrivateKey() + ", opPublicKey=" + this.getOPPublicKey() + ", allowUpload=" + this.allowUpload + ")";
    }

    public static class OpRSAConfigBuilder {
        private String restHost;
        private String appKey;
        private String privateKey;
        private String opPublicKey;
        private Boolean allowUpload;

        OpRSAConfigBuilder() {
        }

        public OpRSAConfigBuilder restHost(String restHost) {
            this.restHost = restHost;
            return this;
        }

        public OpRSAConfigBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public OpRSAConfigBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public OpRSAConfigBuilder opPublicKey(String opPublicKey) {
            this.opPublicKey = opPublicKey;
            return this;
        }

        public OpRSAConfigBuilder allowUpload(Boolean allowUpload) {
            this.allowUpload = allowUpload;
            return this;
        }

        public OpRSAConfig build() {
            return new OpRSAConfig(this.restHost, this.appKey, this.privateKey, this.opPublicKey, this.allowUpload);
        }

        public String toString() {
            return "OpRSAConfig.OpRSAConfigBuilder(restHost=" + this.restHost + ", appKey=" + this.appKey + ", privateKey=" + this.privateKey + ", opPublicKey=" + this.opPublicKey + ", allowUpload=" + this.allowUpload + ")";
        }
    }
}

