/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.core;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.hfbcjt.open.sdk.core.HttpRequestFactory;
import com.hfbcjt.open.sdk.core.Results;
import com.hfbcjt.open.sdk.core.config.OpConfig;
import com.hfbcjt.open.sdk.core.constant.Header;
import com.hfbcjt.open.sdk.core.constant.TyhErrorCode;
import com.hfbcjt.open.sdk.core.constant.TyhException;
import com.hfbcjt.open.sdk.core.request.OpRequest;
import com.hfbcjt.open.sdk.core.request.OriginalResponse;
import com.hfbcjt.open.sdk.core.util.RSASignUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnection {
    private static final Logger logger = LoggerFactory.getLogger(RestConnection.class);
    private final OpConfig opConfig;

    public RestConnection(OpConfig opConfig) {
        this.opConfig = opConfig;
    }

    public <T> Results<T> executePostWithSignature(String path, OpRequest opRequest, Class<T> tClass) {
        String requestUrl = this.opConfig.getRestHost() + path;
        String token = RSASignUtil.getRequestToken(opRequest.getAccessId(), opRequest.getData(), this.opConfig.getPrivateKey());
        logger.info("[\u7b7e\u540d\u4fe1\u606f]\uff1a" + token);
        Request request = new Request.Builder().url(requestUrl).post(RequestBody.create((String)opRequest.getData(), (MediaType)Header.JSON_TYPE)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", token).build();
        OriginalResponse originalResponse = HttpRequestFactory.execute(request);
        this.verifyResponse(originalResponse);
        Results<T> results = this.checkAndGetResponse(originalResponse.getBody(), tClass);
        logger.info("[\u8bf7\u6c42\u5730\u5740]\uff1a" + requestUrl);
        logger.info("[\u54cd\u5e94\u53c2\u6570]" + JSON.toJSONString((Object)originalResponse.getBody()));
        return results;
    }

    private void verifyResponse(OriginalResponse originalResponse) {
        if (RestConnection.isInvalidHttpCode(originalResponse.getStatusCode())) {
            throw new TyhException(TyhErrorCode.REQUEST_NETWORKS_ERROR.getCode(), String.format("Wrong HttpStatusCode[%d]%nhttpResponseBody[%.1024s]\tHttpRequest[%s]", originalResponse.getStatusCode(), originalResponse.getRequest(), originalResponse.getBody()));
        }
        if (originalResponse.getBody() != null && !ObjectUtil.isEmpty((Object)originalResponse.getBody()) && !originalResponse.getContentType().contains("application/json")) {
            throw new TyhException(TyhErrorCode.INTERNAL_SERVER.getCode(), String.format("Unsupported content-type[%s]%nhttpRequest[%s]", originalResponse.getContentType(), originalResponse.getRequest()));
        }
        String opResponseSign = MapUtil.getStr((Map)originalResponse.getHeaders(), (Object)"OP-Signature");
        if (StrUtil.isNotEmpty((CharSequence)opResponseSign) && this.isInvalidResponseSign(opResponseSign, originalResponse.getBody())) {
            throw new TyhException(TyhErrorCode.INTERNAL_SERVER.getCode(), String.format("Validate response failed,the Open Platform signature is incorrect.%nresponseHeader[%s]\tresponseBody[%.1024s]", originalResponse.getHeaders(), originalResponse.getBody()));
        }
    }

    private static boolean isInvalidHttpCode(int httpCode) {
        return httpCode < 200 || httpCode >= 300;
    }

    private boolean isInvalidResponseSign(String opResponseSign, String body) {
        Sign sign = new Sign(SignAlgorithm.SHA512withRSA, null, this.opConfig.getOPPublicKey());
        try {
            return !sign.verify(body.getBytes(StandardCharsets.UTF_8), Base64.decode((byte[])opResponseSign.getBytes()));
        }
        catch (Exception e) {
            return true;
        }
    }

    private <T> Results<T> checkAndGetResponse(String resp, Class<T> tClass) {
        JSONObject json = JSON.parseObject((String)resp);
        if (!json.containsKey("code") || !json.containsKey("data")) {
            return Results.failure();
        }
        return new Results<Object>(json.getInteger("code"), json.getString("msg"), json.getObject("data", tClass, new JSONReader.Feature[0]), json.get("error"));
    }
}

