/*
 * Decompiled with CFR 0.152.
 */
package com.hfbcjt.open.sdk.core;

import com.hfbcjt.open.sdk.core.constant.TyhErrorCode;
import com.hfbcjt.open.sdk.core.constant.TyhException;
import com.hfbcjt.open.sdk.core.request.OriginalResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestFactory.class);
    private static Boolean LATENCY_DEBUG_SWATCH = Boolean.FALSE;
    private static LinkedBlockingQueue<NetworkLatency> LATENCY_DEBUG_QUEUE = new LinkedBlockingQueue();
    private static ConnectionPool connectionPool = new ConnectionPool(20, 300L, TimeUnit.SECONDS);
    private static final OkHttpClient client = new OkHttpClient.Builder().followSslRedirects(false).followRedirects(false).connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).writeTimeout(5000L, TimeUnit.MILLISECONDS).connectionPool(connectionPool).addNetworkInterceptor(new Interceptor(){

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Long startNano = System.nanoTime();
            Response response = chain.proceed(request);
            Long endNano = System.nanoTime();
            if (LATENCY_DEBUG_SWATCH.booleanValue()) {
                LATENCY_DEBUG_QUEUE.add(new NetworkLatency(request.url().url().getPath(), startNano, endNano));
            }
            return response;
        }
    }).build();

    public static OriginalResponse execute(Request request) {
        OriginalResponse originalResponse;
        block8: {
            Response response = client.newCall(request).execute();
            try {
                originalResponse = HttpRequestFactory.assembleOriginalResponse(request, response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TyhException(TyhErrorCode.INTERNAL_SERVER.getCode(), "[Execute] Cannot get the response from server");
                }
            }
            response.close();
        }
        return originalResponse;
    }

    private static OriginalResponse assembleOriginalResponse(Request request, Response response) {
        Map<String, String> responseHeaders = HttpRequestFactory.assembleResponseHeader(response);
        try {
            return new OriginalResponse.Builder().request(request).headers(responseHeaders).statusCode(response.code()).contentType(response.body() == null || response.body().contentType() == null ? null : response.body().contentType().toString()).body(response.body().string()).build();
        }
        catch (IOException e) {
            throw new TyhException(TyhErrorCode.INTERNAL_SERVER.getCode(), String.format("Assemble OriginalResponse,get responseBody failed.%nHttpRequest[%s]", request));
        }
    }

    private static Map<String, String> assembleResponseHeader(Response okHttpResponse) {
        ConcurrentHashMap<String, String> responseHeaders = new ConcurrentHashMap<String, String>();
        int headerSize = okHttpResponse.headers().size();
        for (int i = 0; i < headerSize; ++i) {
            responseHeaders.put(okHttpResponse.headers().name(i), okHttpResponse.headers().value(i));
        }
        return responseHeaders;
    }

    public static LinkedBlockingQueue<NetworkLatency> getLatencyDebugQueue() {
        return LATENCY_DEBUG_QUEUE;
    }

    public static void clearLatencyDebugQueue() {
        LATENCY_DEBUG_QUEUE.clear();
    }

    public static class NetworkLatency {
        private String path;
        private Long startNanoTime;
        private Long endNanoTime;

        public static NetworkLatencyBuilder builder() {
            return new NetworkLatencyBuilder();
        }

        public String getPath() {
            return this.path;
        }

        public Long getStartNanoTime() {
            return this.startNanoTime;
        }

        public Long getEndNanoTime() {
            return this.endNanoTime;
        }

        public NetworkLatency setPath(String path) {
            this.path = path;
            return this;
        }

        public NetworkLatency setStartNanoTime(Long startNanoTime) {
            this.startNanoTime = startNanoTime;
            return this;
        }

        public NetworkLatency setEndNanoTime(Long endNanoTime) {
            this.endNanoTime = endNanoTime;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkLatency)) {
                return false;
            }
            NetworkLatency other = (NetworkLatency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$startNanoTime = this.getStartNanoTime();
            Long other$startNanoTime = other.getStartNanoTime();
            if (this$startNanoTime == null ? other$startNanoTime != null : !((Object)this$startNanoTime).equals(other$startNanoTime)) {
                return false;
            }
            Long this$endNanoTime = this.getEndNanoTime();
            Long other$endNanoTime = other.getEndNanoTime();
            if (this$endNanoTime == null ? other$endNanoTime != null : !((Object)this$endNanoTime).equals(other$endNanoTime)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NetworkLatency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $startNanoTime = this.getStartNanoTime();
            result = result * 59 + ($startNanoTime == null ? 43 : ((Object)$startNanoTime).hashCode());
            Long $endNanoTime = this.getEndNanoTime();
            result = result * 59 + ($endNanoTime == null ? 43 : ((Object)$endNanoTime).hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "HttpRequestFactory.NetworkLatency(path=" + this.getPath() + ", startNanoTime=" + this.getStartNanoTime() + ", endNanoTime=" + this.getEndNanoTime() + ")";
        }

        public NetworkLatency(String path, Long startNanoTime, Long endNanoTime) {
            this.path = path;
            this.startNanoTime = startNanoTime;
            this.endNanoTime = endNanoTime;
        }

        public NetworkLatency() {
        }

        public static class NetworkLatencyBuilder {
            private String path;
            private Long startNanoTime;
            private Long endNanoTime;

            NetworkLatencyBuilder() {
            }

            public NetworkLatencyBuilder path(String path) {
                this.path = path;
                return this;
            }

            public NetworkLatencyBuilder startNanoTime(Long startNanoTime) {
                this.startNanoTime = startNanoTime;
                return this;
            }

            public NetworkLatencyBuilder endNanoTime(Long endNanoTime) {
                this.endNanoTime = endNanoTime;
                return this;
            }

            public NetworkLatency build() {
                return new NetworkLatency(this.path, this.startNanoTime, this.endNanoTime);
            }

            public String toString() {
                return "HttpRequestFactory.NetworkLatency.NetworkLatencyBuilder(path=" + this.path + ", startNanoTime=" + this.startNanoTime + ", endNanoTime=" + this.endNanoTime + ")";
            }
        }
    }
}

