var basetree=$('#StfBusinessProcess_tree');
var basegrid=$('#StfBusinessProcess_datagrid');
var selectflow=$('#flow_combo');
$(function(){
	initTree();
	initGrid();
	bindEnterKey("#searchStfBusinessProcess",searchStfBusinessProcess);
});
function initTree(){
	basetree.tree({
		url : ctx + '/StfBusinessType/treeStfBusinessTypeWithRoot',
		onSelect : function(node) {
			reloadGrid();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

//展开
function expandAll(){
	basetree.tree('expandAll')
}

//收缩
function collapseAll(){
	var root = basetree.tree('getRoot');
	basetree.tree('collapseAll');
	basetree.tree('expand',root.target);
}

function flowsel(){
	reloadGrid();
}

function initGrid(){
	basegrid.datagrid({
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:false,
		toolbar:"#StfBusinessProcess_datagrid_tb",
	    url:ctx+'/StfBusinessProcess/findAll',
	    columns:[[{
	      			field:'resId',title:'明细',width:40,align:'center',
	      			formatter:function(value,row,index){
	      				//value表示字段的值,rowData行记录数据,index行索引
	      				return '<div onclick="openFormDetail('+value+')" class="icon-detail iconfont blue">&nbsp;</div>';
	      		}},
	      	    {field:'flowName',title:'显示名称',width:200,align:'left',halign:"center"},
	      	    {field:'applyOrgsName',title:'适用单位',width:200,align:'left',halign:"center"},
	      	  {field:'shareTypeText',title:'共享分配策略',width:100,align:'left',halign:"center"},
	      	    {field:'designName',title:'定义名称',width:80,align:'center'},
	      	    {field:'businesstypename',title:'业务目录',width:100,align:'center'}/*,
	      	    {field:'typename',title:'流程类型',width:50,align:'center'},
	      	    {field:'memo',title:'说明',width:200}*/
	      	    ]]
	});
}

function reloadGrid(search){
	var flowtype=selectflow.combobox('getValue');
		switch(flowtype){
		case "4":
			flowtype="flow";
			break;
		case "1":
			flowtype="subflow";
			break;
		case "2":
			flowtype="feiflow";
			break;
		case "":
			flowtype="";
			break;
		}
	var node=basetree.tree('getSelected');
	basegrid.datagrid('reload',{
		search:search,
		type:flowtype,
		businessTypeId:node.id,
		search:$("#searchStfBusinessProcess").val().trim()
	});
}

function searchStfBusinessProcess(search){
	reloadGrid(search);
}

//增加数据字典
function addStfBusinessProcess() {
	var node=basetree.tree('getSelected');
	if(node && node.children.length==0){
		openSaveDialog({
			title:"流程属性",
			maximized : true,
			contenturl:"/view/workflow/StfBusinessProcessform",
			submiturl:"/StfBusinessProcess/saveStfBusinessProcess",
			callback:reloadGrid,
			onload:function(){
				$("#memoiframe").height($("body").height()-140);
				$("#businessTypeId").combotree('setValue',node.id);
				if ("10000000"!=orgId_ && accountId_!=='0'){
					var url = ctx+'/dic/dicPart?typeCode=STF_SHARE_TYPE&includeValue=3';
				    setTimeout(function(){$('#shareType').combobox('reload', url);},500)
				}else{
					var url = ctx+'/dic/dic?typeCode=STF_SHARE_TYPE';
				    setTimeout(function(){$('#shareType').combobox('reload', url);},500)
				}
				$("#applyOrgs").combotree({
					multiple:true,
					limitToList:true,
					cascadeCheck:false,
					editable : true,
					url: ctx+ '/basorg/queryOrgTreeRealNew',
					width: $("#applyOrgsTD").width() * 0.9
				})
				$("#shareType").combobox({
					url: ctx+ '/dic/dic?typeCode=STF_SHARE_TYPE',
					multiple: false,
					limitToList: true,
					required: true,
					onChange: shareTypeChange
				})
			},
			onsubmit:function(){
				$("#memo").val(document.getElementById('memoiframe').contentWindow.UE.getEditor('container').getContent());
				return true;
			}
		});
	}else{
		alertWarn('请选择一个业务流程');
	}
	
	
}
function shareTypeChange(newValue, oldValue) {
	if (newValue == '1') {
		$('#applyOrgs').combotree({
			readonly: true,
			required: false,
			value: ''
		});
	} else if (newValue == '2') {
		$('#applyOrgs').combotree({
			readonly: false,
			required: true,
			multiple: true
		});
	} else if (newValue == '3') {
		if (accountId_ != 0) {
			$('#applyOrgs').combotree({
				readonly: true,
				required: false,
				value: orgId_
			})
		} else {
			$('#applyOrgs').combotree({
				multiple: false
			})
		}
	}
}
//修改数据字典
function editStfBusinessProcess() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.resId;
		$.ajax({
			type: 'post',
			dataType: 'json',
			url: ctx + "/StfBusinessProcess/findStfBusinessProcess?id=" + id,
			success: function (data) {
				openSaveDialog({
					title : "修改记录",
					maximized : true,
					contenturl : "/view/workflow/StfBusinessProcessform",
					submiturl : "/StfBusinessProcess/saveStfBusinessProcess?id="+id,
					onload : function(){
						$("#memoiframe").height($("body").height()-140);
						if ("10000000"!=orgId_){
							var url = ctx+'/dic/dicPart?typeCode=STF_SHARE_TYPE&includeValue=3';
							$('#shareType').combobox('reload', url);
						}else{
							var url = ctx+'/dic/dic?typeCode=STF_SHARE_TYPE';
							$('#shareType').combobox('reload', url);
						}
						$("#StfBusinessProcessForm").form('load', data);
						$("#applyOrgs").combotree({
							multiple:true,
							limitToList:true,
							cascadeCheck:false,
							value: data.applyOrgs,
							editable : true,
							url: ctx+ '/basorg/queryOrgTreeRealNew',
							width: $("#applyOrgsTD").width() * 0.9
						})
						$("#shareType").combobox({
							url: ctx+ '/dic/dic?typeCode=STF_SHARE_TYPE',
							multiple: false,
							limitToList: true,
							required: true,
							value: data.shareType,
							onChange: shareTypeChange
						})
						shareTypeChange($("#shareType").combobox("getValue"));
						var iframewindow = document.getElementById('memoiframe').contentWindow;
						var setmemo = setInterval(function(){
							if(iframewindow.ueStatus=="ready"){
								var container = iframewindow.UE.getEditor('container').setContent(data.memo);
								clearInterval(setmemo);
							}
						},100);
					},
					callback : reloadGrid,
					onsubmit:function(){
						$("#memo").val(document.getElementById('memoiframe').contentWindow.UE.getEditor('container').getContent());
						return true;
					}
				});
			}
		});

	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//查看表单明细
function openFormDetail(designName){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=StfBusinessProcess&isdetail=true&id="+designName
	});
}

//删除数据字典
function delStfBusinessProcess() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.resId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/StfBusinessProcess/delStfBusinessProcess",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据字典信息');
	}
}
function copyStfBusinessProcess(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id =row.resId;
		alertConfirmYes('您是否要拷贝当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/StfBusinessProcess/copyStfBusinessProcess",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请选择一条记录进行拷贝');
	}
}