var basegrid=$('#PubContactOrg_datagrid');
var basetree=$('#PubContactOrgType_tree');
var menutree=$('#contactOrgTree_menu');
var contactType;
//单位主键
var contactOrgId = '';

$(function(){
	initTree();
	initGrid();
});

/********************************************往来单位树-start*****************************/
//初始化左侧树
function initTree(){
	basetree.tree({
		height:getMixGridHeight(),
		url : ctx + '/PubContactOrgType/treePubContactOrgTypeWithRoot',
		onSelect : function(node) {
			searchPubContactOrg(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select',root.target);
			}
		}
	});
}


function expandNode(){
	basetree.tree('expandAll');
}

function resetPubContactOrgType(result){
	var selectnode = basetree.tree('getSelected');
//	result = jQuery.parseJSON(result);
	if (result.success) {
		// 获取选中的节点
		var resultnode = basetree.tree('find',
				result.o.contactOrgTypeId);
		if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
			basetree.tree('update', {
				target : selectnode.target,
				text : result.o.contactOrgTypeName

			});
		} else {
			basetree.tree('append', {
				parent : selectnode.target,
				data : [ {
					id : result.o.contactOrgTypeId,
					text : result.o.contactOrgTypeName
				} ]
			});
		}
		alertInfo(result.msg);
		var newnode = basetree.tree('find',
				result.o.contactOrgTypeId);
		basetree.tree('select', newnode.target);
	} else {
		alertError(result.msg);
	}

}

/********************************************往来单位树-end*****************************/
function initGrid(){
	basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		queryParams:{
			contactOrgTypeId:1,
		},
		height:$("body").height()*0.55-120,
		toolbar:"#PubContactOrg_datagrid_tb",
	    url:ctx+'/PubContactOrg/pagePubContactOrg',
	    columns:[[
         {
         field:'opt',title:'明细',width:40,align:'center',
         formatter:function(value,row,index){	//value表示字段的值,row行记录数据,index行索引
         return '<div onclick="openFormDetail('+row.contactOrgId+','+row.contactOrgTypeId+',\''+row.orgType+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
         }},
	    {field:'contactOrgId',title:'主键',hidden:true},
	    {field:'contactOrgTypeId',hidden:true},
	    {field:'contactOrgName',title:'单位名称/姓名',width:200,halign:'left',sortable:true},
	    {field:'contactOrgCode',title:'统一单位代码/身份证号',width:160,halign:'center',align:'center',sortable:true},
		//	另一张表的
	    {field:'areaFullName',title:'注册地',width:160,halign:'left',sortable:true},
	    //{field:'foundDate',title:'成立日期',width:100,align:'center',sortable:true},
	    {field:'contactName',title:'联系人',width:100,halign:'left',sortable:true},
	    {field:'contactTel',title:'联系电话',width:140,halign:'left',sortable:true},
	    //{field:'remark',title:'备注',width:180,halign:'center'},
	    {field:'contactTypeText',title:'状态',width:100,halign:'center',align:'center'},
	    // {field:'workflowStatusText',title:'审批状态',width:100,halign:'center',align:'center'}
	    ]],
	    onClickRow : function(index, row) {
			initAccountGrid(row.contactOrgId);
		},
	    onDblClickRow :  function(index, row){
      		//查看明细
  	    	openFormDetail(row.contactOrgId,row.contactOrgTypeId,row.orgType);
  	    }
	});
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象
	pager.pagination({
	    buttons:[{
	        iconCls:'icon-page_excel',
	        handler:function(){
	           exportExcel('PubContactOrg_datagrid',"往来单位信息");
	        }
	    }]
	});
}
function initAccountGrid(id){
	$('#PubContractManage_datagrid').datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		// height:$("body").height()*0.45-152,
		cls:'md',
		queryParams:{
			id:id,
		},
		toolbar:"#PubContractManage_datagrid_tb",
	    url:ctx+'/PubContactOrgAccount/selectPubContactOrgAccount',
	    columns:[[
         {
         field:'opt',title:'明细',width:40,align:'center',
         formatter:function(value,row,index){	//value表示字段的值,row行记录数据,index行索引
         return '<div onclick="openAccountFormDetail('+row.orgAccountId+')" class="icon-detail iconfont blue">&nbsp;</div>';
         }},
	    {field:'orgAccountId',title:'主键',hidden:true},
	    {field:'contactName',title:'单位名称',width:200,halign:'center',sortable:true},
	    {field:'orgOpenBank',title:'开户行',width:200,halign:'center',sortable:true},
	    {field:'orgBankAccount',title:'银行账号',width:120,halign:'center',sortable:true},
	    {field:'statusText',title:'状态',width:50,halign:'center',align:'center'},
	    // {field:'workflowStatusText',title:'审批状态',width:100,halign:'center',align:'center'},
	    {field:'memo',title:'备注',width:150,halign:'center'}
	    ]],
	    onDblClickRow :  function(index, row){
      		//查看明细
  	    	openAccountFormDetail(row.orgAccountId);
  	    }
	});
}

//查看表单明细
function openFormDetail(id,contactOrgTypeId,orgType){
	var contenturl;
	contenturl = "/GenForm/form?formcode=PubContactOrg_dw&isdetail=true&id="+id+"&pk="+ id;
	openDetailDialog({
		title : "查看单位信息",
		maximized : false,
		width:800,
		height:400,
		contenturl:contenturl
	});

}
//查看表单明细
function openAccountFormDetail(id){
	var contenturl;
	contenturl = "/GenForm/form?formcode=PubContactOrgAccount&isdetail=true&id="+id;
	openDetailDialog({
		title : "查看银行账号信息",
		maximized : false,
		width:800,
		height:400,
		contenturl:contenturl
	});

}
function reloadGridPubContactOrgAccount(){
	$('#PubContractManage_datagrid').datagrid('reload');
}


//单位和个人展示的datagrid不一样
function searchPubContactOrg(){
	var row = basetree.tree('getSelected');
	basegrid.datagrid('load',{
		search:$("#searchPubContactOrg").val(),
		contactOrgTypeId : row.attributes.id,
		contactType :contactType,
	});
}
//银行账号查询
function searchPubContactOrgAccount(node){
	 var row = basegrid.datagrid('getSelected');
	 if(row){
		 $('#PubContractManage_datagrid').datagrid('load',{
			 search:$("#searchContactManage").val(),
			 id:row.contactOrgId
		 });
	 }
}

//初始化单位类型
function initOrgType(node){
	var node = basetree.tree('getSelected');
	$('#orgType').combobox('setValue','1');
	if (node && node.attributes) {
		if (node.attributes.type == '2') {
			$('#orgType').combobox('setValue','2');
		}
	}
}

function setFormValue(){
	var row = basegrid.datagrid('getSelected');
	//数据请求
	$.ajax({
		type : 'post',
		dataType : 'json',
		url : ctx + "/PubContactOrg/findPubContactOrg?id=" + row.contactOrgId,
		success : function(data) {
			var submitform=$("#PubContactOrg_dw");
			initOrgAccountForm();
			submitform.form('load', data);
		}
	});
}

/******************************************往来单位信息********************************/
//单独保存表单
function saveContactOrg(callback){
	$("#PubContactOrg_dw").form('enableValidation');
	$("#PubContactOrg_dw").form('submit',{
		dataType : 'json',
		method : "POST",
		url : ctx + "/PubContactOrg/saveInitPubContactOrg",
		onSubmit : function() {
			if($(this).form('validate')){
				return true;
			}else{
				return false;
			}
		},
		success : function(result) {
			result=jQuery.parseJSON(result);
			if (result.success) {
				contactOrgId = 	result.o.contactOrgId;
				$('#contactOrgId').val(contactOrgId);
				(callback && typeof(callback) === "function") && callback();
			} else {
				alertError(result.msg);
			}
		}
	});
}

//增加银行账号信息
function addContactAccount() {
	        var row = basegrid.datagrid('getSelected');
	        if (row) {
	        	var id = row.contactOrgId;
	        	var contactOrgName = row.contactOrgName;
	        	openSaveDialog({
	        		title:"添加银行账号信息",
					width:800,
					height:400,
	        		contenturl:"/GenForm/form?formcode=PubContactOrgAccount&contactOrgId="+id+"&contactOrgName="+contactOrgName,
	        		submiturl:"/PubContactOrgAccount/savePubContactOrgAccount?formcode=PubContactOrgAccount",
					onload:function (){
						setCss($("#status"), "combobox", false, true, false, true, false);
						InItAccountData(id,contactOrgName);

					},
	        		callback:reloadGridPubContactOrgAccount
	        	});
	        reloadGridPubContactOrgAccount();
		}else{
			alertWarn("请选择一条供应商单位");
		}
}

function changeOrgDefaultLoaded(id,isDefaultLoaded){
	$.ajax({
		url : ctx+ "/PubContactOrgAccount/changeOrgDefaultLoaded",
			data : {
				id : id,
				isDefaultLoaded : isDefaultLoaded
			},
		dataType : 'json'
	});
}

//修改银行账号信息
function editContactAccount() {
	var row = $('#PubContractManage_datagrid').datagrid('getSelected');
	if (row) {
		if(0==row.status){
			alertWarn('该数据已经注销，请重新选择');
			return;
		}
		// if (1==row.status){
		// 	alertWarn('该数据已经启用无法修改信息，请重新选择');
		// 	return;
		// }
		if(row.hasUse>0){
			alertWarn('该账号信息已在系统中使用，不可修改');
			return;
		}
		if(row.createAccount==accountId_||accountId_=='0'){
			//账号创建人或超级管理员
		}else{
			alertWarn('只有账号创建人可以修改未使用账号');
			return ;
		}
		orgAccountId = row.orgAccountId;
		openSaveDialog({
			title : "修改银行账号信息",
			width:800,
			height:400,
			contenturl:"/GenForm/form?formcode=PubContactOrgAccount&id="+orgAccountId,
			submiturl : "/PubContactOrgAccount/savePubContactOrgAccount",
			loadScript:"onTypechange();",
			callback :reloadGridPubContactOrgAccount
		});
	} else {
		alertWarn('请选择一条银行账号信息');
	}
}

// 删除往来单位信息
function delContactAccount() {
	var row = $('#PubContractManage_datagrid').datagrid('getSelected');
	if (row) {
		if(row.status == '0'){
			alertWarn('该账号信息已注销！');
			return;
		}
		// if (row.status == '1'){
		// 	alertWarn('该单位信息已启用！');
		// 	return;
		// }
		if(row.hasUse>0){
			alertWarn('该账号信息已在系统中使用，不可删除');
			return;
		}
		if(row.createAccount==accountId_||accountId_=='0'){
			//账号创建人或超级管理员
		}else{
			alertWarn('只有账号创建人可以删除未使用账号');
			return ;
		}
		var id = row.orgAccountId;
		alertConfirm('将删除该账号,确定?', function(r) {
			if (r) {
				$.ajax({
					url : ctx+ "/PubContactOrgAccount/delPubContactOrgAccount",
						data : {
							id : id
						},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							$('#PubContractManage_datagrid').datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
		reloadGridPubContactOrgAccount();
	} else {
		alertWarn('请先选择要删除的银行账号信息');
	}
}

//设为默认账号
function setContactAccount() {
	var rowP = basegrid.datagrid('getSelected');//选中的供应商
	row = $('#PubContractManage_datagrid').datagrid('getSelected');//银行账号
	if (row) {
		if('Y'==row.isDefaultAccount){
			alertWarn('数据已经是默认账号');
			return;
		}
		if(0==row.status){
			alertWarn('该数据已经注销，请重新选择');
			return;
		}
		var contactOrgId = rowP.contactOrgId;
		var id = row.orgAccountId;
		alertConfirmYes('将设置该银行账号为默认账号,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/PubContactOrgAccount/setContactAccount",
					async: false,
						data : {
							id : id,
							contactOrgId : contactOrgId
						},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							$('#PubContractManage_datagrid').datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
		reloadGridPubContactOrgAccount();
	} else {
		alertWarn('请选择一条设置的银行账号信息');
	}
}

// 启用银行账号信息
function startContactAccount() {
	var row = $('#PubContractManage_datagrid').datagrid('getSelected');//银行账号
	if (row) {
		if(0==row.status){
			alertWarn('数据已经注销,无法启用！');
			return;
		}
		if(1==row.status){
			alertWarn('该账号已启用！');
			return;
		}
		var id = row.orgAccountId;
		alertConfirmYes('将设置该银行账号启用,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/PubContactOrgAccount/startContactAccount",
					async: false,
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							$('#PubContractManage_datagrid').datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
		reloadGridPubContactOrgAccount();
	} else {
		alertWarn('请先选择要启用的银行账号信息');
	}
}
//注销该银行账号信息
function stopContactAccount() {
	var row = $('#PubContractManage_datagrid').datagrid('getSelected');//银行账号
	if (row) {
		if(0==row.status){
			alertWarn('数据已经注销');
			return;
		}
		var id = row.orgAccountId;
		alertConfirmYes('将设置该银行账号注销,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/PubContactOrgAccount/stopContactAccount",
					async: false,
						data : {
							id : id
						},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							$('#PubContractManage_datagrid').datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
		reloadGridPubContactOrgAccount();
	} else {
		alertWarn('请先选择要注销的银行账号信息');
	}
}
/**************************流程**************************************/
// function doFlow(){
// 	var row = $('#PubContractManage_datagrid').datagrid('getSelected');
// 	if (row) {
// 		if(row.workflowStatus=='3'){
// 			alertInfo('数据已通过');
// 			return;
// 		}
// 		openFlowDialog({
//     		processInstId:row.processinstid,
// 			businessMainId:row.orgAccountId,
// 			formCode:"PubContactOrgAccount",
// 			callback:reloadGridPubContactOrgAccount
//         });
// 	} else {
// 		alertInfo('请先选择一条数据信息');
// 	}
// }
//
// function viewFlow(){
// 	var row = $('#PubContractManage_datagrid').datagrid('getSelected');
// 	if (row) {
// 		viewFlowDialog(row.processinstid)
// 	} else {
// 		alertInfo('请先选择一条数据信息');
// 	}
// }

function editAdminContactAccount() {
	var row = $('#PubContractManage_datagrid').datagrid('getSelected');
	if (row) {
		orgAccountId = row.orgAccountId;
		openSaveDialog({
			title : "修改银行账号信息",
			width:800,
			height:400,
			contenturl:"/GenForm/form?formcode=PubContactOrgAccount&id="+orgAccountId,
			submiturl : "/PubContactOrgAccount/savePubContactOrgAccount",
			loadScript:"onTypechange();",
			callback :reloadGridPubContactOrgAccount
		});
	} else {
		alertWarn('请选择一条银行账号信息');
	}
}