var BasBusinessPidListDataGrid=$('#BasBusinessPidList_datagrid');
$(function(){
	initBasBusinessPidListGrid();
});

function initBasBusinessPidListGrid(){
	BasBusinessPidListDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			businessId:businessId
		},
		toolbar:"#BasBusinessPidList_datagrid_tb",
	    url:ctx+'/BasBusinessProcess/pageBasBusinessProcess',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasBusinessPidListFormDetail(\''+row.businessName+'\',\''+row.pageAddress+'\''+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'businessCode',title:'编码',width:100,align:'center',halign:'center',sortable:true},
	    {field:'businessName',title:'名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'businessTypeText',title:'类别',width:100,align:'center',halign:'center',sortable:true},
	    {field:'authInfoText',title:'页面信息',width:100,align:'center',halign:'center',sortable:true},
	    {field:'menuName',title:'菜单信息',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasBusinessPidListFormDetail(row.businessName,row.pageAddress);
	    }
	});
    BasBusinessPidListDataGrid.datagrid('doCellTip');
    var pager = BasBusinessPidListDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasBusinessPidList_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasBusinessPidListFormDetail(businessName,pageAddress){
	if (parent && parent.openInMainTab) {
		parent.openInMainTab(businessName,pageAddress);
	} else {
		window.open("${ctx}"+url); 
	}
}
//重新加载表格
function reloadBasBusinessPidList(){
	BasBusinessPidListDataGrid.datagrid('reload');
}
//查询表格
function searchBasBusinessPidList(){
	BasBusinessPidListDataGrid.datagrid('load',{
	    code:code,
		search:$("#searchBasBusinessPidList").val()
	});
}