var GenPanleItemTypeDataGrid=$('#GenPanleItemType_datagrid');
$(function(){
	initGenPanleItemTypeGrid();
});

function initGenPanleItemTypeGrid(){
	GenPanleItemTypeDataGrid.datagrid({
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		toolbar:"#GenPanleItemType_datagrid_tb",
	    url:ctx+'/GenPanleItemType/pageGenPanleItemType',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="GenPanleItemTypeFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
//	    {field:'id',title:'主键',width:100,align:'center',halign:'center',sortable:true},
	    {field:'itemGroupText',title:'控件类型',width:120,align:'center',halign:'center',sortable:true},
	    {field:'itemCode',title:'表单项编码',width:120,align:'center',halign:'center',sortable:true},
	    {field:'itemName',title:'表单项名称',width:120,align:'center',halign:'center',sortable:true},
	    {field:'itemGroup',hidden:true},
	    {field:'ftlName',title:'模板文件',width:120,align:'center',halign:'center',sortable:true},
//	    {field:'buttonClickFun',title:'弹出选择方法',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'nameUrl',title:'名称url-例如项目弹窗 字段存储的是id需要把id显示成name  url接收id参数 返回json 取里面的text为显示值',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'isSystem',title:'是否系统内置  为Y时则为内置的表单项，不能删除修改',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'pcOpts',title:'web端配置',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'appSupported',title:'app端是否支持',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'componentName',title:'app端组件名称',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'appOpts',title:'app配置',width:100,align:'center',halign:'center',sortable:true},
	    {field:'remark',title:'说明',width:200,align:'center',halign:'center',sortable:true},
	    {field:'displayNo',title:'显示顺序',width:80,align:'center',halign:'center',sortable:true},
	    {field:'isEnable',hidden:true},
	    {field:'isEnableText',title:'是否启用',width:80,align:'center',halign:'center',sortable:true}/*,
	    {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center',sortable:true}*/
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			GenPanleItemTypeFormDetail(row.id);
	    }
	});
    GenPanleItemTypeDataGrid.datagrid('doCellTip');
    var pager = GenPanleItemTypeDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GenPanleItemType_datagrid',"表单项类型");   
	        }    
	    }]   
	});
    bindEnterKey("#searchGenPanleItemType",searchGenPanleItemType);
}
//查看表单明细
function GenPanleItemTypeFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GenPanleItemType&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGenPanleItemType(){
	GenPanleItemTypeDataGrid.datagrid('reload');
}
//查询表格
function searchGenPanleItemType(){
	GenPanleItemTypeDataGrid.datagrid('load',{
		search:$("#searchGenPanleItemType").val()/*,
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue'),
		applyPerson: $("#applyPerson").textbox('getValue'),
		applyDept :$("#applyDept").combobox('getValue')*/
	});
}

//增加记录
function addGenPanleItemType() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GenPanleItemType",
		submiturl:"/GenPanleItemType/saveGenPanleItemType?formcode=GenPanleItemType",
//		contenturl:"/view/gen/GenPanleItemType",
//		submiturl:"/GenPanleItemType/saveGenPanleItemType",
		callback:reloadGenPanleItemType
	});
	
}

//修改记录
function editGenPanleItemType() {
	var row = GenPanleItemTypeDataGrid.datagrid('getSelected');
	if (row) {
//		if(row.isSystem=='Y'){
//			alertWarn('系统内置控件不允许修改');
//			return;
//		}
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GenPanleItemType&id=" + id,
			submiturl:"/GenPanleItemType/saveGenPanleItemType?formcode=GenPanleItemType",
//			contenturl : "/view/gen/GenPanleItemType",
//			submiturl : "/GenPanleItemType/saveGenPanleItemType",
//			onload : "/GenPanleItemType/findGenPanleItemType?id=" + id,
			callback : reloadGenPanleItemType
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delGenPanleItemType() {
	var row = GenPanleItemTypeDataGrid.datagrid('getSelected');
	if (row) {
		if(row.isSystem=='Y'){
			alertWarn('系统内置控件不允许删除');
			return;
		}
		var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenPanleItemType/delGenPanleItemType",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							GenPanleItemTypeDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
