var baseForAgendagrid=$('#GenFormForAgenda_datagrid');
var PubMeetItemSetDataGrid=$('#PubMeetItemSet_datagrid');
$(function(){
	initForAgendaGrid();
	initPanelGrid();
});

function initForAgendaGrid(){
	baseForAgendagrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GenForm_datagrid_tb",
	    url:ctx+'/GenForm/pageGenForm',
	    columns:[[
	    {field:'ID',title:'ID',hidden:true},
	    {field:'FORM_CODE',title:'表单编码',width:150},
	    {field:'FORM_NAME',title:'表单名称',width:120},
		{field:'FORM_TYPE',hidden:true},
	    {field:'FLOW_NAME',title:'流程',width:130},
	    {field:'BUSI_TABLE',title:'表名',width:150}
	    ]],
	    onSelect:function(index,row){
	    	PubMeetItemSetDataGrid.datagrid('load',{
				formid:row.ID
			});
	    }
	});

}

function searchForAgendaGenForm(){
	baseForAgendagrid.datagrid('load',{
		search:$("#searchForAgendaGenForm").val()
	});
}

function initPanelGrid(){
	PubMeetItemSetDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		toolbar:"#GenFormPanel_datagrid_tb",
	    url:ctx+'/PubMeetItemSet/pageGenFormPanelByFormID',
	    columns:[[
	    	{field:'setId',title:'主键',hidden:true},
		    {field:'formId',title:'表单ID',hidden:true},
		    {field:'orgId',title:'所属单位',hidden:true},
		    {field:'meetItemIdsText',title:'会议事项',hidden:true},
		    {field:'orgIdText',title:'所属单位',width:120,align:'center',halign:'center'},
		    {field:'flowAct',title:'流程节点',width:100,align:'center',halign:'center'},
		    {field:'checkUrl',title:'校验URL',width:180,align:'center',halign:'center'},
		    {field:'isEnable',hidden:true}
	    ]],
	    onSelect:function(index,row){
	    }
	});

}
function reloadpanelForAgendaGrid(){
	PubMeetItemSetDataGrid.datagrid('reload');
}
//增加
function addPubMeetItemSet() {
	var row = baseForAgendagrid.datagrid('getSelected');
	if (row) {
		var formid=row.ID;
		openSaveDialog({
			title:"添加记录",
			height:350,
			width:400,
			contenturl:"/GenForm/form?formcode=PubMeetItemSet",
			submiturl:"/PubMeetItemSet/savePubMeetItemSet?formcode=PubMeetItemSet",
			callback:reloadpanelForAgendaGrid,
			onload:function(){
				$("#formId").val(formid);	
				flowActQuery(formid);
			}
		});
	}else {
		alertInfo('请选择一个表单');
	}
}

//查询可编辑节点
function flowActQuery(formid){
	$('#flowAct').combobox({
		url:ctx+"/GenForm/queryFlowActComb?formId="+formid,
	});
}


//修改数据字典
function editPubMeetItemSet() {
	var row = PubMeetItemSetDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.setId;
		var formid = row.formId;
		openSaveDialog({
			title : "修改记录",
			height:350,
			width:400,
			contenturl:"/GenForm/form?formcode=PubMeetItemSet&id=" + id,
			submiturl:"/PubMeetItemSet/savePubMeetItemSet?formcode=PubMeetItemSet",
			onload:function(){
				flowActQuery(formid);
			},
			callback : reloadpanelForAgendaGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delPubMeetItemSet() {
	var row = PubMeetItemSetDataGrid.datagrid('getSelected');
	if (row) {
		var id =row.setId;
			alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
				if (r) {
					$.ajax({
						url : ctx+"/PubMeetItemSet/delPubMeetItemSet",
						data : {
							id : id
						},
						dataType : 'json',
						success : function(result) {
							if (result.success) {
								PubMeetItemSetDataGrid.datagrid('reload');
								alertInfo(result.msg);
							}else{
								alertError(result.msg);
							}
						}
					});
				}
			});
		} else {
			alertInfo('请先选择要删除的数据信息');
		}
}