var basetree=$('#DocCatalog_tree');
var basegrid=$('#DocFileType_datagrid');
$(function(){
	initTree();
	initGrid();
	bindEnterKey('#searchDocFileType',searchDocFileType);
});
function initTree(){
	basetree.tree({
		url : ctx + '/DocCatalog/treeStanderDocCatalog?sysType=CONSTRUCTION',
		onSelect : function(node) {
			reloadGrid();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

function initGrid(){
	basegrid.datagrid({
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#DocFileType_datagrid_tb",
	    url:ctx+'/DocFileType/pageDocFileType',
	    columns:[[
	    {field:'FILE_TYPE_ID',title:'文件类型ID',hidden:true},
	    {field:'FILE_TYPE_NAME',title:'文件类型名称',width:200},
	    {field:'FILE_NATURE_TEXT_',title:'文件性质',width:80},
	    {field:'NULLABLE_TEXT_',title:'允许为空',width:40},
	    {field:'REMARK',title:'备注',width:100},
	    {field:'DISPLAY_NO',title:'显示顺序',width:40}
	    ]]
	});
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('DocFileType_datagrid',"标准文件管理");   
	        }    
	    }]   
	}); 
}

function reloadGrid(){
	var node=basetree.tree('getSelected');
	basegrid.datagrid('reload',{
		catalogid:node.id,
		search:$("#searchDocFileType").val()
	});
}

function searchDocFileType(){
	reloadGrid();
}

//增加数据字典
function addDocFileType() {
	var node=basetree.tree('getSelected');
	openSaveDialog({
		title:"添加记录",
		height:380,
		contenturl:"/view/doc/DocFileTypeform",
		submiturl:"/DocFileType/saveDocFileType",
		onload:function(){
			$('#catalogId').val(node.id);
			$('#fileNature').combobox('setValue','1');
			$('#nullable').combobox('setValue','Y');
		},
		callback:reloadGrid
	});
	
}

//修改数据字典
function editDocFileType() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.FILE_TYPE_ID;
		openSaveDialog({
			title : "修改记录",
			height:380,
			contenturl : "/view/doc/DocFileTypeform",
			submiturl : "/DocFileType/saveDocFileType",
			onload : "/DocFileType/findDocFileType?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除数据字典
function delDocFileType() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.FILE_TYPE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/DocFileType/delDocFileType",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据字典信息');
	}
}
