var loggrid=$('#DocFileLog_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	loggrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		queryParams:{
			versionId:versionId
		},
		fitColumns:true,
		pagination:true,
		toolbar:"#DocFileLog_datagrid_tb",
	    url:ctx+'/DocFileLog/pageDocFileLog',
	    columns:[[
	    {field:'id',title:'id',hidden:true,width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'操作人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'操作时间',width:100,align:'center',halign:'center'},
	    {field:'operationType',title:'操作类型',width:100,align:'center',halign:'center'},
	    {field:'ip',title:'IP地址',width:100,align:'center',halign:'center'},
	    {field:'versionId',title:'文件ID',hidden:true,width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			//openFormDetail(row.id);
	    }
	});
    loggrid.datagrid('doCellTip');
    var pager = loggrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('DocFileLog_datagrid',"日志记录");
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=DocFileLog&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	loggrid.datagrid('reload');
}
//查询表格
function searchDocFileLog(){
	loggrid.datagrid('load',{
		search:$("#searchDocFileLog").val(),
		versionId:versionId
	});
}

//增加记录
function addDocFileLog() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=DocFileLog",
		submiturl:"/DocFileLog/saveDocFileLog?formcode=DocFileLog",
//		contenturl:"/view/business/pm/DocFileLog",
//		submiturl:"/DocFileLog/saveDocFileLog",
		callback:reloadGrid
	});
	
}

//修改记录
function editDocFileLog() {
	var row = loggrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=DocFileLog&id=" + id,
			submiturl:"/DocFileLog/saveDocFileLog?formcode=DocFileLog",
//			contenturl : "/view/business/pm/DocFileLog",
//			submiturl : "/DocFileLog/saveDocFileLog",
//			onload : "/DocFileLog/findDocFileLog?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delDocFileLog() {
	var row = loggrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/DocFileLog/delDocFileLog",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							loggrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
