var basetree=$('#DocCatalog_tree');
var baseform=$('#DocCatalog_form');
$(function(){
	initTree();
});

function initTree(){
	basetree.tree({
		url : ctx + '/DocCatalog/treeStanderDocCatalogWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

function controlBtn(isable){
	if(isable){
		$('#delDocCatalog').linkbutton('enable'); //删除
		$('#saveDocCatalog').linkbutton('enable'); //保存
	}else{
		$('#delDocCatalog').linkbutton('disable');
		$('#saveDocCatalog').linkbutton('disable');
	}
}
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/DocCatalog/findDocCatalog?id="+node.id);
		controlBtn(true);
	}
}

function expandNode(){
	basetree.tree('expandAll');
}
function collapseNode(){
	var root = basetree.tree('getRoot');
	basetree.tree('collapseAll');
	basetree.tree('expand',root.target);
}

function resetDocCatalog(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addDocCatalog() {
	var node = basetree.tree('getSelected');
	// 清除当前界面信息
	baseform.form('clear');	
		$('#pcatalogId').combotree('setValue',node.id);
	$('#saveDocCatalog').linkbutton('enable');
}

//删除
function delDocCatalog() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertWarn('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点级下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/DocCatalog/delDocCatalogAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertWarn('请选择一个节点');
	}
}

function saveDocCatalog(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/DocCatalog/saveStanderDocCatalog",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#saveDocCatalog').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					 $("#pcatalogId").combotree("reload");
					// 获取选中的节点
					var resultnode = basetree.tree('find',result.o.catalogId);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						basetree.tree('update', {
									target : selectnode.target,
									text : result.o.catalogName
									
								});
					} else {
						
						basetree.tree('append', {
									parent : selectnode.target,
									data : [{
id:result.o.catalogId,
text:result.o.catalogName
											}]
								});
					}
					alertInfo(result.msg);
					var newnode = basetree.tree('find',result.o.catalogId);
					basetree.tree('select', newnode.target);
					$('#saveDocCatalog').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#saveDocCatalog').linkbutton('enable');
				}
			}
		});
	} else {
		alertWarn('请选择一个节点');
	}
}
