// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
Date.prototype.Format = function (fmt) { // author: meizz
    var o = {
        "M+": this.getMonth() + 1, // 月份
        "d+": this.getDate(), // 日
        "h+": this.getHours(), // 小时
        "m+": this.getMinutes(), // 分
        "s+": this.getSeconds(), // 秒
        "q+": Math.floor((this.getMonth() + 3) / 3), // 季度
        "S": this.getMilliseconds() // 毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
};
/**
 * 字符串日期转Date
 */
function StringToDate(DateStr) {
    var converted = Date.parse(DateStr);
    var myDate = new Date(converted);
    if (isNaN(myDate)) {
        // var delimCahar = DateStr.indexOf('/')!=-1?'/':'-';
        var arys = DateStr.split('-');
        myDate = new Date(arys[0], --arys[1], arys[2]);
    }
    return myDate;
}
Date.prototype.add = function(interval, value){
	var d = this;
	switch(interval) {
	    case 'milli':
	        d.setMilliseconds(this.getMilliseconds() + value);
	        break;
	    case 'second':
	        d.setSeconds(this.getSeconds() + value);
	        break;
	    case 'minute':
	        d.setMinutes(this.getMinutes() + value);
	        break;
	    case 'hour':
	        d.setHours(this.getHours() + value);
	        break;
	    case 'day':
	        d.setDate(this.getDate() + value);
	        break;
	    case 'month':
	        var day = this.getDate();
	        if (day > 28) {
	            day = Math.min(day, this.getFirstDateOfMonth().add('month', value).getLastDateOfMonth().getDate());
	        }
	        d.setDate(day);
	        d.setMonth(this.getMonth() + value);
	        break;
	    case 'year':
	        d.setFullYear(this.getFullYear() + value);
	        break;
	}
	return d;
};
/**
 * 获取date所在月份的第一天。
 * @returns {Date}
 */
Date.prototype.getFirstDateOfMonth = function(){
	return new Date(this.getFullYear(), this.getMonth(), 1);
};
/**
 * 获取date所在月份的最后一天
 * @returns {Date}
 */
Date.prototype.getLastDateOfMonth = function() {
    return new Date(this.getFullYear(), this.getMonth(), this.getDaysInMonth());
};

/**
 * 获取date所在月份的第一天。
 * @returns {Date}
 */
Date.prototype.getFirstDateOfWeek = function(){
	 var day = this.getDay() || 7;// 本周的第几天
	 var nowDay = this.getDate(); // 当前日
	 var nowMonth = this.getMonth(); // 当前月
     return new Date(this.getFullYear(), nowMonth, nowDay + 1 - day);
};
/**
 * 获取date所在月份的最后一天
 * @returns {Date}
 */
Date.prototype.getLastDateOfWeek = function() {
	 var day = this.getDay() || 7;// 本周的第几天
	 var nowDay = this.getDate(); // 当前日
	 var nowMonth = this.getMonth(); // 当前月
     return new Date(this.getFullYear(), nowMonth, nowDay + 7 - day);
};
/**
 * 获取date是月中的第几天
 * @returns
 */
Date.prototype.getDaysInMonth = function() {
	var new_year = this.getFullYear();  //取当前的年份   
	var new_month = this.getMonth() + 1;//取下一个月的第一天，方便计算（最后一天不固定）   
	 if(new_month == 12)      //如果当前大于12月，则年份转到下一年   
	 {   
	    return 31 ;
	 }
	 var new_date = new Date(new_year,new_month,1);        //取当年当月中的第一天   
	 return (new Date(new_date.getTime()-1000*60*60*24)).getDate();//获取当月最后一天日期
};

/**
* 获取当前月的第一天
* @returns {Date}
*/
function getCurrentMonthFirst(d){
	   var date = new Date(d);
	   date.setDate(1);
	   var month = parseInt(date.getMonth()+1);
	   var day = date.getDate();
	   if (month < 10) {
	       month = '0' + month
	   }
	   if (day < 10) {
	       day = '0' + day
	   }
	   return date.getFullYear() + '-' + month + '-' + day;
	}

	/**
	* 获取当前月的最后一天
	* @returns {Date}
	*/
	function getCurrentMonthLast(d){
	   var date=new Date(d);
	   var currentMonth=date.getMonth();
	   var nextMonth=++currentMonth;
	   var nextMonthFirstDay=new Date(date.getFullYear(),nextMonth,1);
	   var oneDay=1000*60*60*24;
	   var lastTime = new Date(nextMonthFirstDay-oneDay);
	   var month = parseInt(lastTime.getMonth()+1);
	   var day = lastTime.getDate();
	   if (month < 10) {
	       month = '0' + month
	   }
	   if (day < 10) {
	       day = '0' + day
	   }
	   return date.getFullYear() + '-' + month + '-' + day;
	}
	function getAgeByDate(birthYearMonthDay) {
		//birthYearMonthDay必须为"1995/6/15"这种字符串格式，不可为"2020-6-15"，这种格式在Safari中会报错
		const birthDate = new Date(birthYearMonthDay);
		const momentDate = new Date();
		momentDate.setHours(0, 0, 0, 0); //因为new Date()出来的时间是当前的时分秒。我们需要把时分秒重置为0。使后面时间比较更精确
		const thisYearBirthDate = new Date(
			momentDate.getFullYear(),
			birthDate.getMonth(),
			birthDate.getDate()
		);
		const aDate = thisYearBirthDate - birthDate;
		const bDate = momentDate - birthDate;
		let tempAge = momentDate.getFullYear() - birthDate.getFullYear();
		let age = null;
		if (bDate < aDate) {
			tempAge = tempAge - 1;
			age = tempAge < 0 ? 0 : tempAge;
		} else {
			age = tempAge;
		}
		return age;
	}
