// 提醒消息列表
var warningGrid = $('#accountWarning_datagrid');

$(function() {
	initGrid();
});

// 初始化grid
function initGrid() {
	warningGrid.datagrid({
		fit : true,
		border : false,
		singleSelect : true,
		rownumbers : true,
		fitColumns : true,
		pagination : true,
		toolbar : "#accountWarning_datagrid_tb",
		url : ctx + '/BasMessage/pageAccountWarningList',
		columns : [ [
				{
					field : 'opt',
					title : '明细',
					width : 13,
					formatter : function(value, row, index) {
						return '<div onclick="openWarningDetail(\''
								+ row.msgTitle + '\',\'' + row.msgUrl
								+ '\')" class="icon-detail iconfont blue">&nbsp;</div>';
					}
				}, {
					field : 'msgId',
					title : 'msgId',
					hidden : true
				}, {
					field : 'msgUrl',
					title : 'msgUrl',
					hidden : true
				}, {
					field : 'msgTitle',
					title : '标题',
					width : 200
				}, {
					field : 'sendtime',
					title : '发送时间',
					width : 100
				} ] ],
		onDblClickRow : function(index, row) {
			openWarningDetail(row.msgTitle, row.msgUrl);
		}
	});
}

// 查询提醒信息列表
function searchWarningList() {
	warningGrid.datagrid('load', {
		search : $("#searchWarningList").val()
	});
}

// 打开提醒消息详细页面
function openWarningDetail(title,  msgUrl) {
	parent.openInMainTab(title, msgUrl);
	getWarningList();
}

// 获取提醒消息列表
function getWarningList() {
	$.ajax({
		type : "POST",
		cache : false,
		dataType : "json",
		url : ctx + "/BasMessage/getAccountWarningList.action",
		data : {},
		success : function(result) {
			var resultObj = JSON.parse(result);
			var htmlArray = "";
			var count = 0;
			if (resultObj.length <= 5) {
				count = resultObj.length;
			} else {
				count = 5;
			}
			if (count == 0) {
				parent.$("#warningList").html("当前没有消息！");
				parent.$("#warningNum").css("display", "none");
			} else {
				for ( var i = 0; i < count; i++) {
					var msg = resultObj[i];
					htmlArray += "<tr>";
					htmlArray += "<td class=\"am-text-primary\"><a href=\"javascript:openWarningDetail('"
							+ msg.msgTitle
							+ "','"
							+ msg.msgUrl
							+ "');\" >"
							+ msg.msgTitle
							+ "</a></td>";
					htmlArray += "</tr>";
				}
				parent.$("#warningList").html(htmlArray);
				parent.$("#warningNum").css("display", "block");
				parent.$("#warningNum").html(resultObj.length);
			}
			searchWarningList();
		}
	});
}