var basegrid = $('#BasSignature_datagrid');
$(function () {
    initGrid();
    bindEnterKey("#searchBasSignature", searchBasSignature);
});

function initGrid() {
    basegrid.datagrid({
        // fit:true,
        height: getMixGridHeight(),
        border: false,
        singleSelect: true,
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        cls: 'md',
        toolbar: "#BasSignature_datagrid_tb",
        url: ctx + '/BasSignature/pageBasSignature',
        columns: [[
            {
                field: 'opt', title: '明细', width: 40, align: 'center',
                formatter: function (value, row, index) {	//value表示字段的值,rowData行记录数据,index行索引
                    return '<div onclick="openFormDetail(' + row.signatureId + ')" class="icon-detail iconfont blue">&nbsp;</div>';
                }
            },
            {field: 'isAllName', title: '是否全部授权', width: 80, align: 'center', halign: 'center'},
            {field: 'scopeName', title: '授权范围', width: 200, align: 'center', halign: 'center'},
            {
                field: 'status', title: '状态', width: 60, align: 'center', halign: 'center', formatter: function (value, row, index) {
                    if (value == "Y") {
                        return "生效";
                    } else if (value == "N") {
                        return "注销";
                    } else {
                        return "未生效";
                    }
                }
            },
            {field: 'remark', title: '说明', width: 100, align: 'center', halign: 'center'},
            {field: 'startDate', title: '启动日期', width: 100, align: 'center', halign: 'center'},
            {field: 'endDate', title: '停用日期', width: 100, align: 'center', halign: 'center'}
        ]],
        onDblClickRow: function (index, row) {
            //查看明细
            openFormDetail(row.signatureId);
        }
    });
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcel('BasSignature_datagrid', "title");
            }
        }]
    });
}

function updateBasSignature(status) {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        if (status == "Y" && status == row.status) {
            alertWarn("已生效的数据不要重复生效");
        } else if (status == "N" && status == row.status) {
            alertWarn("已注销的数据不要重复注销");
        }
        $.ajax({
            url: ctx + "/BasSignature/updateBasSignature",
            data: {
                id: row.signatureId,
                status: status
            },
            type: "post",
            dataType: "json",
            success: function (data) {
                if (data.success) {
                    reloadGrid();
                } else {
                    if (status == "Y") {
                        alertError("操作失败，已存在生效的授权人");
                    } else {
                        alertError("操作失败");
                    }

                }
            }
        })
    } else {
        alertWarn("请先选择一条数据");
    }
}

//查看表单明细
function openFormDetail(id) {
    openDetailDialog({
        title: "查看记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=BasSignature&isdetail=true&id=" + id,
        onload: function () {
            basSignatureOnload();
        }
    });
}

//重新加载表格
function reloadGrid() {
    basegrid.datagrid('reload');
}

//查询表格
function searchBasSignature() {
    basegrid.datagrid('load', {
        search: $("#searchBasSignature").val()
    });
}

//增加记录
function addBasSignature() {
    openSaveDialog({
        title: "添加记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=BasSignature",
        submiturl: "/BasSignature/saveBasSignature?formcode=BasSignature",
//		contenturl:"/view/base/BasSignature",
//		submiturl:"/BasSignature/saveBasSignature",
        callback: reloadGrid
    });

}

//修改记录
function editBasSignature() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        if (row.status && row.status === "Y") {
            alertWarn("已生效的数据不能再修改");
            return;
        }
        var id = row.signatureId;
        openSaveDialog({
            title: "修改记录",
            maximized: true,
            contenturl: "/GenForm/form?formcode=BasSignature&id=" + id,
            submiturl: "/BasSignature/saveBasSignature?formcode=BasSignature",
//			onload : "/BasSignature/findBasSignature?id=" + id,
            callback: reloadGrid,
            onload: function () {
                basSignatureOnload();
            }
        });
    } else {
        alertWarn('请选择一条记录进行修改');
    }
}

//删除记录
function delBasSignature() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        var id = row.signatureId;
        alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
            if (r) {
                $.ajax({
                    url: ctx + "/BasSignature/delBasSignature",
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function (result) {
                        if (result.success) {
                            basegrid.datagrid('reload');
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertWarn('请先选择要删除的数据信息');
    }
}
