var basegrid=$('#BasDicType_datagrid');
$(function(){
	initGrid();
	bindEnterKey("#searchBasDicType",searchBasDicType);
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasDicType_datagrid_tb",
	    url:ctx+'/BasDicType/pageBasDicType',
	    queryParams:{
	    	businessTypeId : businessTypeId
	    },
	    columns:[[
	    {field:'dicCode',title:'字典编码',width:120,align:'center',halign:'center',hidden:businessTypeId!=''},
	    {field:'dicName',title:'字典名称',width:100,align:'center',halign:'center'},
	    {field:'dicTypeText',title:'类型',width:50,align:'center',halign:'center',hidden:businessTypeId!=''},
	    {field:'userEditText',title:'允许用户编辑',width:50,align:'center',halign:'center',hidden:businessTypeId!=''},
	    {field:'businessType',title:'字典类别',width:50,align:'center',halign:'center',hidden:businessTypeId!=''},
        {field:'usenum',title:'引用次数',width:60}
	    ]],
	    onClickRow : function(index, row){
			loadDicPanel(row);
		},
	    onDblClickRow:function(index, row){
			editBasDicType();
	    },
		onLoadSuccess : function(data){
			if(data.total > 0){
				basegrid.datagrid('selectRow', 0);
				var row = data.rows[0];
				loadDicPanel(row);
			}
		}
	});
	function loadDicPanel(row){
		// var panel = $("#easyuiLayout").layout('panel', 'center');
		var panel = $("#dic_info").panel();
		var userEdit="Y";
		if(businessTypeId!=""){
			userEdit=row.userEdit;
		}
		panel.panel("refresh", ctx+"/view/base/basdic?userEdit="+userEdit+"&type="+row.dicType+"&dataAttr="+row.dataAttr);
	}
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasDicType_datagrid',"title");   
	        }    
	    }]   
	});
}
//重新加载表格
function reloadTypeGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasDicType(){
	basegrid.datagrid('load',{
		search:$("#searchBasDicType").val(),
		businessTypeId : businessTypeId
	});
}

//增加记录
function addBasDicType() {
	openSaveDialog({
		title:"添加记录",
//		maximized : true,
//		contenturl:"/GenForm/form?formcode=BasDicType_Form",
//		submiturl:"/BasDicType/saveBasDicType?formcode=BasDicType_Form",
		height:460,
		contenturl:"/view/base/BasDicTypeform",
		submiturl:"/BasDicType/saveBasDicType",
		callback:reloadTypeGrid,
		onload:function(){
			$("#flag").combobox("setValue",'Y');
			$("#userEdit").combobox("setValue",'N');
		}
	});
	
}

//修改记录
function editBasDicType() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			height:460,
//			maximized : true,
//			contenturl:"/GenForm/form?formcode=BasDicType_Form&id=" + id,
//			submiturl:"/BasDicType/saveBasDicType?formcode=BasDicType_Form",
			contenturl : "/view/base/BasDicTypeform",
			submiturl : "/BasDicType/saveBasDicType",
			onload : "/BasDicType/findBasDicType?id=" + id,
			callback : reloadTypeGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasDicType() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		if(row.dicType =='S'){
			alertWarn('系统字典，禁止删除！');
			return;
		}else if(row.usenum >0){
			alertWarn('字典被引用，禁止删除！');
			return;
		}
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasDicType/delBasDicType",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							loadDicPanel(row);
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}

function exportDic() {
	openChooseDialog({
		title: "选择字典",
		contenturl: "/view/base/BasDicTypeSelect",
		width: 750,
		height: 450,
		okhandler: function () {
			var rows = $('#chooseBasDicTypeSelectgrid').datagrid('getRows');
			if (rows.length > 0) {
				var ids = [];
				for (var i = 0; i < rows.length; i++) {
					ids.push(rows[i].id);
				}
				ids = ids.join(";");
				window.open(ctx + "/BasDicType/exportDicTypeXml?ids=" + ids)
			} else {
				alertWarn("请先选择要导出的字典信息");
			}
		}
	})
}

function importDicType() {
	openSaveDialog({
		title: "导入字典",
		submitbtn: "commonImport",
		contenturl: "/view/common/commonImport",
		onsubmit: function (params) {
			var fileText = $("#file").filebox("getText");
			var fileType = fileText.substring(fileText.lastIndexOf("."), fileText.length);
			if (fileType != ".json" && fileType != ".JSON") {
				alertWarn("请选择json格式的附件！");
				return false;
			}
			return true;
		},
		submiturl: "/BasDicType/importDicType",
		callback: function (result) {
			if (result.success) {
				alertInfo(result.msg);
			} else {
				alertWarn(result.msg);
			}
		}
	});
}
