package ${table.bizpack}.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import ${table.bizpack}.dao.${table.entityName}Dao;
import ${table.bizpack}.entity.${table.entityName};
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import org.apache.commons.lang3.StringUtils;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.base.common.util.MemCache;


/** 
 *  
 * @Description: ${table.description}
 * @author ${table.domainAccount}
 * @date ${table.date}
 *
 */
@Component
public class ${table.entityName}Service{
	
	@Autowired
	private BeetlSQLHelper bSqlHelper;
	
	@Autowired
	private ${table.entityName}Dao ${table.entityName?uncap_first}Dao;
	
	<#assign hasDic="0">
	<#list table.gridCols as po>
	<#if (po.fieldDic?exists)>
	<#assign hasDic="1">
	</#if>
	</#list> 
	/**
     * 查询
     * @return
     */
	public List<Map<String, Object>> pageAll(<#list table.queryConditions as po><#if po.queryCondition != "4">String ${po.fieldName}, <#else>String ${po.fieldName}Start, String ${po.fieldName}End, </#if></#list>String search,String mainId){
	
		Map<String, Object> params =  new HashMap<String, Object>();
		if(!StringUtil.isEmpty(search)){
			params.put("search", "%"+search.toUpperCase()+"%");
		}
		if(!StringUtil.isEmpty(mainId)){
			params.put("id", mainId);
		}
		<#list table.queryConditions as po>
		<#if (po.queryCondition == "1")>
		if( !StringUtil.isEmpty(${po.fieldName}) ){
			params.put("${po.fieldName}", "%"+${po.fieldName}+"%");
		}
		<#elseif (po.queryCondition == "2" || po.queryCondition == "3")>
		if( !StringUtil.isEmpty(${po.fieldName}) ){
			params.put("${po.fieldName}", ${po.fieldName});
		}
		<#else>
		if( !StringUtil.isEmpty(${po.fieldName}Start) ){
			params.put("${po.fieldName}Start", ${po.fieldName}Start);
		}
		
		if( !StringUtil.isEmpty(${po.fieldName}End) ){
			params.put("${po.fieldName}End", ${po.fieldName}End);
		}
		</#if>
		
		</#list>
		List<Map<String, Object>> list = bSqlHelper.getMapList("${table.bizpack?replace('com.guochuang.imp.','')}.${table.entityName}.pageAll", params);
		<#if hasDic == "1">
		for(Map<String, Object> map : list) {
			<#list table.gridCols as po>
			<#if (po.fieldDic?exists)>
			map.put("${po.fieldName}Text", MemCache.getDicText("${po.fieldDic}", StringUtil.null2String(map.get("${po.fieldName}"))));
			</#if>
			</#list> 
		}
		</#if>
		return list;
	}
	
	
	/**
     * 保存
     * @param entity
     */
    @Transactional
	public void save${table.entityName}(String data){
		List<${table.entityName}> list = JSON.parseArray(data, ${table.entityName}.class);
		for(${table.entityName} entiy : list) {
			if(entiy.get${table.pkHump?cap_first}() == null) {
				entiy.setCreateTime(new Date());
				entiy.setCreateAccount(SysUtils.getLoginAccountId());
			}else {
				entiy.setModifyTime(new Date());
				entiy.setModifyAccount(SysUtils.getLoginAccountId());
			}
			entiy.setIsUse("Y");
		}
		${table.entityName?uncap_first}Dao.saveAll(list);
	}
	
	
	/**
     * 查询单条数据
     * @param id
     * @return
     */
	public ${table.entityName} find${table.entityName}(Long id){
		${table.entityName} entity = ${table.entityName?uncap_first}Dao.findById(id).get();
		return entity;
	}
	
	
	/**
     * 删除
     * @param id
     */
	public void del${table.entityName}(Long id){
		${table.entityName} entity = ${table.entityName?uncap_first}Dao.findById(id).get();
		entity.setIsUse(SysContent.IS_USE_N);
		${table.entityName?uncap_first}Dao.save(entity);
	}
	
    public List<Map<String,Object>> findByForeignId(Long id){//根据主表ID查询数据
        //List<${table.entityName}> list=${table.entityName?uncap_first}Dao.findBy(id);
        Map<String,Object> params = new HashMap<String,Object>(2);
        params.put("id", id);
        return bSqlHelper.getMapList("${table.bizpack?replace('com.guochuang.imp.','')}.${table.entityName}.pageAll", params);
    }
	
	
	
}