package ${table.bizpack}.service;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import ${table.bizpack}.dao.${table.entityName}Dao;
import ${table.bizpack}.entity.${table.entityName};
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import org.apache.commons.lang3.StringUtils;


/** 
 *  
 * @Description: ${table.description}
 * @author ${table.domainAccount}
 * @date ${table.date}
 *
 */
@Component
public class ${table.entityName}Service{
	
	@Autowired
	private BeetlSQLHelper bSqlHelper;
	
	@Autowired
	private ${table.entityName}Dao ${table.entityName?uncap_first}Dao;
	
	<#assign hasDic="0">
	<#list table.gridCols as po>
	<#if (po.fieldDic?exists)>
	<#assign hasDic="1">
	</#if>
	</#list> 
	/**
     * 查询
     * @return
     */
	public PageObject pageAll(<#list table.queryConditions as po><#if po.queryCondition != "4">String ${po.fieldName}, <#else>String ${po.fieldName}Start, String ${po.fieldName}End, </#if></#list>String search,int page, int rows, String sort, String order){
	
		Map<String, Object> params = new HashMap<String, Object>();
		if(!StringUtil.isEmpty(search)){
			params.put("search", "%"+search.toUpperCase()+"%");
		}
		<#list table.queryConditions as po>
		<#if (po.queryCondition == "1")>
		if( !StringUtil.isEmpty(${po.fieldName}) ){
			params.put("${po.fieldName}", "%"+${po.fieldName}+"%");
		}
		<#elseif (po.queryCondition == "2" || po.queryCondition == "3")>
		if( !StringUtil.isEmpty(${po.fieldName}) ){
			params.put("${po.fieldName}", ${po.fieldName});
		}
		<#else>
		if( !StringUtil.isEmpty(${po.fieldName}Start) ){
			params.put("${po.fieldName}Start", ${po.fieldName}Start);
		}
		
		if( !StringUtil.isEmpty(${po.fieldName}End) ){
			params.put("${po.fieldName}End", ${po.fieldName}End);
		}
		</#if>
		
		</#list>
		if( !StringUtil.isEmpty(sort) ){
			params.put("sort", DBPropertyUtil.underscoreName(sort));
		}
		
		if( !StringUtil.isEmpty(order) ){
			params.put("order", order);
		}
		
		PageObject<Map<String, Object>> pageObject = bSqlHelper.serachPage("${table.bizpack?replace('com.guochuang.imp.','')}.${table.entityName}.pageAll", params, PageRequest.of(page, rows));
		<#if hasDic == "1">
		for(Map<String, Object> map : pageObject.getRows()) {
			<#list table.gridCols as po>
			<#if (po.fieldDic?exists)>
			map.put("${po.fieldName}Text", MemCache.getDicText("${po.fieldDic}", StringUtil.null2String(map.get("${po.fieldName}"))));
			</#if>
			</#list> 
		}
		</#if>
		return pageObject;
	}
	
	
	/**
     * 保存
     * @param entity
     */
    @Transactional
	public void save${table.entityName}(${table.entityName} entity){
		${table.entityName?uncap_first}Dao.save(entity);
	}
	
	
	/**
     * 查询单条数据
     * @param id
     * @return
     */
	public ${table.entityName} find${table.entityName}(Long id){
		${table.entityName} entity = ${table.entityName?uncap_first}Dao.findById(id).get();
		return entity;
	}
	
	
	/**
     * 删除
     * @param id
     */
	public void del${table.entityName}(Long id){
		${table.entityName} entity = ${table.entityName?uncap_first}Dao.findById(id).get();
		entity.setIsUse(SysContent.IS_USE_N);
		${table.entityName?uncap_first}Dao.save(entity);
	}
	
	
	
	
}