
var ${table.entityName?uncap_first}Grid = $("#${table.entityName?uncap_first}Grid");

$(function(){
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				search${table.entityName}();
			}
		}
	});
	init${table.entityName}Grid();
	<#if table.fuzzyQueryConditions?size gt 0  >
	bindEnterKey('#search${table.entityName}',search${table.entityName});
	</#if>
});


/**
 * 初始化
 */
function init${table.entityName}Grid(){
	${table.entityName?uncap_first}Grid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
            flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		cls:'md',
		toolbar:"#${table.entityName?uncap_first}GridTbar",
	    url:ctx+'/${table.entityName?uncap_first}/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="${table.entityName?uncap_first}FormDetail('+row.${table.pkHump}+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    <#list table.gridCols as po>
	    <#if (po.gridColHidden == 1)>
	    {field:'${po.fieldName}',hidden:true},
	    <#else>
	    <#if (po.fieldDic?exists)>
	    {field:'${po.fieldName}Text',title:'${po.fieldTitle?default(po.fieldName)}',width:100,align:'center',halign:'center'}<#if po_has_next >,</#if>
	    <#else>
	    {field:'${po.fieldName}',title:'${po.fieldTitle?default(po.fieldName)}',width:100,align:'center',halign:'center',sortable:true}<#if po_has_next >,</#if>
	    </#if>
	    </#if>
	    </#list>
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			${table.entityName?uncap_first}FormDetail(row.${table.pkHump});
	    }
	});
	
    ${table.entityName?uncap_first}Grid.datagrid('doCellTip');
    var pager = ${table.entityName?uncap_first}Grid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('${table.entityName?uncap_first}Grid',menuName)
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function ${table.entityName?uncap_first}FormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=${table.entityName}&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reload${table.entityName}(){
	${table.entityName?uncap_first}Grid.datagrid('reload');
}


/**
 * 查询
 */
function search${table.entityName}(){
	${table.entityName?uncap_first}Grid.datagrid('load',{
		flowDone : haseasyui('#flow_combo') ? $('#flow_combo').combobox('getValue'):"",
		<#if table.fuzzyQueryConditions?size gt 0  >
		search: $("#search${table.entityName}").textbox("getValue"),
		</#if>
		<#list table.queryConditions as po>
		<#if (po.queryCondition == "1")>
		${po.fieldName} : $("#${po.fieldName}Query").textbox("getValue")<#elseif (po.queryCondition == "2")>
		${po.fieldName} : $("#${po.fieldName}Query").combobox("getValue")<#elseif (po.queryCondition == "3")>
		${po.fieldName} : $("#${po.fieldName}Query").datebox("getValue")<#elseif (po.queryCondition == "4")>
		${po.fieldName}Start : $("#${po.fieldName}StartQuery").datebox("getValue"),
		${po.fieldName}End : $("#${po.fieldName}EndQuery").datebox("getValue")</#if><#if po_has_next >,</#if></#list>
	});
}


/**
 * 增加
 */
function add${table.entityName}() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=${table.entityName}",
		submiturl : "/${table.entityName?uncap_first}/save${table.entityName}?formcode=${table.entityName}",
		callback : reload${table.entityName}
	});
	
}


/**
 * 修改
 */
function edit${table.entityName}() {

	var row = ${table.entityName?uncap_first}Grid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}
	
	if(row.workflowStatus.toString().indexOf('1') == -1){
		alertWarn('数据已经上报过,不能修改');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=${table.entityName}&id=" + row.${table.pkHump},
		submiturl:"/${table.entityName?uncap_first}/save${table.entityName}?formcode=${table.entityName}",
		callback : reload${table.entityName}
	});
}


/**
 * 删除
 */
function del${table.entityName}() {

	var row = ${table.entityName?uncap_first}Grid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

    if(row.workflowStatus.toString().indexOf('1') == -1){
        alertWarn('数据已经上报过,不能删除');
        return;
    }
	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/${table.entityName?uncap_first}/del${table.entityName}",
				data : {
					id : row.${table.pkHump}
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						${table.entityName?uncap_first}Grid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}


/**
 * 发送
 */
function doFlow(){
	var row = ${table.entityName?uncap_first}Grid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus == '3'){
			alertWarn('数据已通过');
			return;
		}
		
		//起草中,直接调用修改方法
		if(row.workflowStatus == '1'){
			edit${table.entityName}();
			return ;
		}
		
		//有消息记录时,利用gotoDetail参数,调用待办审批页面
		openFlowDialog({
    		processInstId : row.processinstid,
			businessMainId : row.${table.pkHump},
			formCode : "${table.entityName}",
			callback : reload${table.entityName},
			gotoDetail : true
        });
        
	} else {
		alertWarn('请先选择一条数据信息');
	}
}


/**
 * 查看
 */
function viewFlow(){
	var row = ${table.entityName?uncap_first}Grid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}
