select
===
with tmp as
 (select TT.TYPE_ID,
         group_concat(concat(tt.user_type,':',tt.user_id) ORDER BY tt.type_id) user_id,
         group_concat((case
                   when tt.user_type = 'dept' then
                    getdeptname(tt.user_id)
                   when tt.user_type = 'org' then
                    getbaseabbr(tt.user_id)
                   when tt.user_type = 'user' then
                    getaccountname(tt.user_id)
                 end) ORDER BY tt.type_id) user_name
    from GM_INFO_TYPE_MANAGERS tt
   where tt.is_use = 'Y'
   @if(!isEmpty(type)){
    and ((tt.user_type = 'org' and tt.user_id = #org#) or
         (tt.user_type = 'dept' and tt.user_id = #dept#) or
         (tt.user_type = 'user' and tt.user_id = #accountid#))
   @}
   group by tt.type_id)
select @pageTag(){
				t.TYPE_ID,
		t.TYPE_NAME,
		t.IS_APPROVAL,
		GETDICNAME('IS_OR_NOT',t.IS_APPROVAL) IS_APPROVAL_TEXT,
		t.FLOW_CODE,
		t.REMIND_DAY,
		t.PRINT_SETUP,
		GETDICNAME('GM_PRINT_SETUP',t.PRINT_SETUP) PRINT_SETUP_TEXT,
		t.IS_READING_PEOPLE,
		GETDICNAME('IS_OR_NOT',t.IS_READING_PEOPLE) IS_READING_PEOPLE_TEXT,
		t.IS_RELEASE_PEOPLE,
		GETDICNAME('IS_OR_NOT',t.IS_RELEASE_PEOPLE) IS_RELEASE_PEOPLE_TEXT,
		t.TOP_NUMBER,
		t.INFO_TYPE,
		GETDICNAME('GM_INFO_TYPE',t.INFO_TYPE) INFO_TYPE_TEXT,
		GETBASEABBR(t.ORG_ID)ORG_ID_name,
		GETDICNAME('IS_OR_NOT',t.SYSTEM_PRESET) SYSTEM_PRESET_TEXT,
		t.SYSTEM_PRESET,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
       p.user_id,
       p.user_name,
       t.display_no,
       GETDICNAME('IS_OR_NOT',t.IS_PUSH) IS_PUSH_TEXT
	 @}
from GM_INFO_TYPE t, tmp p
 where t.is_use = 'Y' and t.type_id = p.type_id
  @if(isEmpty(orgId)){
 	  @if(isEmpty(isAdmin)){
          and ((t.INFO_TYPE='2' and t.ORG_ID=#org#) or t.INFO_TYPE='1') 
 	  @}
  @}
  @if(!isEmpty(orgIdVal)){
   	 and t.ORG_ID in (#join(orgIdVal)#)
    @}

@if(!isEmpty(search)){
and(
 upper(t.TYPE_NAME) like #search# ESCAPE '/'   or 
 upper(t.FLOW_CODE) like #search# ESCAPE '/'   or 
 upper(t.REMIND_DAY) like #search# ESCAPE '/'   or 
 upper(GETDICNAME('GM_PRINT_SETUP',t.PRINT_SETUP)) like #search# ESCAPE '/'   or 
 upper(t.TOP_NUMBER) like #search# ESCAPE '/'   or 
 upper(GETDICNAME('GM_INFO_TYPE',t.INFO_TYPE)) like #search# ESCAPE '/'   or 
 upper(GETBASEABBR(t.ORG_ID)) like #search# ESCAPE '/'   or 
 upper(t.SYSTEM_PRESET) like #search# ESCAPE '/' 
)@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
	 order by t.DISPLAY_NO 
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}

getInfoTypeCombo
===
with tmp as
(select TT.TYPE_ID,
group_concat(concat(tt.user_type,':',tt.user_id) ORDER BY tt.type_id) user_id,
group_concat((case
when tt.user_type = 'dept' then
getdeptname(tt.user_id)
when tt.user_type = 'org' then
getbaseabbr(tt.user_id)
when tt.user_type = 'user' then
getaccountname(tt.user_id)
end) ORDER BY tt.type_id) user_name
from GM_INFO_TYPE_MANAGERS tt
where tt.is_use = 'Y'
and ((tt.user_type = 'org' and tt.user_id = #org#) or
(tt.user_type = 'dept' and tt.user_id = #dept#) or
(tt.user_type = 'user' and tt.user_id = #accountid#))
group by tt.type_id)
select
t.TYPE_ID id,
t.TYPE_NAME text,
t.TYPE_ID value
from GM_INFO_TYPE t, tmp p
where t.is_use = 'Y' and t.type_id = p.type_id
@if(isEmpty(isAdmin)){
and ((t.INFO_TYPE='2' and t.ORG_ID=#org#) or t.INFO_TYPE='1')
@}
@if(!isEmpty(infomationType)){
and  t.INFORMATION_TYPE = #infomationType#
@}
order by t.DISPLAY_NO



infoTypeTree
===
SELECT 	t.TYPE_ID id, 
     	t.TYPE_NAME text 
 FROM 	GM_INFO_TYPE t
 where t.is_use = 'Y'
order by t.DISPLAY_NO 

getInfoTypeListForSearch
===
select t.TYPE_ID,
       t.TYPE_NAME,
       t.IS_APPROVAL,
       GETDICNAME('IS_OR_NOT', t.IS_APPROVAL) IS_APPROVAL_TEXT,
       t.FLOW_CODE,
       t.REMIND_DAY,
       t.PRINT_SETUP,
       GETDICNAME('GM_PRINT_SETUP', t.PRINT_SETUP) PRINT_SETUP_TEXT,
       t.IS_READING_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_READING_PEOPLE) IS_READING_PEOPLE_TEXT,
       t.IS_RELEASE_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_RELEASE_PEOPLE) IS_RELEASE_PEOPLE_TEXT,
       t.TOP_NUMBER,
       t.INFO_TYPE,
       GETDICNAME('GM_INFO_TYPE', t.INFO_TYPE) INFO_TYPE_TEXT,
       t.ORG_ID,
       GETBASEABBR(t.ORG_ID) ORG_ID_name,
       GETDICNAME('IS_OR_NOT', t.SYSTEM_PRESET) SYSTEM_PRESET_TEXT,
       t.SYSTEM_PRESET,
       t.CREATE_ACCOUNT,
       t.CREATE_TIME,
       t.MODIFY_ACCOUNT,
       t.MODIFY_TIME,
       t.IS_USE
 from GM_INFO_TYPE t
  where t.is_use = 'Y'
 @if(isEmpty(isAdmin)){
    and ((t.INFO_TYPE='2' and t.ORG_ID=#orgId#) or t.INFO_TYPE='1')
 @}
 order by t.DISPLAY_NO 

getInfoTypeList
===
with tmp as
 (select TT.TYPE_ID,
          group_concat(concat(tt.user_type , ':' , tt.user_id), ',' ORDER BY tt.type_id) user_id,
          group_concat((case
                   when tt.user_type = 'dept' then
                    getdeptname(tt.user_id)
                   when tt.user_type = 'org' then
                    getbaseabbr(tt.user_id)
                   when tt.user_type = 'user' then
                    getaccountname(tt.user_id)
                 end) ORDER BY tt.type_id) user_name
    from GM_INFO_TYPE_MANAGERS tt
   where tt.is_use = 'Y'
     and ((tt.user_type = 'org' and tt.user_id in (with recursive temp as( select a.* from view_bas_org_bizdept a where  a.id = #org# union all select a.* from view_bas_org_bizdept a,temp t where t.id=a.pid)SELECT id FROM temp t )) or
         (tt.user_type = 'dept' and tt.user_id in (with recursive temp as( select a.* from view_bas_org_bizdept a where  a.id = #dept# union all select a.* from view_bas_org_bizdept a,temp t where t.id=a.pid)SELECT id FROM temp t )) or
         (tt.user_type = 'user' and tt.user_id = #accountid#))
   group by tt.type_id)
   @if(!isEmpty(showUnread)&&'Y'==showUnread){
   	, unread as(
   			WITH tmp1 AS (
		SELECT TT.INFO_ID  FROM GM_INFO_PUBLISH_SCOPE tt where tt.user_type = 'org' AND tt.user_id =#org#  AND tt.is_use = 'Y' 
		union 
		SELECT TT.INFO_ID  FROM GM_INFO_PUBLISH_SCOPE tt where tt.user_type = 'dept' AND tt.user_id =#dept#  AND tt.is_use = 'Y'
		union 
		SELECT TT.INFO_ID  FROM GM_INFO_PUBLISH_SCOPE tt where tt.user_type = 'user' AND tt.user_id =#accountid#  AND tt.is_use = 'Y' 
		union 
		SELECT TT.INFO_ID  FROM GM_INFO_PUBLISH_SCOPE tt,(
		SELECT b.group_id  	FROM BAS_GROUP_ACCOUNT_RELATE b,BAS_GROUP g  WHERE b.user_type = 'org' AND b.user_id =#org# and b.is_use = 'Y' and g.group_id = b.group_id and g.status=1
		union 
		SELECT b.group_id  	FROM BAS_GROUP_ACCOUNT_RELATE b,BAS_GROUP g  WHERE b.user_type = 'dept' AND b.user_id =#dept# and b.is_use = 'Y' and g.group_id = b.group_id and g.status=1
		union 
		SELECT b.group_id  	FROM BAS_GROUP_ACCOUNT_RELATE b,BAS_GROUP g  WHERE b.user_type = 'user' AND b.user_id =#accountid# and b.is_use = 'Y' and g.group_id = b.group_id and g.status=1)b where tt.user_type = 'group'    AND tt.is_use = 'Y' AND b.group_id = tt.user_id   
		)
	 select t.type_id,count(*) unreadcou
	  from GM_INFO_CONTENT t ,tmp1 p
	 where 1=1 
	   and t.info_id = p.info_id 
	   and t.WORKFLOW_STATUS ='3'
	   and t.is_use = 'Y'
	   AND NOT EXISTS ( SELECT 1 FROM gm_info_read i WHERE t.INFO_ID = i.INFO_ID AND i.ACCOUNT_ID = #loginuser.accountid# and i.READ_DATE is not null) 
	   	group by t.type_id
	 )
	   
   @}
   
select t.TYPE_ID,
       t.TYPE_NAME,
       t.IS_APPROVAL,
       GETDICNAME('IS_OR_NOT', t.IS_APPROVAL) IS_APPROVAL_TEXT,
       t.FLOW_CODE,
       t.REMIND_DAY,
       t.PRINT_SETUP,
       GETDICNAME('GM_PRINT_SETUP', t.PRINT_SETUP) PRINT_SETUP_TEXT,
       t.IS_READING_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_READING_PEOPLE) IS_READING_PEOPLE_TEXT,
       t.IS_RELEASE_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_RELEASE_PEOPLE) IS_RELEASE_PEOPLE_TEXT,
       t.TOP_NUMBER,
       t.INFO_TYPE,
       GETDICNAME('GM_INFO_TYPE', t.INFO_TYPE) INFO_TYPE_TEXT,
       GETBASEABBR(t.ORG_ID) ORG_ID_name,
       GETDICNAME('IS_OR_NOT', t.SYSTEM_PRESET) SYSTEM_PRESET_TEXT,
       t.SYSTEM_PRESET,
       t.CREATE_ACCOUNT,
       t.CREATE_TIME,
       t.MODIFY_ACCOUNT,
       t.MODIFY_TIME,
       t.IS_USE,
       p.user_id,
       p.user_name,
       @if(!isEmpty(showUnread)&&'Y'==showUnread){
	     r.unreadcou,
	    @}
       CASE
			WHEN p.user_id = '' THEN
			'N' when p.user_id is null then 'N'  ELSE 'Y' 
		END is_add 
  from GM_INFO_TYPE t
    @if(!isEmpty(showUnread)&&'Y'==showUnread){
     left join unread r on t.type_id = r.type_id
    @}
  left join tmp p
    on t.type_id = p.type_id
 where t.is_use = 'Y' and p.user_id is not null
 @if(!isEmpty(typeId)){
    and t.type_id in (#join(typeId)#)
 @}
 @if(isEmpty(isAdmin)){
    and ((t.INFO_TYPE='2' and t.ORG_ID=#org#) or t.INFO_TYPE='1')
 @}
 order by t.DISPLAY_NO 