select
===
select @pageTag(){
		t.COMPONENT_ID,
		t.COMPONENT_NAME,
		t.COMPONENT_WIDTH,
		t.COMPONENT_HEIGHT,
		t.COMPONENT_SOURCE,
		GETDICNAME('COMPONENT_SOURCE',t.COMPONENT_SOURCE) COMPONENT_SOURCE_TEXT,
		t.COMPONENT_CATEGORY,
		GETDICNAME('COMPONENT_CATEGORY',t.COMPONENT_CATEGORY) COMPONENT_CATEGORY_TEXT,
		t.CREATION_TYPE,
		GETDICNAME('SYS_DATA_CREATION_TYPE',t.CREATION_TYPE) CREATION_TYPE_TEXT,
		t.ORG_ID,
		b.ORG_NAME,
		t.LINK_ADDRESS,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
		GETDICNAME('SHOW_STYLE',t.SHOW_STYLE) SHOW_STYLE_TEXT,
		GETDICNAME('SHOW_FORM',t.SHOW_FORM) SHOW_FORM_TEXT,
		GETDICNAME('IS_CONFIG',t.IS_CONFIG) IS_CONFIG_TEXT,
		t.open_type
	 @}
from BAS_SPACE_COMPONENT_DEFINITION t
left join BAS_ORG b on t.ORG_ID=b.ORG_ID
where t.is_use = 'Y'
@if(!isEmpty(search)){
and t.COMPONENT_NAME like #search#
@}
@if(!isEmpty(componentName)){
and t.COMPONENT_NAME like #componentName#
@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by ifnull(t.order_by,99999999)
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}



findAll
===
select t.*
from BAS_SPACE_COMPONENT_DEFINITION t
where t.is_use = 'Y'


spaceComponentTree
===
SELECT 	t.COMPONENT_ID id, 
     	t.COMPONENT_NAME text 
 FROM 	BAS_SPACE_COMPONENT_DEFINITION t
 where t.is_use = 'Y'

spaceComponentTreeFilter
===
SELECT 	t.COMPONENT_ID id, 
     	t.COMPONENT_NAME text 
 FROM 	BAS_SPACE_COMPONENT_DEFINITION t
 where t.is_use = 'Y'
 and 
 (
 t.COMPONENT_ID in (select COMPONENT_ID from BAS_SPACE_component_user where user_id = #userId# and is_use = 'Y')
 or
 (SELECT count(1) FROM BAS_SPACE_COMPONENT_ASSOCIATED where FIND_IN_SET(t.COMPONENT_ID,COMPONENT_ID) and COMPONENT_TYPE = '2' and SPACE_ID = 460 and is_use = 'Y') > 0
 )
 
getSpaceComponentByCategory
===
SELECT 	t.COMPONENT_ID value, 
     	t.COMPONENT_NAME text 
 FROM 	BAS_SPACE_COMPONENT_DEFINITION t
 where t.is_use = 'Y'
 and t.component_Category=#category#
ORDER BY t.COMPONENT_ID asc

getUseSpace
===
select group_concat(s.SPACE_NAME)
from BAS_SPACE_define s,BAS_SPACE_component_associated a
where s.IS_USE='Y'
AND A.IS_USE='Y'
AND concat(',',a.COMPONENT_ID,',') like concat('%,',#id#,',%')
and s.SPACE_ID = a.SPACE_ID

pageSpaceComponentTreeFilter
===
select @pageTag(){
a.* 
@}
from (select s.COMPONENT_ID,s.order_by,
       concat(s.COMPONENT_NAME,
              case
                when s.SHOW_FORM is not null then
                 concat('(', GETDICNAME('SHOW_FORM', s.SHOW_FORM), ')')
                else
                 ''
              end) COMPONENT_NAME
  from bas_space_component_user t, bas_space_component_definition s
 where t.PARTICIPANT_TYPE = 'person'
   and t.PARTICIPANT_ID = concat(#loginuser.accountid#, '')
   and s.COMPONENT_ID = t.COMPONENT_ID
   and t.is_use = 'Y'
   and s.is_use = 'Y'
   and s.IS_CONFIG = 'config'
union
select s.COMPONENT_ID,s.order_by,
       concat(s.COMPONENT_NAME,
              case
                when s.SHOW_FORM is not null then
                 concat('(', GETDICNAME('SHOW_FORM', s.SHOW_FORM), ')')
                else
                 ''
              end) COMPONENT_NAME
  from bas_space_component_user t,
       bas_space_component_definition s,
       (select case
                 when r.ROLE_TYPE = 'org' then
                  concat(a.ORG_ID, '>', a.ROLE_ID)
                 when r.ROLE_TYPE = 'dept' then
                  concat(a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID)
                 else
                  r.ROLE_ID
               end ROLE_ID
          from bas_roles_account a, bas_roles r
         where a.ACCOUNT_ID = #loginuser.accountid#
           and a.ROLE_ID = r.ROLE_ID) r
 where t.PARTICIPANT_TYPE = 'role'
   and r.role_id LIKE t.PARTICIPANT_ID
   and s.COMPONENT_ID = t.COMPONENT_ID
   and t.is_use = 'Y'
   and s.is_use = 'Y'
   and s.IS_CONFIG = 'config'
union
select s.COMPONENT_ID,s.order_by,
       concat(s.COMPONENT_NAME,
              case
                when s.SHOW_FORM is not null then
                 concat('(', GETDICNAME('SHOW_FORM', s.SHOW_FORM), ')')
                else
                 ''
              end) COMPONENT_NAME
  from bas_space_component_definition s
 where s.is_use = 'Y'
   and (s.IS_CONFIG = 'all' or s.IS_CONFIG is null))a
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by ifnull(a.order_by,99999999)
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}