accountOrgTree
===
with RECURSIVE temp as(
    SELECT
        concat( '', a.ORG_ID ) AS id,
        concat( '', a.PORG_ID ) AS pid,
        a.ABBR AS TEXT,
        a.ORG_CODE AS CODE,
        a.SORT AS display_no,
        2 AS type,
        a.ORG_ID AS pkid,
        a.STATUS AS STATUS ,
        a.org_name 
    FROM
        bas_org a 
    WHERE   a.IS_USE = 'Y'  
        @if(!isEmpty(curorgId)){
         and a.org_id = #curorgId#
        @}
        @if(!isEmpty(type)&&type=='2'){
            and ifnull(m.type,'0')='0'
        @}
        @if(!isEmpty(showCancel)&&showCancel=='Y'){
        @}else{
            and a.status <> '0'
        @}
          UNION ALL
    SELECT
        concat( 'dept', b.DEPT_ID ) AS id,
        concat( '',( CASE   WHEN ( b.PDEPT_ID = 0 ) THEN concat('',b.ORG_ID)ELSE concat( 'dept', b.PDEPT_ID )   END  )) AS pid,
            b.DEPT_NAME AS TEXT,
            b.DEPT_CODE AS CODE,
            b.DISPLAY_NO AS display_no,
            1 AS type,
            b.DEPT_ID AS pkid,
            b.STATUS AS STATUS ,
            b.dept_name 
        FROM bas_dept b LEFT JOIN bas_org o ON   o.ORG_ID = b.ORG_ID  
        WHERE b.IS_USE = 'Y'  
                AND EXISTS (
                SELECT 1  FROM bas_org o 
                WHERE  o.BELONG_DEPT = b.DEPT_ID  
                    AND  o.IS_USE = 'Y' ) IS FALSE 
                    @if(!isEmpty(curorgId)){
                     and b.org_id = #curorgId#
                    @}
              UNION ALL
        SELECT
            concat( 'emp', e.account_ID ) AS id,
            concat( 'dept', e.DEPT_ID ) AS pid,
            e.account_NAME AS TEXT,
            e.account_ID AS CODE,
            row_number () OVER ( ORDER BY IF (( t.DISPLAY_NO IS NULL ), 1, 0 ),t.DISPLAY_NO) AS DISPLAY_NO,
            3 AS type,
            e.EMP_ID AS pkid,
            t.STATUS AS STATUS ,
            concat(o.abbr,'-',b.abbr)
        FROM bas_emp_account e ,bas_emp t,bas_dept b,bas_org o
        WHERE e.is_use='Y' and e.emp_id = t.emp_id and t.status <>'03' and t.is_use='Y' and b.dept_id = e.dept_id and o.org_id = e.org_id
        @if(!isEmpty(curorgId)){
         and e.org_id = #curorgId#
        @}
),  account AS (
    @if(!isEmpty(accountIds)){
        SELECT b.* FROM temp b WHERE   b.id in (#join(accountIds)# )
    @}else if(!isEmpty(pid)){
        SELECT b.* FROM temp b WHERE   b.pid = #pid#
    @}else {
        SELECT b.* FROM temp b WHERE   b.id = #id#
    @}
    UNION ALL
    SELECT b.* FROM temp b,account t WHERE
    @if(!isEmpty(accountIds)&&particType=='org'){
        b.id = t.pid  
    @}else{
        b.pid = t.id  
    @}
)
select distinct * from account a order by a.type,a.display_no

accountGroupTree
===
with RECURSIVE temp as(
select 'type1' id,
  '0' pid,
    '公共组' text ,
    0 display_no
union all
select 'type2' id,
  '0' pid,
    '私有组' text ,
    1 display_no
union all
SELECT
    concat('',t.GROUP_ID) AS id,
    concat('type',t.GROUP_TYPE) pid ,
    t.GROUP_NAME AS text,
    t.ORDER_NUM display_no
FROM
    BAS_GROUP t 
WHERE
    t.is_use = 'Y' 
    AND (
        t.CREATE_ACCOUNT = #loginuser.accountid# 
        OR (
            t.GROUP_TYPE = '1' 
            AND (
                EXISTS (
                SELECT 1  FROM bas_group_scope s 
                WHERE   s.group_id = t.group_id 
                    AND s.is_use = 'Y' 
                    AND (
                        (
                            s.user_type = 'user' 
                        AND s.user_id =#loginuser.accountid#) 
                        OR (
                            s.user_type = 'dept' 
                        AND s.user_id =#loginuser.deptid#) 
                        OR (
                            s.user_type = 'org' 
                        AND s.user_id =#loginuser.orgid#) 
                    ) 
                ) 
                OR NOT EXISTS ( SELECT 1 FROM bas_group_scope s WHERE s.group_id = t.group_id AND s.is_use = 'Y' ) 
            ) 
        ) 
    ) 
union all
select CONCAT('emp',a.ACCOUNT_ID) id ,
concat('',r.GROUP_ID) pid,
concat(a.ACCOUNT_NAME,'(',o.abbr,'-',d.abbr,')') text ,
e.display_no 
from bas_group_account_relate r,bas_emp_account a ,BAS_EMP E,bas_org o ,bas_dept d
where (
( r.USER_TYPE='user' and r.USER_ID = a.ACCOUNT_ID) or 
( r.USER_TYPE='dept' and r.USER_ID = a.dept_ID) or
( r.USER_TYPE='org' and r.USER_ID = a.org_ID) 
) and r.IS_USE='Y' and a.IS_USE='Y'
AND A.EMP_ID = E.EMP_ID
AND E.IS_USE='Y' and e.`STATUS` in('01','02')
and o.org_id = a.org_id
and d.dept_id = a.dept_id
),  account AS (  
SELECT b.* FROM temp b WHERE   b.pid = '0'
    UNION ALL
    SELECT b.* FROM temp b,account t WHERE b.pid = t.id  
)
select
    case when t.rn=1 then t.id else concat(t.id,'-',t.rn) end id,
t.pid,t.text,t.display_no from (
    select t.*,rank()over(partition by t.id order by t.pid) as rn from account t
    @if(!isEmpty(accountIds)){
    WHERE   (t.id in (#join(accountIds)# ) or  t.id not like 'emp%' )
    @}
)t 
order by t.display_no