pageAll
===
SELECT
    t.SETTING_MSG_ID,
    t.WARNING_SETTING_ID,
    t.OP_TYPE,
    t2.DIC_TEXT AS OP_TYPE_NAME,
    t.OP_VALUE,
    CASE
        WHEN t1.MODEL_NAME IS NULL THEN
        t.OP_VALUE ELSE t1.MODEL_NAME 
    END AS OP_VALUE_NAME,
    t.ORDER_NUM,
    t.IS_USE 
FROM
    bas_early_warning_setting_msg t
    LEFT JOIN bas_dic t2 ON t2.DIC_CODE = 'OP_TYPE' 
    AND t2.DIC_VALUE = t.OP_TYPE
    LEFT JOIN bas_model_manage t1 ON t.OP_VALUE = t1.MODEL_ID 
WHERE
    t.IS_USE = 'Y' 
    AND t.WARNING_SETTING_ID = #mainId# 
ORDER BY
    t.ORDER_NUM

delBasEarlyWarningSettingMsgBySettingId
===
UPDATE bas_early_warning_setting_msg t 
SET t.IS_USE = 'N',
t.MODIFY_ACCOUNT = #modifyAccount#,
t.MODIFY_TIME = SYSDATE() 
WHERE
    t.WARNING_SETTING_ID = #mainId#
    
findEarlyWarningSettingMsgList
===
SELECT
    t.WARNING_SETTING_ID,
    t.OP_TYPE,
CASE
        WHEN t.OP_TYPE = '2' THEN
        t1.MODEL_CODE ELSE t.OP_VALUE 
    END AS OP_VALUE 
FROM
    bas_early_warning_setting_msg t
    LEFT JOIN bas_model_manage t1 ON t.OP_VALUE = t1.MODEL_ID 
WHERE
    t.IS_USE = 'Y' 
    AND FIND_IN_SET(t.WARNING_SETTING_ID, #warningSettingIds#) > 0
ORDER BY
    t.WARNING_SETTING_ID,
    t.ORDER_NUM