<%@ page language="java" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<div class="easyui-layout" data-options="fit:true">
	<!-- //左侧树 =======================================-->
	<div data-options="region:'west',split:true,minWidth:150,maxWidth:500"
		style="width: 50%;">
			<ul id="spaceComponent_tree" class="easyui-tree"></ul>		    
	</div>
	<div data-options="region:'center',border:false" style="width: 30%;">
		<div class="easyui-layout" data-options="border:false,fit:true">
			<div data-options="region:'west',split:false,border:false"
				style="width: 45px;">
				<table valign="middle" width="100%" border="0" cellspacing="0"
					cellpadding="0" style="margin: 60px 0 0 0;">
					<tr>
						<td align="center"><a href="#" class="easyui-linkbutton"
							onclick="moveComponentLeftToRight(true)" data-options="" style="margin-top: 80px;"><i
								class="blue iconfont icon-arrowrightdl"></i> </a></td>
					</tr>
					<tr>
						<td><br></td>
					</tr>
					<tr>
						<td align="center"><a href="#" class="easyui-linkbutton"
							onclick="moveComponentRightToLeft(false)" data-options=""><i
								class="blue iconfont icon-arrowleftdl"></i></a></td>
					</tr>
				</table>
			</div>
			
			<div data-options="region:'center'" title="已选组件">
				<div id="choosegrid"></div>
			</div>
		</div>
	</div>
</div>
	

<script src="//res.layui.com/layui/dist/layui.js" charset="utf-8"></script>

<script>
$(function(){
	//初始化组件树
	$('#spaceComponent_tree').tree({
		url : ctx + '/BasSpaceComponentDefinition/spaceComponentTree',
		checkbox:true,
		cascadeCheck : false,
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if (node) {
				$(this).tree('select', node.target);
			} else {
				$(this).tree('expand', root.target);
				$(this).tree('select', root.target);
			}
		}
	});
	
	//初始化左侧未选组件或栏目
	$('#choosegrid').datagrid({
		fit : true,
		singleSelect : false,
		rownumbers : true,
		fitColumns : true,
		pagination : false,
		columns : [ [ {
			field : 'ck',
			checkbox : true
		},{
			field : 'componentType',
			hidden : true
		},{
			field : 'componentId',
			hidden : true
		}, {
			field : 'componentName',
			title : '组件/栏目',
			width : 80
		} ] ]
	});
})

function moveComponentLeftToRight(){
	//获取选择组件的node
	var componentNodes = $('#spaceComponent_tree').tree('getChecked');
	
	if (!componentNodes||componentNodes.length==0) {
		alertInfo('请先选择左侧信息');
		return;
	}
	
	for(var k=0;k<componentNodes.length;k++){
		//移除掉选中的组件
		 $('#spaceComponent_tree').tree('remove',componentNodes[k].target);
		
		var index=0;
		chooseRows=$('#choosegrid').datagrid('insertRow',{
			index : index,
			row : {
				componentType :'2',
				componentId : componentNodes[k].id,
				componentName:componentNodes[k].text
			}
		});
		index++;
	}	 
}


function moveComponentRightToLeft(){
	var componentRoot=$('#spaceComponent_tree').tree('getRoot');
	
	var chooseRows=$('#choosegrid').datagrid('getChecked');
	if(chooseRows==null||chooseRows.length==0){
		alert('请先选择左侧信息');
	}
	
	for(var i=0;i<chooseRows.length;i++){
		var index=$('#choosegrid').datagrid('getRowIndex',chooseRows[i]);
		$('#choosegrid').datagrid('deleteRow',index);	
		$('#spaceComponent_tree').tree('append', {
			parent: componentRoot.target,
			data: [{
				id: chooseRows[i].componentId,
				text: chooseRows[i].componentName
			}]
		});
	}
}
</script>

	