
var pubContactOrgMiddleLogGrid = $("#pubContactOrgMiddleLogGrid");
$(function(){
	initPubContactOrgMiddleLogGrid();
});


/**
 * 初始化
 */
function initPubContactOrgMiddleLogGrid(){
	pubContactOrgMiddleLogGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#pubContactOrgMiddleLogGridTbar",
	    url:ctx+'/pubContactOrgMiddleLog/pageAll',
	    columns:[[
	    // {
		// 	field:'opt',title:'明细',width:40,align:'center',
		// 	formatter:function(value,row,index){
		// 		return '<div onclick="pubContactOrgMiddleLogFormDetail('+row.middleLogId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		// }},
	    {field:'logMsg',title:'日志内容',width:100,align:'center',halign:'center',sortable:true},
	    {field:'logTypeText',title:'日志类型',width:100,align:'center',halign:'center'},
	    {field:'logTime',title:'日志发生时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccountText',title:'创建人',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			pubContactOrgMiddleLogFormDetail(row.middleLogId);
	    }
	});
	
    pubContactOrgMiddleLogGrid.datagrid('doCellTip');
    var pager = pubContactOrgMiddleLogGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('pubContactOrgMiddleLogGrid',menuName)
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function pubContactOrgMiddleLogFormDetail(id){
	var content=basegrid.pubContactOrgMiddleLogGrid('getSelected').logMsg;
	$('#pubContactOrgMiddleLog_dialog').dialog({
		content:content
	});
	$('#pubContactOrgMiddleLog_dialog').dialog('open');
	// openDetailDialog({
	// 	title : "查看记录",
	// 	maximized : true,
	// 	contenturl:"/GenForm/form?formcode=PubContactOrgMiddleLog&isdetail=true&id="+id
	// });
}

function showDetail(){

}


/**
 * 重新加载
 */
function reloadPubContactOrgMiddleLog(){
	pubContactOrgMiddleLogGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchPubContactOrgMiddleLog(){
	pubContactOrgMiddleLogGrid.datagrid('load',{

		logType : $("#logTypeQuery").combobox("getValue")
	});
}


/**
 * 增加
 */
function addPubContactOrgMiddleLog() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=PubContactOrgMiddleLog",
		submiturl : "/pubContactOrgMiddleLog/savePubContactOrgMiddleLog?formcode=PubContactOrgMiddleLog",
		callback : reloadPubContactOrgMiddleLog
	});
	
}


/**
 * 修改
 */
function editPubContactOrgMiddleLog() {

	var row = pubContactOrgMiddleLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubContactOrgMiddleLog&id=" + row.middleLogId,
		submiturl:"/pubContactOrgMiddleLog/savePubContactOrgMiddleLog?formcode=PubContactOrgMiddleLog",
		callback : reloadPubContactOrgMiddleLog
	});
}


/**
 * 删除
 */
function delPubContactOrgMiddleLog() {

	var row = pubContactOrgMiddleLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/pubContactOrgMiddleLog/delPubContactOrgMiddleLog",
				data : {
					id : row.middleLogId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						pubContactOrgMiddleLogGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
